import re, os

# local
from cpushare.config import *

def nr_system_cpus():
	f = file('/proc/stat')
	lines = f.readlines()
	f.close()

	cpuN = re.compile(r'cpu\d+\s+')
	nr_cpus = 0
	for line in lines:
		if cpuN.match(line):
			nr_cpus += 1
	return nr_cpus

def max_ram_mbytes_per_cpu():
	meminfo = file('/proc/meminfo')
	anonpages = 0 # newer kernels split anonpages from mapped
	while 1:
		line = meminfo.readline()
		if not line:
			break
		m = re.match(r'MemFree:\s+(\d+)\skB$', line)
		if m:
			memfree = int(m.group(1))
			assert memfree >= 0
			continue
		m = re.match(r'Active:\s+(\d+)\skB$', line)
		if m:
			active = int(m.group(1))
			assert active >= 0
			continue
		m = re.match(r'Inactive:\s+(\d+)\skB$', line)
		if m:
			inactive = int(m.group(1))
			assert inactive >= 0
			continue
		m = re.match(r'Slab:\s+(\d+)\skB$', line)
		if m:
			slab = int(m.group(1))
			assert slab >= 0
			continue
		m = re.match(r'PageTables:\s+(\d+)\skB$', line)
		if m:
			pagetables = int(m.group(1))
			assert pagetables >= 0
			continue
		m = re.match(r'Mapped:\s+(\d+)\skB$', line)
		if m:
			mapped = int(m.group(1))
			assert mapped >= 0
			continue
		m = re.match(r'AnonPages:\s+(\d+)\skB$', line)
		if m:
			anonpages = int(m.group(1))
			assert anonpages >= 0
			continue
	try:
		# heuristic to detect if running on the livecd
		os.stat('/build')
		os.stat('/deletelogs.sh')
		os.stat('/linuxrc')
		os.stat('/seccomp-loader')
		os.stat('/order-magic.cpu')
	except OSError:
		ramfs = 0
	else:
		ramfs = int(os.popen('du -sk /').read())
	ret = memfree + active + inactive - mapped - anonpages - ramfs - slab - pagetables
	#print 'Memory: free %r active %r inactive %r mapped %r anonpages %r ' \
	#      'ramfs %r slab %r pagetables %r total %r' % (memfree, active,
	#						   inactive, mapped, anonpages,
	#						   ramfs, slab,
	#						   pagetables, ret)
	ret = max(1, (ret / 1024 - MAX_RAM_MBYTES_PER_CPU_MARGIN) / nr_system_cpus() - CACHE_MBYTES_MAX_SIZE)
	#print 'max_ram_mbytes_per_cpu() = %r' % ret
	return ret
