/*
** $Id: strftime.c,v 1.1 2004/02/08 05:03:25 mrsam Exp $
*/
#include	<string.h>
#include	<time.h>
#include	"sqwebmail.h"
#if	HAVE_SQWEBMAIL_UNICODE
#include	"unicode/unicode.h"
#endif

extern const char *sqwebmail_system_charset;
extern const char *sqwebmail_content_charset;

#if	HAVE_LOCALE_H
#if	HAVE_SETLOCALE
#if	HAVE_SQWEBMAIL_UNICODE
#if	USE_LIBCHARSET || HAVE_LANGINFO_CODESET

size_t strftime_unicode(char *s, size_t max, const char *fmt,
			const struct tm *tm)
{
const struct unicode_info	*system_chset;
const struct unicode_info	*content_chset;
char *sfmt;
char sbuf[128] = "\0";
char *buf;

	if (sqwebmail_system_charset && *sqwebmail_system_charset
	    && sqwebmail_content_charset && *sqwebmail_content_charset
	    && strcasecmp(sqwebmail_system_charset, "ASCII")
	    && (system_chset = unicode_find(sqwebmail_system_charset))
	    && (content_chset = unicode_find(sqwebmail_content_charset))
	    && (sfmt = unicode_xconvert(fmt, content_chset, system_chset)))
	{
		strftime(sbuf, sizeof(sbuf), sfmt, tm);
		sbuf[sizeof(sbuf)-1] = 0;
		free(sfmt);
		if ((buf = unicode_xconvert(sbuf, system_chset, content_chset)))
		{
			strncpy(s, buf, max);
			free(buf);
		}
		else
		{
			strncpy(s, sbuf, max);
		}
		return strlen(s);
	}
	else
	{
		return strftime(s, max, fmt, tm);
	}

}

#endif
#endif
#endif
#endif

