#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at:
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
# 
#
# author : Jd <jd_jedi@users.sourceforge.net>
#

# KVM specific ui implementation required by the client.

import gtk, gtk.glade, gobject
import traceback

from convirt.core.model.PlatformUIHelper import PlatformUIHelper
from PlatformUIUtils import AddNodeDialog
import convirt.core.utils.constants

from convirt.core.utils.utils import get_path, get_prop, is_host_remote


from convirt.core.utils.utils import XMConfig
from VMSettings import VMSettingsDlg
constants = convirt.core.utils.constants 


## TODO : Move this to ui utils/platform utils.
from convirt.client.dialogs import showmsg
#### TODO :
# Make left_nav partof the callback             


my_platform = convirt.core.platforms.kvm.kvm_constants.my_platform

from KVMSettings import KVMSettingsDlg

from convirt.client.VMInfoHelper import VMInfoHelper

class KVMUIHelper(PlatformUIHelper):
    def __init__(self, ui_context, platform_config):
        PlatformUIHelper.__init__(self, ui_context, platform_config)

    def show_add_server_dialog(self, mode, group_name, platform,
                               existing_node=None,
                               parentwin=None):
        
        add_node_dlg = AddNodeDialog(self.manager,
                                     self.client_config,
                                     self.left_nav)

        if existing_node is not None and existing_node.platform != my_platform :
            add_node_dlg.dialog.destroy()
            raise Exception("Wrong Server passed. Expecting %s, got %s" %
                            (my_platform, existing_node.platform))
            
        ret = add_node_dlg.show(mode, group_name, platform = my_platform,
                                existing_node = existing_node,
                                parentwin = parentwin)
        return ret


    def get_vm_settings_dialog(self, mode, ctx, mainwin):
        return KVMSettingsDlg(mode, ctx, mainwin)

    def get_vm_info_helper(self):
        return VMInfoHelper()



