extern "C" {
#include <complearn/complearn.h>
#include <qsearch/qsearch.h>
};
#include <timeframe.h>
#include <springymatrix.h>
#include <springball.h>
#include <QGLViewer/qglviewer.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <qfiledialog.h>
#include <qlistbox.h>
#include <assert.h>

class MWGen;

class OkDialog : public QDialog {

  Q_OBJECT

  public:
  OkDialog(const char *msg);
};
class ErrorDialog : public QDialog {

  Q_OBJECT

  public:
  ErrorDialog(const char *errmsg);
};

class HelpAboutDialog : public QDialog {

  Q_OBJECT

  public:
  HelpAboutDialog(void);
};

class HelpDialog : public QDialog {

  Q_OBJECT

  public:
  HelpDialog(void);
};

class CompressionDialog : public QDialog {

  Q_OBJECT

  QListBox *w;
  CompLearnRealCompressor **rctarget;
  int s;
  public:
    CompressionDialog(CompLearnRealCompressor **rc) {
      w = new QListBox( 0, 0 );
      assert(rt != 0);
      rctarget  = rc;
      char **cl = complearn_environment_compressor_list();
      int i;
      w->setCaption("Please choose compressor:");
      for (i = 0; cl[i]; i += 1)
        w->insertItem( QString(cl[i]) );
      w->show();
      connect(w, SIGNAL( clicked(QListBoxItem *) ), this,
                 SLOT( doCompressorChangeSelection(QListBoxItem *) ) );
    }
    int getsel(void) { return w->currentItem(); }
  public slots:
    void doCompressorChangeSelection(QListBoxItem *qbi) {
      QString s = qbi->text();
      const char *cnam = s.data();
      std::cerr << "Would change to " << cnam << std::endl;
      *rctarget = complearn_environment_load_compressor_named(cnam);
      assert(*rctarget != 0);
      w->close();
    }
};

class SBViewer : public QGLViewer
{
  Q_OBJECT

  MWGen *_win;
  bool _light_mode_already_set;
  bool _wireframe_on;
  bool _made_quadrics;
  bool _labels_on;
  bool _gravity_on;
  char *_dist_fname;
  char *_tree_fname;
  qglviewer::Camera *sc;
  void set_light_mode(void);
  void make_lights(void);
  LabeledMatrix *_lm;
  CompLearnRealCompressor *_rc;
  QSearchTreeMaster *_tm;
  TimeFrame _tf;
  SpringBallSystem *_sbs;
  SpringyMatrixTreeWatcher *_smtw;
  void make_quadrics(void);
  GLUquadric *_sphere_quadric, *_qspringcyl, *_smallkspherequad;
  void do_init(int argc, char **argv);
//private slots:
  void fileExit();
  void lookTowardsCOM();
public slots:
  void fileAbout();
  void fileHelp();
  void fileChangeCompressor();
  void treeCalculate();
  void distmatSave();
  void distmatOpen();
  void distmatNew();
  void treeOpen();
  void treeSave();

protected :
  virtual void draw();
  virtual void init();
  virtual QString helpString() const;
  virtual void keyPressEvent(QKeyEvent *);
  void draw_sphere(int whichid, int issmall);
  void draw_spring(int i1, int i2);
//public: Viewer() : wireframe(true) { } ;
  public: SBViewer(int argc, char **argv);
  SBViewer(QWidget *, const char *str);
  void toggleWireframe(void);
  void toggleLabels(void);
  void toggleGravity(void);
  void readAndAnalyzeDistanceMatrix(const char *);
};
