unit ulatex;
 
{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998-2002 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec les auteurs : yves.ouvrard@collatinus.org }


interface

uses Classes;
 
{Pour la version Lazarus, formatage LaTeX des rsultats affichs}
function Formate_latex (texte, analyses : TStrings) : TStringlist;
 
 
{Pour la version console, lemmatisation et formatage du fichier source}
function SortieLatex(source : string) : TStringList;

implementation

uses umorpho, utiles, regexpr;

function Formate_latex (texte, analyses : TStrings) : TStringlist;
var
   t : string;
   i, il : integer;
begin
   result := TStringList.Create;
   with result do
   begin
      add('\documentclass[12pt]{article}');
      add('\usepackage[T1]{fontenc}');
      add('\usepackage[latin1]{inputenc}');
      add('\usepackage{geometry}');
      add('\usepackage[frenchb]{babel}');
      add('\usepackage{multicol}');
      add(' ');
      add('\geometry{a4paper, left=1in, right=1in, top=1in, bottom=1in}');
      add('\begin{document}');

      // pour respecter les sauts de ligne :
      for i := 0 to texte.count - 1 do
         begin
            t := '';
            for il := 1 to length(texte[i])
	       do if texte[i][il] = '-' // chapper les '-'
	          then t := t + '\-'
	       else t := t + texte[i][il];
            add (t);
	 end;;

      // sauter une ligne pour le saut de paragraphe
      add (' ');
      // dfinition des colonnes
      add('\begin{multicols}{2}');
      add('\begin{itemize}');
      // liste de mots
      for i := 1 to analyses.count - 1 do
         add( '\item ' + analyses[i]);
      add('\end{itemize}');
      add('\end{multicols}');
      add('\end{document}');
   end;
end;

function SortieLatex(source : string) : TStringList;
var
   l : TStringList;
   t : AnsiString; 
   mot : string;
   LeVoc : TStringList;
   analyseMot : TStringList;
   inventum : Boolean;
   i, il : integer;
begin
result := TStringList.Create;
with result do
   begin
      add('\documentclass[12pt]{article}');
      add('\usepackage[T1]{fontenc}');
      add('\usepackage[latin1]{inputenc}');
      add('\usepackage{geometry}');
      add('\usepackage[frenchb]{babel}');
      add('\usepackage{multicol}');
      add(' ');
      add('\geometry{a4paper, left=1in, right=1in, top=1in, bottom=1in}');
      add('\begin{document}');
 
      // charger le fichier dans la chane t
      l := TStringList.Create;
      l.LoadFromFile (source);
      t := '';
      // pour respecter les sauts de ligne :
      for i := 0 to l.count - 1 do
         begin
            for il := 1 to length(l[i]) 
	       do if l[i][il] = '-' // chapper les '-'
	          then t := t + '\-'
	       else t := t + l[i][il]; 
	 end;
      add (t);
      l.free;

      // sauter une ligne pour le saut de paragraphe
      add (' ');
      // dfinition des colonnes
      add('\begin{multicols}{2}');
      add('\begin{itemize}');
      // liste de mots
      mot := '';
      LeVoc := TStringList.Create;
      LeVoc.Sorted := True;
      LeVoc.Duplicates := DupIgnore;
      for i := 1 to length (t) do
         if t[i] in lettres
            then mot := mot + t[i]
         else
           begin
              if mot > '' then
                begin
                  analyseMot := AnalysesDe (mot, inventum, maVocSeul);
                  LeVoc.add( '\item ' + analyseMot.text );
                  analyseMot.free;
                end;
              mot := '';
           end;

      addstrings(LeVoc);
      LeVoc.Free;
      add('\end{itemize}');
      add('\end{multicols}');
      add('\end{document}');
   end;
end;

end.
