/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#include <Inventor/misc/SoContextHandler.h>
#include <Inventor/lists/SbList.h>

class socontexthandler_cbitem {
public:
  socontexthandler_cbitem(void) { }
  
  int operator==(const socontexthandler_cbitem & theother) {
    return 
      this->func == theother.func &&
      this->closure == theother.closure;
  }
  
  SoContextHandler::ContextDestructionCB * func;
  void * closure;
};


static SbList <socontexthandler_cbitem> * socontexthandler_cblist;

/*!
  This method \e must be called by client code which destruct a
  context, to guarantee that there are no memory leaks upon context
  destruction (texture objects and display lists must be deleted). 
*/
void
SoContextHandler::destructingContext(uint32_t contextid)
{
  const int n = socontexthandler_cblist ? 
    socontexthandler_cblist->getLength() : 0;
  for (int i = 0; i < n; i++) {
    const socontexthandler_cbitem & item = 
      (*socontexthandler_cblist)[i];
    item.func(contextid, item.closure);
  }
}

void
SoContextHandler::addContextDestructionCallback(ContextDestructionCB * func,
                                                void * closure)
{
  if (socontexthandler_cblist == NULL) {
    socontexthandler_cblist = new SbList <socontexthandler_cbitem>;
  }
  socontexthandler_cbitem item;
  item.func = func;
  item.closure = closure;
  socontexthandler_cblist->append(item);
}

void
SoContextHandler::removeContextDestructionCallback(ContextDestructionCB * func, void * closure)
{
  if (socontexthandler_cblist) {
    socontexthandler_cbitem item;
    item.func = func;
    item.closure = closure;

    int idx = socontexthandler_cblist->find(item);
    if (idx >= 0) {
      socontexthandler_cblist->removeFast(idx);
    }
    else {

    }
  }
}
