#include "cp_types.h"
#include "cp_proto.h"

complex ss_view(struct s_data *q,complex pt,int flag,int *front)
     /* Convert real to apparent pt on sphere (flag=1) or vice verse 
(flag=0), based on disp_trans settings of screen q. front=1 if pt 
is on front of sphere. In/output pts in sph coords. */ 
{
  double x,y,z,xx,yy,zz;
  complex ans;

  x=sin(pt.im)*cos(pt.re);
  y=sin(pt.im)*sin(pt.re);
  z=cos(pt.im);
  if (flag)
  {
    xx=q->disp_trans[0][0]*x+
    q->disp_trans[0][1]*y+
    q->disp_trans[0][2]*z;
    yy=q->disp_trans[1][0]*x+
    q->disp_trans[1][1]*y+
    q->disp_trans[1][2]*z;
    zz=q->disp_trans[2][0]*x+
    q->disp_trans[2][1]*y+
    q->disp_trans[2][2]*z;
  }
  else
  {
    xx=q->disp_inv_trans[0][0]*x+
    q->disp_inv_trans[0][1]*y+
    q->disp_inv_trans[0][2]*z;
    yy=q->disp_inv_trans[1][0]*x+
    q->disp_inv_trans[1][1]*y+
    q->disp_inv_trans[1][2]*z;
    zz=q->disp_inv_trans[2][0]*x+
    q->disp_inv_trans[2][1]*y+
    q->disp_inv_trans[2][2]*z;
  }
  if (xx>=0) *front=1;else *front=0;
  ans.re=aTan2(yy,xx);
  ans.im=acos(zz);
  return ans;
} /* ss_view */

complex proj_to_sph(double a,double b)
     /* project (a,b) in plane to sphere in sph coords. */
{
  double dist,z;
  complex ans;

  if ((dist=a*a+b*b)>1.0) 
    {ans.re=ans.im=0.0;return ans;} /* default is north pole */
  z=sqrt(1-dist);
  ans.re=aTan2(b,a);
  ans.im=acos(z);
  return ans;
} /* proj_to_sph */

