#include "cp_types.h"
#include "cp_proto.h"

/* returns best radius at vert v to get anglesum aim, via binary 
search method. (Doesn't use overlaps). First guess = r. */

extern int iterates;

double s_radcalc(struct p_data *p,int v,double r,double aim,int *chgflag)
{
  int n,increase_r,decrease_r,r_too_big,r_too_small,sign,flag=0;
  double bestcurv,lower=0.15,upper=0.15,upcurv,lowcurv,target,factor=0.15;

  target=aim;
  s_anglesum_overlap(p,v,r,&bestcurv,&flag);
  if (flag) return r; /* incompatibility noted */
  sign=s_deriv_sign(p,v,r);
  r_too_small=(((bestcurv>(aim+okerr)) && (sign<0)) ||
	       ((bestcurv<(aim+okerr)) && (sign>0)));
  r_too_big = (((bestcurv<(aim+okerr)) && (sign<0)) ||
	       ((bestcurv>(aim+okerr)) && (sign>0)));
  target+=(1/(3*p->packK_ptr[v].num))*(aim-bestcurv)*sign;
	
  if (r_too_small)
    {
      if ((r*(1.0+factor))<M_PI)
	upper=r*(1.0+factor);
      else upper=r + ((M_PI-r)/2.0);
      s_anglesum_overlap(p,v,upper,&upcurv,&flag);
      (*chgflag)++;
      if (upcurv>target) return upper;
    }
  else if (r_too_big)
    {
      lower=r*(1.0-factor);
      s_anglesum_overlap(p,v,lower,&lowcurv,&flag);
      (*chgflag)++;
      if (lowcurv<target) return lower;
    }
  else return r;
  (*chgflag)++;
  for (n=1;n<=iterates;n++)
    {
      sign=s_deriv_sign(p,v,r);
      increase_r=(((bestcurv>(target+okerr)) && (sign<0)) ||
		  ((bestcurv<(target+okerr)) && (sign>0)));
      decrease_r=(((bestcurv>(target+okerr)) && (sign>0))  ||
		  ((bestcurv<(target+okerr)) && (sign<0)));
      if (increase_r) 
	{
	  lower=r;
	  lowcurv=bestcurv;
	  r+= (target-bestcurv)*(upper-r)/(upcurv-bestcurv);	  
	}
      else if (decrease_r)
	{
	  upper=r;
	  upcurv=bestcurv;
	  r -= (bestcurv-target)*(lower-r)/(lowcurv-bestcurv);
	}
      else return r;
      s_anglesum_overlap(p,v,r,&bestcurv,&flag);
    }
  return r;
} /* s_radcalc */

