#include "cp_types.h"
#include "cp_proto.h"

/* compute cents of face, indx at origin, next vert in standard 
relation */

int place_face(struct p_data *p,int face,int indx)
{
  int a,k,n;
  double r,r2,ovlp,erad,s,ss1,ss2,s1,s2;
  struct R_data *pR_ptr;

  pR_ptr=p->packR_ptr;
  if (face>p->facecount || face<1 || indx <0 || indx >2) return 0;
  a=p->faces[face].vert[indx];
  k=p->faces[face].vert[(indx+1) % 3];
  n=p->faces[face].vert[(indx+2) % 3];
  if (p->overlap_status)
    ovlp=p->packK_ptr[a].overlaps[nghb(p,a,k)];
  else ovlp=1.0;
  if (p->hes<0) /* hyp case */
    {
      s1=pR_ptr[a].rad;
      s2=pR_ptr[k].rad;
      if (s1<=0)
	{
	  s1=pR_ptr[a].rad=.01;
	  strcpy(msgbuf,"Circle at origin had "
		 "infinite radius; radius reset.");
	  emsg();
	}
      pR_ptr[a].center.re=0; pR_ptr[a].center.im=0;
      if (s2<=0) /* if next one is infinite radius */
	{
	  pR_ptr[k].center.re=1;pR_ptr[k].center.im=0;
	  erad=(1-s1)/(1+s1);
	  pR_ptr[k].rad=(-1)*(1-erad*erad)/(2.0+2.0*erad*ovlp);
	}
      else
	{
	  ss1=s1*s1;ss2=s2*s2;
	  s=exp( acosh((1/(4.0*s1*s2))*((1+ss1)*(1+ss2)
					+(1-ss1)*(1-ss2)*ovlp) ) );
	  pR_ptr[k].center.re=(s-1)/(s+1);
	  pR_ptr[k].center.im=0.0;
	}
    }
  else if (p->hes>0) /* sphere case */
    {
      /* alpha at north pole */
      pR_ptr[a].center.re=pR_ptr[a].center.im=0.0; 
      /* next out pos x-axis */
      pR_ptr[k].center.re=0.0;
      pR_ptr[k].center.im=pR_ptr[a].rad+pR_ptr[k].rad;
    }
  else /* eucl case */
    {
      /* alpha at origin */
      r=pR_ptr[a].rad;
      pR_ptr[a].center.re=0;pR_ptr[a].center.im=0; 
      /* next on x-axis */
      r2=pR_ptr[k].rad;
      pR_ptr[k].center.re=sqrt(r*r+r2*r2+2*r*r2*ovlp);
      pR_ptr[k].center.im=0; 
    }
  fancy_comp_center(p,n,nghb(p,n,a),0,1,0,1,1,toler);
  return 1;
} /* place_face */
