#include "cp_types.h"
#include "cp_proto.h"

/* repacking routine using original riffle method with uniform
   neighbor approximation, but with "light" pack structure and 
   options for perron up/down, regular. 

   repack_method: 3 = perron up, 4=perron down, else perron.

   All aims assumed to be 2pi (at interior) and no overlaps,
   all interior radii positive (ie., finite), and all radii are
   s-radii (ie., exp(-h) if h>0, neg if h<0, h the hyp radius.)

   Return count of adjustments when every interior meets tolr
   or when count exceeds passes. 

   See h_riffle_stuff.c for the routines. */

int h_pack_light_uniform(struct p_light *pl,int passes,double tolr,
		      int repack_method,long *elapsetime)
{
  int i,n,num,tick,count=0,int_count,trip_flag,go_flag;
  double r2,m1,m2,sr,t1,t2,t3;
  double first_m,d,b,ang_sum,rad,denom,twor,m2pi=2.0*M_PI;
  int *indices=pl->var_indices;
  double *radii=pl->radii;
  long timein;
  struct rusage RU;

  int_count=pl->counts[2];
  getrusage(RUSAGE_SELF,&RU);
  timein=RU.ru_utime.tv_sec;
  while(1)
    {
      count++;
      n=trip_flag=0;
      tick=1;
      while(n<int_count) /* loop through packing */
	{
	  n++;
	  /* compute angle-sum */
	  ang_sum=0.0;
	  rad=radii[n]; /* this should be positive */
	  num=indices[tick++];
	  r2=radii[indices[tick++]];
	  first_m=m2=(r2>0) ? (1-r2)/(1-rad*r2) : 1;
	  twor = 2.0*rad; 
	  for (i=2;i<=num;i++)	/* loop through petals */
	    {
	      m1=m2;
	      r2 = radii[indices[tick++]];
	      m2 = (r2>0) ? (1-r2)/(1-rad*r2) : 1;
	      ang_sum += acos(1.0-twor*m1*m2); /* angle calc */
fprintf(stderr,"%.14f %.14f\n",ang_sum,acos(1.0-twor*m1*m2));
	    } 
	  ang_sum += acos(1.0-twor*m2*first_m); /* get last angle */
	  go_flag=1;
	  if (repack_method==3 && ang_sum>m2pi) /* perron_up */
	    {if (ang_sum>(m2pi+tolr)) trip_flag++;}
	  else if (repack_method==4 && ang_sum<m2pi) /* perron_down */
	    {if (ang_sum<(m2pi-tolr)) trip_flag++;}
	  else if (ang_sum>(m2pi+tolr) || ang_sum<(m2pi-tolr))
	    {trip_flag++;}
	  else go_flag=0;
	  if (go_flag) /* note, we adjust even if not out of tolr,
			  but we don't trip trip_flag */
	    {
	      /* adjust radius using 'uniform' method */
	      denom=1.0/(2.0*num);
	      d=sin(m2pi*denom);
	      b=sin(ang_sum*denom);
	      sr=sqrt(rad);
	      r2=(b-sr)/(b*rad-sr);
	      if (r2>0)
		{
		  t1=1-r2;
		  t2=2*d;
		  t3=t2/(sqrt(t1*t1+t2*t2*r2)+t1);
		  radii[n]=t3*t3;
		}
	      else
		radii[n]=d*d; 
	    }
	} /* end of while */
      if (!trip_flag || count>passes) /* out of passes or no adjust's */
	{
	   getrusage(RUSAGE_SELF,&RU);
	   *elapsetime=RU.ru_utime.tv_sec-timein;	
	   return count;
	}
    } /* end of endless while */
} /* h_pack_light_uniform */

