#include "cp_types.h"
#include "cp_proto.h"

/* double packing across some or all bdry comps (get compact complex). 
Error should leave pack unharmed, but there is not a lot of checking. */

int double_K(struct p_data *p,char *datastr)
{
  int i,j,jj,k,final_node_count,node,num,new,vert,hits;
  int *newflower,*holdflower;
  int v,*oldnew=NULL,*oldnewflag=NULL;
  double *newol,*holdol;
  struct K_data *pK_ptr=NULL,*newK_ptr=NULL;
  struct R_data *pR_ptr=NULL,*newR_ptr=NULL;
  struct Vertlist *vertlist=NULL,*trace=NULL;
  char *endptr=NULL;

  /* check suitability */
  if (p->num_bdry_comp==0) 
    return 0; /* already compact */
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
	&Vlist,&Elist,&Flist,&region,pathlist,pathlength)) == NULL )
    {
      datastr[0]='b';datastr[1]='\0';
      if ((vertlist=Node_link_parse(p,datastr,&endptr,&hits,
	   &Vlist,&Elist,&Flist,&region,pathlist,pathlength))==NULL)
	return 0;  /* some combinatoric error */
    }
  node=p->nodecount;
  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr; 
  for (i=1;i<=node;i++) pK_ptr[i].util_flag=0;
  trace=vertlist;
  while (trace) /* mark all bdry verts to be identified.
		   Illegal to have v hanging or to have v
		   and one of its 'middle' petals (ie. not 
		   first or last) marked; abort process.*/
    {
      if (pK_ptr[v=trace->v].bdry_flag 
	  && !pK_ptr[v].util_flag)
	{
	  vert=v;
	  for (j=1;j<pK_ptr[v].num;j++)
	    if (pK_ptr[v].num<2
		|| pK_ptr[pK_ptr[v].flower[j]].util_flag)
	      {vert_free(&vertlist);return 0;}
	  pK_ptr[v].util_flag=1;
	  v=pK_ptr[vert].flower[0];
	  while (v!=vert)
	    {
	      for (j=1;j<pK_ptr[v].num;j++)
		if (pK_ptr[v].num<2
		    || pK_ptr[pK_ptr[v].flower[j]].util_flag)
		  {vert_free(&vertlist);return 0;}
	      pK_ptr[v].util_flag=1;
	      v=pK_ptr[v].flower[0];
	    }
	}
      trace=trace->next;
    }

  /* create new data areas */
  if ((newK_ptr=(struct K_data *)
       calloc((size_t)(2*node+1),sizeof(struct K_data)))==NULL)
    return 0;
  if ((newR_ptr=(struct R_data *)
       calloc((size_t)(2*node+1),sizeof(struct R_data)))==NULL)
    {free(newK_ptr);return 0;}
  if (!alloc_pack_space(p,2*p->nodecount,1)) 
    {free(newK_ptr);free(newR_ptr);return 0;}
  for (i=1;i<=node;i++)
    {
      newK_ptr[i]=newK_ptr[i+node]=pK_ptr[i];
      newR_ptr[i]=newR_ptr[i+node]=pR_ptr[i];
      num=newK_ptr[i].num;
      newflower=(int *)calloc((size_t)(num+1),sizeof(int));
      for (j=0;j<=num;j++) /* create new ptr */
	newflower[j]=pK_ptr[i].flower[j];
      newK_ptr[i].flower=newflower;
      newflower=(int *)calloc((size_t)(num+1),sizeof(int));
      for (j=0;j<=num;j++) /* change orientation */
	newflower[j]=pK_ptr[i].flower[num-j]+node;
      newK_ptr[i+node].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(double *)calloc((size_t)(num+1),sizeof(double));
	  for (j=0;j<=num;j++) /* create new ptr */
	    newol[j]=pK_ptr[i].overlaps[j];
	  newK_ptr[i].overlaps=newol;
	  newol=(double *)calloc((size_t)(num+1),sizeof(double));
	  for (j=0;j<=num;j++) /* change orientation */
	    newol[j]=pK_ptr[i].overlaps[num-j];
	  newK_ptr[i+node].overlaps=newol;
	}
    }
  oldnew=(int *)calloc((size_t)(2*node+1),sizeof(int));
  oldnewflag=(int *)calloc((size_t)(2*node+1),sizeof(int));
  for (i=1;i<=2*node;i++) 
    {
      oldnewflag[i]=0; /* know new number ? */
      oldnew[i]=i;
    }

  /* begin processing boundary components */
  trace=vertlist;
  while (trace)
    {
      if (newK_ptr[v=trace->v].bdry_flag)
	{
	  do /* take care of this whole bdry component */
	    {
	      oldnew[v+node]=v;
	      oldnewflag[v+node]=1;
	      if (p->hes<0 && pR_ptr[v].rad<=0) pR_ptr[v].rad=.5;
	      /* fix flower */
	      num=pK_ptr[v].num;
	      newK_ptr[v].num=2*num;
	      newK_ptr[v].bdry_flag=0;
	      newR_ptr[v].aim=2.0*M_PI;
	      if (num<2) goto ABORT;   /* flower too small */
	      newflower=(int *)calloc((size_t)(2*num+1),
				      sizeof(int));
	      for (j=0;j<=num;j++) 
		newflower[j]=newK_ptr[v].flower[j];
	      for (j=1;j<num;j++)
		newflower[j+num]=newK_ptr[v+node].flower[j];
	      free(newK_ptr[v].flower);
	      newK_ptr[v].flower=newflower;
	      newK_ptr[v].flower[2*num]=newK_ptr[v].flower[0];
	      if (p->overlap_status)
		{
		  newol=(double *)calloc((size_t)(2*num+1),sizeof(double));
		  for (j=0;j<=num;j++) 
		    newol[j]=newK_ptr[v].overlaps[j];
		  for (j=1;j<num;j++)
		    newol[j+num]=newK_ptr[v+node].overlaps[j];
		  free(newK_ptr[v].overlaps);
		  newK_ptr[v].overlaps=newol;
		  newK_ptr[v].overlaps[2*num]=newK_ptr[v].overlaps[0];
		}
	      /* remove refs to old nums; flowers get only good numbers */
	      for (j=0;j<=pK_ptr[v].num;j++) 
		{
		  jj=newK_ptr[v+node].flower[j];
		  for (k=0;k<=newK_ptr[jj].num;k++)
		    if (oldnewflag[vert=newK_ptr[jj].flower[k]])
		      newK_ptr[jj].flower[k]=oldnew[vert];
		}
	      v=pK_ptr[v].flower[0];
	    }
	  while (v!=trace->v);
	}
      trace=trace->next;
    }
  vert_free(&vertlist);
  /* throw out unused numbs, replacing from top */
  final_node_count=2*node;
  for (i=node+1;i<=2*node;i++) if (oldnewflag[i])
    {
      while (oldnewflag[final_node_count]) final_node_count--;
      if ((new=final_node_count)>i) 
	/* swap nums: good data 'new' goes to opening at i. */
	{
	  for (j=0;j<=newK_ptr[new].num;j++)
	    {
	      jj=newK_ptr[new].flower[j];
	      for (k=0;k<=newK_ptr[jj].num;k++)
		if (newK_ptr[jj].flower[k]==new)
		  newK_ptr[jj].flower[k]=i;
	    }
	  newR_ptr[i]=newR_ptr[new];
	  holdflower=newK_ptr[i].flower; 
	  if (p->overlap_status) holdol=newK_ptr[i].overlaps;
	  newK_ptr[i]=newK_ptr[new];
	  newK_ptr[new].flower=holdflower; 
	  if (p->overlap_status) newK_ptr[new].overlaps=holdol;
				/* need old pointers to throw out later */
	  oldnewflag[new]=1;
	  oldnewflag[i]=0;
	}
    }
  /* move packdata ptrs, clean up, and leave */
  for (i=1;i<=p->nodecount;i++) free(pK_ptr[i].flower);
  if (p->overlap_status)
    for (i=1;i<=p->nodecount;i++) free(pK_ptr[i].overlaps);
  free(pK_ptr);free(pR_ptr);
  free(oldnewflag);free(oldnew);
  p->nodecount=final_node_count;
  for (i=p->nodecount+1;i<=2*node;i++) 
    {
      free(newK_ptr[i].flower);
      if (p->overlap_status) free(newK_ptr[i].overlaps);
      newK_ptr[i].flower=NULL;
    }
  p->packK_ptr=newK_ptr;
  p->packR_ptr=newR_ptr;
  alloc_pack_space(p,p->nodecount,1);
  complex_count(p,0);
  fillcurves(p);
  facedraworder(p,0);
  return 1;
 ABORT:
  {
    for (i=1;i<=2*node;i++) free(newK_ptr[i].flower);
    if (p->overlap_status)
      for (i=1;i<=2*node;i++) free(newK_ptr[i].overlaps);
    if (newK_ptr) free(newK_ptr);
    if (newR_ptr) free(newR_ptr);
    if (oldnew) free(oldnew);
    if (oldnewflag) free(oldnewflag);
    vert_free(&vertlist); 
    return 0;
  }

} /* double_K */
