#include "cp_types.h"
#include "cp_proto.h"

/* return count of int verts not connected to alpha by 
interior edge-path. Int verts connected to alpha and nghb'ing 
bdry verts are marked. */

int diag_int_connected(struct p_data *p)
{
  int i,j,k;
  int hitflag=1,count=0;
  FILE *diagfp;

  if (p->packK_ptr[p->alpha].bdry_flag)
    {
      sprintf(msgbuf,"Diag: alpha is not an interior vert of pack.");
      msg();
      return 0;
    }
  for (i=1;i<=p->nodecount;i++) 
    p->packK_ptr[i].mark=0;
  p->packK_ptr[p->alpha].mark=1;
  /* mark int verts connected to alpha */
  while (hitflag) 
    {
      hitflag=0;
      for (i=1;i<=p->nodecount;i++)
	if (p->packK_ptr[i].mark)
	  for (j=0;j<=p->packK_ptr[i].num;j++)
	    if (!p->packK_ptr[(k=p->packK_ptr[i].flower[j])].bdry_flag
		&& !p->packK_ptr[k].mark)
	      p->packK_ptr[k].mark=hitflag=1;
    } /* end of while */
  /* count int verts not marked */
  for (i=1;i<=p->nodecount;i++)
    if (!p->packK_ptr[i].bdry_flag && !p->packK_ptr[i].mark)
      count++;
  /* one pass; mark nghbs of marked int verts */
  for (i=1;i<=p->nodecount;i++) 
    if (!p->packK_ptr[i].bdry_flag && p->packK_ptr[i].mark)
      for (j=0;j<=p->packK_ptr[i].num;j++)
	p->packK_ptr[p->packK_ptr[i].flower[j]].mark=1;
  if (count)
    {
      sprintf(msgbuf,"Diag: int verts of pack are not edge-connected;"
	      "%d verts are separated from alpha. Verts connected to "
	      "alpha are marked. Find diagnostic data in "
	      "'/tmp/diagnostic_log'",count);
      msg();
      diagfp=fopen("/tmp/diagnostic_log","a");
      fprintf(diagfp,"\nPacking %s, nodecount %d, "
	      "alpha=%d\n\n%d interior verts not "
	      "connected to alpha:\n\n   ",
	      p->file_name,p->nodecount,p->alpha,count);
      for (i=1;i<=p->nodecount;i++)
	if (!p->packK_ptr[i].bdry_flag && !p->packK_ptr[i].mark)
	  fprintf(diagfp,"%d  ",i);
      fprintf(diagfp,"\n\nEND\n\n");
      fclose(diagfp);      
      return count;
    }
  return 0;
} /* diag_int_connected */
