#include "cp_types.h"
#include "cp_proto.h"

/* Identify and count bdry/interior nodes, bdry/interior 
components,  Euler characteristic, genus, etc, for pack p. 
Stores indicators of bdry and int components in packdata (at
most MAX_COMPONENTS of each). flag means to set default color codes for
circles.*/

int complex_count(struct p_data *p,int flag)
{
  int i,node,count,bcount,new_vert,num_edges,m,n,v;
  int comp_count,ptr,k,j,fj,icount,more_flag,next_bdry;
  int max_components=MAX_COMPONENTS;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  /* some initialization and counting */
  node=p->nodecount;
  for (i=1;i<=max_components;i++) 
    p->bdry_starts[i]=p->int_starts[i]=0;
  bcount=0;
  comp_count=0;
  for (i=1;i<=node;i++) 
    {
      pK_ptr[i].util_flag=0;
      if (flag) pK_ptr[i].color=FG_COLOR;
      if (pK_ptr[i].flower[0]!=pK_ptr[i].flower[pK_ptr[i].num]) 
	{
	  bcount++;
	  pK_ptr[i].bdry_flag=1;
	}
      else pK_ptr[i].bdry_flag=0;
    }
  p->intnode=node-bcount;

  /* identify bdry components, give pointers; note: index starts with 1 */
  count=0;
  new_vert=0;
  do
    {
      new_vert++;
      if (pK_ptr[new_vert].bdry_flag && !pK_ptr[new_vert].util_flag)
	{
	  comp_count++;
	  if (comp_count>max_components)
	    {
	      sprintf(msgbuf,
		      "This complex has too many bdry components.");
	      emsg();
	      return 0;
	    }
	  p->bdry_starts[comp_count]=new_vert;
	  next_bdry=new_vert;
	  do
	    {
	      pK_ptr[next_bdry].util_flag=1;
	      next_bdry=pK_ptr[next_bdry].flower[0];
	      count++;
	      if (count>p->nodecount)
		{
		  sprintf(msgbuf,"Problem tracing a boundary path; combinatoric error.");
		  emsg();
		  return 0;
		}
	    }
	  while (next_bdry!=new_vert);
	}
    }
  while (count<bcount);
  p->num_bdry_comp=comp_count;

  /* identify int components and pointers to them */
  icount=node-bcount; /* number of interiors */
  if (icount>0)
    {
      comp_count=0;
      do
	{
	  ptr=0;
	  do {ptr++;}
	  while (pK_ptr[ptr].util_flag); 
	  /* find smallest index not plotted (hence int node) */
	  comp_count++;
	  if (comp_count>max_components)
	    {
	      sprintf(msgbuf,
		      "This complex has too many interior components.");
	      emsg();
	      return 0;
	    }
	  icount--;
	  p->int_starts[comp_count]=ptr;
	  pK_ptr[ptr].util_flag=ptr;
	  do
	    {
	      more_flag=0; /* will tell me whether I am still finding anything */
	      for (k=ptr;k<=node;k++)
		{
		  if (pK_ptr[k].util_flag==ptr)
		    {
		      for (j=0;j<=pK_ptr[k].num;j++) 
			{
			  fj=pK_ptr[k].flower[j];
			  if (!pK_ptr[fj].util_flag) 
			    {
			      pK_ptr[fj].util_flag=ptr;
			      icount--;
			      more_flag=1;
			    }
			}
		    }
		}
	    } /* end of inside do */
	  while (more_flag && icount>0);
	} /* end of outside do */
      while (icount>0);
      p->num_int_comp=comp_count;
    } /* end of 'if icount' */
  /* find Euler characteristic and genus */
  count=0;
  for (k=1;k<=node;k++) count += pK_ptr[k].num;
  p->facecount=count/3;
  num_edges=(count + bcount)/2;
  p->euler=node-num_edges+p->facecount;
  p->genus=(2-p->euler-p->num_bdry_comp)/2;
  /* check if geom is appropriate */
  if (bcount==0 && p->genus==0 && p->hes<=0)
    {
      sprintf(msgbuf,
	      "Caution: This complex is a topological sphere.");
      msg();
    } 
  /* allocate space for face rwb_flags data, store ordered triples 
     of verts. */
  if (!alloc_faces_space(p))
    {
      sprintf(msgbuf,"Error allocating face data space.");
      emsg();
      return 0;
    }
  count=1;
  i=1;
  while (count<=p->facecount && i<=p->nodecount)
    {
      for (j=0;j<pK_ptr[i].num;j++)
	{
	  m=pK_ptr[i].flower[j];
	  n=pK_ptr[i].flower[j+1];
	  if (m>i && n>i) 
	    {
	      p->faces[count].vert[0]=i;
	      p->faces[count].vert[1]=m;
	      p->faces[count].vert[2]=n;
	      p->faces[count].color=FG_COLOR;
	      p->faces[count].plot_flag=1;
	      count++;
	    }
	}
      i++;
    }
  if (count < p->facecount)
    {
      sprintf(msgbuf,"Error in complex; facecount is %d, but found only %d faces in 'faces' structure.",p->facecount,count);
      emsg();
      count=0;
      for (i=1;i<=p->nodecount && count < 25;i++)
	for (j=0;j<pK_ptr[i].num+pK_ptr[i].bdry_flag;j++)
	  if (nghb(p,(v=pK_ptr[i].flower[j]),i) < 0) 
	    {
	      if (count ==0 )
		{
		  sprintf(msgbuf,"  Here are some vertices which disagree about begin neighbors:");
		  emsg();
		}
	      sprintf(msgbuf,"     %d -- %d ",i,v);
	      msg();
	      count ++;
	    }
      if (count == 25)
	{
	  sprintf(msgbuf,"  Stop counting, but there may be further combinatoric errors.");
	  msg();
	}
      return 0;
    }
  /* determine intrinsic geometry */
  if (bcount==0)
    {
      if (p->genus==0) p->intrinsic_geom=1;
      else if (p->genus==1) p->intrinsic_geom=0;
    }
  else p->intrinsic_geom=-1;
  return 1;
} /* complex_count */
