#include "cp_types.h"
#include "cp_proto.h"

/* ViewCP.c, based on shell_main.c TEMPLATE. 
This program reads a <name>.p packing file, creates a <name>.ps
postscript file. It assumes the packing is computed and fixed, 
adjusts for the image, and assuming -s flag is not set, pops up 
a ghostview picture. 

(Note: if -c flag is set, intend to send postscript output to stdout, 
assuming its being piped into something, but don't know how to use it 
yet, so this is disabled.)

Compile with:
   cc -g -Wall -o ViewCP ViewCP.c -I$HOME/CP/include -L$HOME/CP/lib  -L/usr/X11R6/lib -lCP_libs -lX11 -lm

Run with:
   ViewCP [-c] <packing.p>
*/

char *emsgbuf,*msgbuf;
int repack_activity_msg(),refresh_canvas();

int main(int argc,char *argv[])
{
  int flag=0,n,sflag=0;
  char filename[BUFSIZE],outname[BUFSIZE];
  struct p_data *p;
  FILE *fp=NULL;

  set_cp_globals();

  /* ----------- user code starts here */

  if (argc<1)
    {
      printf("Usage: ViewCP <packname.p>.\n");
      exit(1);
    }
  /* hold: I don't know how to use the stdout version yet
     if (argc==3 && !strncpy(argv[1],"-c",2)) flag=1; */

  if (argc>2 && !strncmp(argv[1],"-s",2)) sflag=1; 

  /* read a packing */
  if (!strcpy(filename,argv[argc-1])
      || !(p=init_packing())
      || !(fp=fopen(filename,"r"))
      || !readpack(fp,p))
    {
      if (fp) fclose(fp);
      printf("  Failed to get the packing.\n");
      exit(1);
    } 
  fclose(fp);
  fp=NULL;

  /* create name for .ps file */
  
  strcpy(outname,filename);
  n=strlen(filename)-1;
  while(n>0 && filename[n]!='.') n--;
  if (n>0) outname[n]='\0';
  strcat(outname,".ps");

  if (!flag) /* store postscript */
    {

      /* string of print options, just like "post" command
	 (except that you probably have to cary out some standard
	 preparations of the packing). */

      if (!sflag) print_call(&fp,p,outname,"-o -c -xg",
		 "your-name-here","message","lpr");
      else print_call(&fp,p,outname,"-o -c -x",
		 "your-name-here","message","lpr");
    }
  else /* stream to stdout; disabled */
    {
      /*      fp=stdout;
      print_call(&fp,p,filename,"-os -c -x", 
      "your-name-here","message","lpr"); */
    }

  /* ----------- user code ends here */
  exit(0);
} /* main */


/* ====== communication routines; user may want to modify ====== */


int emsg()
{
  printf(emsgbuf);return 1;
} /* emsg */

int msg()
{
  printf(msgbuf);return 1;
} /* msg */

int repack_activity_msg(char *datastr)
     /* report progress of repacking */
{
  strcpy(msgbuf,datastr);
  msg();
  return 1;
} /* repack_activity_msg */

int refresh_canvas(struct s_data *q)
     /* some drawing routines want to refresh */
{return 1;} /* refresh_canvas */

/* ================================================================= */
