#include "cp_types.h"
#include "cp_proto.h"

double toler=TOLER,okerr=OKERR;
char buf[BUFSIZE],*msgbuf; 
FILE *fp;


/* -------- main routine ----------- */

main(int argc,char *argv[])
{
  int N,S,E=0,read_key=0037,errflag=0;
  double rN,rS,rE;
  complex zN,zS,zE;
  Mobius Mob;
  char filename[256];
  struct R_data *pR_ptr;


		/* ---------- initialization --------------- */

  msgbuf=(char *)calloc((size_t)1024,sizeof(char));
  msgbuf[0]='\0';
  if (argc < 3 || (packdata=(struct p_data *)
       malloc(sizeof(struct p_data)))==NULL)
    exit(0);

		/* -------- interpret arguments --------- */
  strcpy(filename,argv[1]);
  if ((fp=fopen(filename,"r"))!=NULL) 
    {
      packdata->sizelimit=r_get_pack_size(fp,packdata);
      fclose(fp);
    }
  if (!packdata->sizelimit || (fp=fopen(filename,"r"))==NULL
      || (packdata->packK_ptr=
	  (struct K_data *)malloc((packdata->sizelimit+1)
				  *sizeof(struct K_data)))==NULL
      || (packdata->packR_ptr=
	  (struct R_data *)malloc((packdata->sizelimit+1)
				  *sizeof(struct R_data)))==NULL
      || !(read_key=readpack(fp,packdata)) || packdata->hes<=0)
    {
      sprintf(msgbuf,"RePack: read of file %s failed.",filename);
      msg();
      if (fp) fclose(fp);
      exit(0);
    }
  if (fp) fclose(fp);
  sprintf(msgbuf,
	  "Reading %s is complete:\n       nodecount = %d, geometry = ",
	  filename,packdata->nodecount);
  pR_ptr=packdata->packR_ptr;

  /* get N, S, and (optional) E */
  if (!sscanf(argv[2],"%d",&N) || N<1 || N>packdata->nodecount 
      || !sscanf(argv[3],"%d",&S) || S<1 || S>packdata->nodecount
      || S==N || (argc>4 && (!sscanf(argv[4],"%d",&E) || E<1
		 || E>packdata->nodecount || E==S || E==N)) )
    exit(2);
  
  zN=pR_ptr[N].center;rN=pR_ptr[N].rad;
  zS=pR_ptr[S].center;rS=pR_ptr[S].rad;
  if (E)
    {zE=pR_ptr[E].center;rE=pR_ptr[E].rad;}
  else 
    {zE.re=zE.im=rE=0.0;}

  NS_mobius(zN,zS,zE,rN,rS,rE,1.0,&errflag,&Mob);
  if (errflag) 
    {
      printf("Got error from NS_mobius\n");
      exit(4);
    }

  apply_Mobius(packdata,"a",1,Mob);
  strcat(filename,"p"); /* add extra p to filename */
  if ((fp=fopen(filename,"w"))==NULL 
      || !writepack(fp,packdata,((read_key & 0717) | 0033),0) )
	/* note: don't write angle sums, do write basic comb data,
	   centers and radii, also write other things (such as
	   vertex_map) which were read in with the original packing */
    {
      sprintf(msgbuf,"RePack: failed to write data to %s.",filename);
      msg();
      fclose(fp);
      exit(5);
    }
  sprintf(msgbuf,"RePack results are stored in file %s.\n",filename);
  msg();
  if (fp) fclose(fp);
  printf("NS_special is done.\n");
  exit(6);

/* -------- exit ------ */

  sprintf(msgbuf,"NS_special: finished successfully.");
  msg();
  exit(10);

} /* end of main */

int msg()
{
  printf(msgbuf);fsync((int)stdout);
  return 1;
}

int emsg()
{
  printf(msgbuf);fsync((int)stdout);
  return 1;
}
