// Chip's Workshop - a level editor for Chip's Challenge.
// Copyright 2008-2009 Christopher Elsby <glarbex@glarbex.com>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of version 2 of the GNU General Public License as
// published by the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CHIPW_APP_H_INCLUDED
#define CHIPW_APP_H_INCLUDED

#include <wx/app.h>

class wxDocManager;

namespace ChipW {

class App : public wxApp {
public:
    App();
    virtual bool OnInit();
    virtual void OnInitCmdLine(wxCmdLineParser& parser);
    virtual bool OnCmdLineParsed(wxCmdLineParser& parser);
    virtual int OnExit();
private:
    void OnCommand(wxCommandEvent& event);
    wxDocManager* docmgr;
    bool autostart;
    DECLARE_EVENT_TABLE()
};

}

DECLARE_APP(ChipW::App)

#endif // !CHIPW_APP_H_INCLUDED
