# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from bzrlib.plugins.explorer.lib import (
    html_report_view,
    status_report,
    )


class SubmitView(html_report_view.HtmlReportView):
    """The view of what would be submitted.
    
    This is a bit like the working-tree view but the status is
    shown using -rsubmit:..-1, i.e. what's been committed so far
    versus the submit branch.
    """
    def __init__(self, model, action_callback, target):
        super(SubmitView, self).__init__(model, action_callback)
        self.target = target

    def report_text(self):
        report = status_report.SubmitReport(self._model.branch, self.target)
        return report.full_report()
