# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from PyQt4 import QtCore, QtGui

from bzrlib.plugins.explorer.lib import kinds
from bzrlib.plugins.explorer.lib.extensions import tools
from bzrlib.plugins.explorer.lib.helpers import build_combo_with_labels
from bzrlib.plugins.explorer.lib.i18n import gettext, N_


class AddToolDialog(QtGui.QDialog):

    def __init__(self, parent=None):
        super(AddToolDialog, self).__init__(parent)
        self.setWindowTitle(gettext("Add Tool"))
        self.setLayout(self._build_layout())

    def _build_layout(self):
        # Build the form
        self.title_field = QtGui.QLineEdit()
        self.type_field = build_combo_with_labels([
            ('bzr', gettext("Bazaar Command")),
            ('link', gettext("Web Link")),
            ('application', gettext("Local Application")),
            ])
        self.action_field = QtGui.QLineEdit()
        self.icon_field = self._build_icon_selector()
        form = QtGui.QFormLayout()
        form.addRow(gettext("Title"), self.title_field)
        form.addRow(gettext("Type"), self.type_field)
        form.addRow(gettext("Command"), self.action_field)
        form.addRow(gettext("Icon"), self.icon_field)

        # Add in the buttons
        buttons = QtGui.QDialogButtonBox(
            QtGui.QDialogButtonBox.Ok |
            QtGui.QDialogButtonBox.Cancel)
        self.connect(buttons, QtCore.SIGNAL("accepted()"), self,
            QtCore.SLOT("accept()"))
        self.connect(buttons, QtCore.SIGNAL("rejected()"), self,
            QtCore.SLOT("reject()"))

        # Put it all together
        layout = QtGui.QVBoxLayout()
        layout.addLayout(form)
        layout.addWidget(buttons)
        return layout

    def _build_icon_selector(self):
        combo = QtGui.QComboBox()
        combo.addItem('')
        for path in kinds.ALL_ICON_PATHS:
            icon = kinds.icon_by_resource_path(path)
            combo.addItem(icon, path)
        return combo

    def get_tool(self):
        """Get the added tool."""
        title = unicode(self.title_field.text()).strip()
        type_index = self.type_field.currentIndex()
        type = unicode(self.type_field.itemData(type_index).toString())
        action = unicode(self.action_field.text()).strip()
        icon = unicode(self.icon_field.currentText())
        if icon == '':
            icon = None
        return tools.Tool(title, type, action, icon=icon)
