#! /bin/sh
# Bugzilla's applications do not exit on an error.

set -e

echo "$0 $*"
d="$1"

tmpf=`tempfile`
trap "rm $tmpf" EXIT QUIT

# Apply the patch.
cat "$0"|patch -d "$d" -p1

# The following check is quality assurence.
if grep -rq "[[:space:]]exit;$" "$d"; then
	cat <<__EOF__
---8<---8<---8<---8<---8<---8<---8<---8<---8<---8<---8<---
There should not exist any exit without an return value.
Please tune the patch if you make an update of bugzilla:
__EOF__
	grep -r "[[:space:]]exit;$" "$d"|cat -n
	exit 1
fi
if ! grep -q "exit(9);$" "$d/Bugzilla/Install/Localconfig.pm"; then
	cat <<__EOF__
It's important to exit with error code 9 in the case where
/etc/bugzilla3/localconfig file is updated.
In this case /usr/share/bugzilla3/lib/checksetup.pl restart
checksetup. Please modify debian/maintenance/checksetup_debian.sh
otherwise.
__EOF__
	exit 2
fi

exit 0

diff -Naur a/attachment.cgi b/attachment.cgi
--- a/attachment.cgi	2010-05-17 18:47:29.000000000 +0200
+++ b/attachment.cgi	2010-08-08 15:36:58.187003436 +0200
@@ -130,7 +130,7 @@
   ThrowCodeError("unknown_action", { action => $action });
 }
 
-exit;
+exit(0);
 
 ################################################################################
 # Data Validation / Security Authorization
@@ -158,7 +158,7 @@
         print $cgi->header();
         $template->process("attachment/choose.html.tmpl", $vars) ||
             ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
     
     my $attach_id = $cgi->param($param);
@@ -262,7 +262,7 @@
                 {
                     # Not a valid token.
                     print $cgi->redirect('-location' => correct_urlbase() . $path);
-                    exit;
+                    exit(0);
                 }
                 # Change current user without creating cookies.
                 Bugzilla->set_user(new Bugzilla::User($userid));
@@ -288,14 +288,14 @@
             if (attachmentIsPublic($attachment)) {
                 # No need for a token; redirect to attachment base.
                 print $cgi->redirect(-location => $attachbase . $path);
-                exit;
+                exit(0);
             } else {
                 # Make sure the user can view the attachment.
                 check_can_access($attachment);
                 # Create a token and redirect.
                 my $token = url_quote(issue_session_token($attachment->id));
                 print $cgi->redirect(-location => $attachbase . "$path&t=$token");
-                exit;
+                exit(0);
             }
         }
     } else {
@@ -463,7 +463,7 @@
             print $cgi->header();
             $template->process("attachment/cancel-create-dupe.html.tmpl",  $vars)
                 || ThrowTemplateError($template->error());
-            exit;
+            exit(1);
         }
     }
 
@@ -624,7 +624,7 @@
                 # Warn the user about the mid-air collision and ask them what to do.
                 $template->process("attachment/midair.html.tmpl", $vars)
                   || ThrowTemplateError($template->error());
-                exit;
+                exit(1);
             }
         }
     }
diff -Naur a/buglist.cgi b/buglist.cgi
--- a/buglist.cgi	2010-08-02 01:37:31.000000000 +0200
+++ b/buglist.cgi	2010-08-08 15:36:58.190668330 +0200
@@ -77,7 +77,7 @@
     $vars->{'url'} = $url;
     $template->process("global/message.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 # If query was POSTed, clean the URL from empty parameters and redirect back to
@@ -88,7 +88,7 @@
     my $uri_length = length($cgi->self_url());
     if ($uri_length < CGI_URI_LIMIT) {
         print $cgi->redirect(-url => $cgi->self_url());
-        exit;
+        exit(0);
     }
 }
 
@@ -491,7 +491,7 @@
         $vars->{'url'} = "query.cgi";
         $template->process("global/message.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 }
 elsif (($cmdtype eq "doit") && defined $cgi->param('remtype')) {
@@ -592,7 +592,7 @@
         print $cgi->header();
         $template->process("global/message.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 }
 
diff -Naur a/Bugzilla/Auth/Login/CGI.pm b/Bugzilla/Auth/Login/CGI.pm
--- a/Bugzilla/Auth/Login/CGI.pm	2010-03-24 00:21:18.000000000 +0100
+++ b/Bugzilla/Auth/Login/CGI.pm	2010-08-08 15:36:58.190668330 +0200
@@ -65,7 +65,7 @@
     $template->process("account/auth/login.html.tmpl",
                        { 'target' => $cgi->url(-relative=>1) }) 
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 1;
diff -Naur a/Bugzilla/Bug.pm b/Bugzilla/Bug.pm
--- a/Bugzilla/Bug.pm	2010-08-04 02:49:23.000000000 +0200
+++ b/Bugzilla/Bug.pm	2010-08-08 15:36:58.190668330 +0200
@@ -1379,7 +1379,7 @@
             print $cgi->header();
             $template->process("bug/process/confirm-duplicate.html.tmpl", $vars)
               || ThrowTemplateError($template->error());
-            exit;
+            exit(1);
         }
     }
 
@@ -2037,7 +2037,7 @@
             my $template = Bugzilla->template;
             $template->process("bug/process/verify-new-product.html.tmpl",
                 \%vars) || ThrowTemplateError($template->error());
-            exit;
+            exit(1);
         }
     }
     else {
diff -Naur a/Bugzilla/CGI.pm b/Bugzilla/CGI.pm
--- a/Bugzilla/CGI.pm	2010-07-15 19:34:25.000000000 +0200
+++ b/Bugzilla/CGI.pm	2010-08-08 15:36:58.195002108 +0200
@@ -396,7 +396,7 @@
 
     # When using XML-RPC with mod_perl, we need the headers sent immediately.
     $self->r->rflush if $ENV{MOD_PERL};
-    exit;
+    exit(0);
 }
 
 # Redirect to the urlbase version of the current URL.
@@ -404,7 +404,7 @@
     my $self = shift;
     my $path = $self->url('-path_info' => 1, '-query' => 1, '-relative' => 1);
     print $self->redirect('-location' => correct_urlbase() . $path);
-    exit;
+    exit(0);
 }
 
 sub url_is_attachment_base {
diff -Naur a/Bugzilla/DB/Mysql.pm b/Bugzilla/DB/Mysql.pm
--- a/Bugzilla/DB/Mysql.pm	2010-02-01 00:39:14.000000000 +0100
+++ b/Bugzilla/DB/Mysql.pm	2010-08-08 15:36:58.195002108 +0200
@@ -707,7 +707,7 @@
          Re-run checksetup.pl in interactive mode (without an 'answers' file)
          to continue.
 EOT
-                exit;
+                exit(1);
             }
             else {
                 print "         Press Enter to continue or Ctrl-C to exit...";
diff -Naur a/Bugzilla/DB.pm b/Bugzilla/DB.pm
--- a/Bugzilla/DB.pm	2010-08-02 03:34:28.000000000 +0200
+++ b/Bugzilla/DB.pm	2010-08-08 15:36:58.195002108 +0200
@@ -155,7 +155,7 @@
     $command
 
 EOT
-        exit;
+        exit(1);
     }
 
     # We don't try to connect to the actual database if $db_check is
@@ -185,7 +185,7 @@
 newer version.
 
 EOT
-        exit;
+        exit(1);
     }
 
     print "\n" if $output;
@@ -216,7 +216,7 @@
             print STDERR  "The '$db_name' database could not be created.",
                           " The error returned was:\n\n    $error\n\n",
                           _bz_connect_error_reasons();
-            exit;
+            exit(1);
         }
     }
 
@@ -239,7 +239,7 @@
         chomp($error);
         print STDERR "There was an error connecting to $sql_server:\n\n",
                      "    $error\n\n", _bz_connect_error_reasons();
-        exit;
+        exit(1);
     }
     return $dbh;    
 }
diff -Naur a/Bugzilla/Error.pm b/Bugzilla/Error.pm
--- a/Bugzilla/Error.pm	2010-04-01 03:17:35.000000000 +0200
+++ b/Bugzilla/Error.pm	2010-08-08 15:36:58.195002108 +0200
@@ -136,7 +136,7 @@
             }
         }
     }
-    exit;
+    exit(1);
 }
 
 sub ThrowUserError {
@@ -190,7 +190,7 @@
         </tt>
 END
     }
-    exit;
+    exit(1);
 }
 
 1;
diff -Naur a/Bugzilla/Install/Localconfig.pm b/Bugzilla/Install/Localconfig.pm
--- a/Bugzilla/Install/Localconfig.pm	2010-04-22 20:22:50.000000000 +0200
+++ b/Bugzilla/Install/Localconfig.pm	2010-08-08 15:36:58.199002105 +0200
@@ -393,7 +393,7 @@
 checksetup.pl:  $newstuff
 
 EOT
-        exit;
+        exit(9);
     }
 
     # Reset the cache for Bugzilla->localconfig so that it will be re-read
diff -Naur a/Bugzilla/Search/Quicksearch.pm b/Bugzilla/Search/Quicksearch.pm
--- a/Bugzilla/Search/Quicksearch.pm	2010-08-02 04:19:36.000000000 +0200
+++ b/Bugzilla/Search/Quicksearch.pm	2010-08-08 15:36:58.199002105 +0200
@@ -227,7 +227,7 @@
         # Single bug number; shortcut to show_bug.cgi.
         print $cgi->redirect(
             -uri => correct_urlbase() . "show_bug.cgi?id=$searchstring");
-        exit;
+        exit(0);
     }
     else {
         # List of bug numbers.
@@ -247,7 +247,7 @@
         if ($is_alias) {
             print Bugzilla->cgi->redirect(
                 -uri => correct_urlbase() . "show_bug.cgi?id=$alias");
-            exit;
+            exit(0);
         }
     }
 }
diff -Naur a/Bugzilla/Token.pm b/Bugzilla/Token.pm
--- a/Bugzilla/Token.pm	2009-12-31 13:53:19.000000000 +0100
+++ b/Bugzilla/Token.pm	2010-08-08 15:36:58.199002105 +0200
@@ -218,7 +218,7 @@
         print Bugzilla->cgi->header();
         $template->process('global/confirm-action.html.tmpl', $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 
     # If we come here, then the token is valid and not too old.
@@ -400,7 +400,7 @@
 
         $template->process('admin/confirm-action.html.tmpl', $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
     return 1;
 }
diff -Naur a/Bugzilla/User.pm b/Bugzilla/User.pm
--- a/Bugzilla/User.pm	2010-02-18 01:34:42.000000000 +0100
+++ b/Bugzilla/User.pm	2010-08-08 15:36:58.199002105 +0200
@@ -1322,7 +1322,7 @@
 
     $template->process("global/confirm-user-match.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 
 }
 
diff -Naur a/Bugzilla.pm b/Bugzilla.pm
--- a/Bugzilla.pm	2010-08-04 23:49:23.000000000 +0200
+++ b/Bugzilla.pm	2010-08-08 15:36:58.203025055 +0200
@@ -134,7 +134,7 @@
         if (lsearch(SHUTDOWNHTML_EXIT_SILENTLY, basename($0)) > -1
             && !i_am_cgi())
         {
-            exit;
+            exit(0);
         }
 
         # For security reasons, log out users when Bugzilla is down.
@@ -168,7 +168,7 @@
         $template->process("global/message.$extension.tmpl", $vars, \$t_output)
             || ThrowTemplateError($template->error);
         print $t_output . "\n";
-        exit;
+        exit(1);
     }
 }
 
diff -Naur a/chart.cgi b/chart.cgi
--- a/chart.cgi	2009-10-24 07:21:06.000000000 +0200
+++ b/chart.cgi	2010-08-08 15:36:58.203025055 +0200
@@ -76,7 +76,7 @@
     my $params = $cgi->canonicalise_query("format", "ctype", "action");
     print "Location: query.cgi?format=" . $cgi->param('query_format') .
                                           ($params ? "&$params" : "") . "\n\n";
-    exit;
+    exit(0);
 }
 
 my $action = $cgi->param('action');
@@ -99,7 +99,7 @@
 if ($action eq "search") {
     my $params = $cgi->canonicalise_query("format", "ctype", "action");
     print "Location: buglist.cgi" . ($params ? "?$params" : "") . "\n\n";
-    exit;
+    exit(0);
 }
 
 $user->in_group(Bugzilla->params->{"chartgroup"})
@@ -230,7 +230,7 @@
     ThrowCodeError("unknown_action");
 }
 
-exit;
+exit(0);
 
 # Find any selected series and return either the first or all of them.
 sub getAndValidateSeriesIDs {
diff -Naur a/colchange.cgi b/colchange.cgi
--- a/colchange.cgi	2010-05-19 18:34:05.000000000 +0200
+++ b/colchange.cgi	2010-08-08 15:36:58.203025055 +0200
@@ -164,12 +164,12 @@
     }
     else {
       print $cgi->redirect($vars->{'redirect_url'});
-      exit;
+      exit(0);
     }
     
     $template->process("global/message.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 if (defined $cgi->param('columnlist')) {
diff -Naur a/config.cgi b/config.cgi
--- a/config.cgi	2010-03-18 15:02:54.000000000 +0100
+++ b/config.cgi	2010-08-08 15:36:58.203025055 +0200
@@ -161,5 +161,5 @@
                             -type => $format->{'ctype'});
         print $output;
     }
-    exit;
+    exit(0);
 }
diff -Naur a/contrib/recode.pl b/contrib/recode.pl
--- a/contrib/recode.pl	2009-02-20 22:54:16.000000000 +0100
+++ b/contrib/recode.pl	2010-08-08 15:36:58.203025055 +0200
@@ -154,7 +154,7 @@
   $^X install-module.pl Encode::Detect
 
 EOT
-        exit;
+        exit(1);
     }
 
     import Encode::Detect::Detector qw(detect);
diff -Naur a/contrib/sendbugmail.pl b/contrib/sendbugmail.pl
--- a/contrib/sendbugmail.pl	2010-03-08 03:47:38.000000000 +0100
+++ b/contrib/sendbugmail.pl	2010-08-08 15:36:58.203025055 +0200
@@ -23,7 +23,7 @@
 
 sub usage {
     print STDERR "Usage: $0 bug_id user_email\n";
-    exit;
+    exit(1);
 }
 
 if (($#ARGV < 1) || ($#ARGV > 2)) {
diff -Naur a/contrib/syncLDAP.pl b/contrib/syncLDAP.pl
--- a/contrib/syncLDAP.pl	2008-07-07 11:01:51.000000000 +0200
+++ b/contrib/syncLDAP.pl	2010-08-08 15:36:58.203025055 +0200
@@ -70,7 +70,7 @@
          print " -c No create, don't create users, which are in LDAP but not in Bugzilla\n";
          print " -q Quiet mode, give less output\n";
          print "\n";
-         exit;
+         exit(1);
    }
 }
 
@@ -94,7 +94,7 @@
 my $LDAPserver = Bugzilla->params->{"LDAPserver"};
 if ($LDAPserver eq "") {
    print "No LDAP server defined in bugzilla preferences.\n";
-   exit;
+   exit(1);
 }
 
 my $LDAPconn;
@@ -111,7 +111,7 @@
 
 if(!$LDAPconn) {
    print "Connecting to LDAP server failed. Check LDAPserver setting.\n";
-   exit;
+   exit(1);
 }
 my $mesg;
 if (Bugzilla->params->{"LDAPbinddn"}) {
@@ -123,7 +123,7 @@
 }
 if($mesg->code) {
    print "Binding to LDAP server failed: " . $mesg->error . "\nCheck LDAPbinddn setting.\n";
-   exit;
+   exit(1);
 }
 
 # We've got our anonymous bind;  let's look up the users.
@@ -135,7 +135,7 @@
 
 if(! $mesg->count) {
    print "LDAP lookup failure. Check LDAPBaseDN setting.\n";
-   exit;
+   exit(1);
 }
    
 my %val = %{ $mesg->as_struct };
diff -Naur a/createaccount.cgi b/createaccount.cgi
--- a/createaccount.cgi	2007-11-11 23:03:16.000000000 +0100
+++ b/createaccount.cgi	2010-08-08 15:36:58.203025055 +0200
@@ -74,7 +74,7 @@
 
     $template->process("account/created.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 # Show the standard "would you like to create an account?" form.
diff -Naur a/describecomponents.cgi b/describecomponents.cgi
--- a/describecomponents.cgi	2009-05-21 10:43:23.000000000 +0200
+++ b/describecomponents.cgi	2010-08-08 15:36:58.203025055 +0200
@@ -70,7 +70,7 @@
 
         $template->process("global/choose-product.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 
     # If there is only one product available and the user didn't specify
diff -Naur a/editclassifications.cgi b/editclassifications.cgi
--- a/editclassifications.cgi	2009-01-02 14:59:22.000000000 +0100
+++ b/editclassifications.cgi	2010-08-08 15:36:58.207008899 +0200
@@ -51,7 +51,7 @@
     print $cgi->header();
     $template->process("admin/classifications/$action.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
diff -Naur a/editcomponents.cgi b/editcomponents.cgi
--- a/editcomponents.cgi	2010-02-01 00:33:30.000000000 +0100
+++ b/editcomponents.cgi	2010-08-08 15:36:58.207008899 +0200
@@ -80,7 +80,7 @@
 
     $template->process("admin/components/select-product.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 my $product = $user->check_can_admin_product($product_name);
@@ -94,7 +94,7 @@
     $vars->{'product'} = $product;
     $template->process("admin/components/list.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -108,7 +108,7 @@
     $vars->{'product'} = $product;
     $template->process("admin/components/create.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -148,7 +148,7 @@
 
     $template->process("admin/components/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -165,7 +165,7 @@
 
     $template->process("admin/components/confirm-delete.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -187,7 +187,7 @@
 
     $template->process("admin/components/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -209,7 +209,7 @@
 
     $template->process("admin/components/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -249,7 +249,7 @@
 
     $template->process("admin/components/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
diff -Naur a/editflagtypes.cgi b/editflagtypes.cgi
--- a/editflagtypes.cgi	2009-11-23 23:40:54.000000000 +0100
+++ b/editflagtypes.cgi	2010-08-08 15:36:58.207008899 +0200
@@ -73,7 +73,7 @@
 if (@categoryActions = grep(/^categoryAction-.+/, $cgi->param())) {
     $categoryActions[0] =~ s/^categoryAction-//;
     processCategoryChange($categoryActions[0], $token);
-    exit;
+    exit(0);
 }
 
 if    ($action eq 'list')           { list();           }
@@ -89,7 +89,7 @@
     ThrowCodeError("action_unrecognized", { action => $action });
 }
 
-exit;
+exit(0);
 
 ################################################################################
 # Functions
diff -Naur a/editgroups.cgi b/editgroups.cgi
--- a/editgroups.cgi	2009-12-31 13:48:21.000000000 +0100
+++ b/editgroups.cgi	2010-08-08 15:36:58.207008899 +0200
@@ -157,7 +157,7 @@
     print $cgi->header();
     $template->process("admin/groups/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -179,7 +179,7 @@
     $template->process("admin/groups/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -194,7 +194,7 @@
     $template->process("admin/groups/create.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
     
-    exit;
+    exit(1);
 }
 
 
@@ -231,7 +231,7 @@
     print $cgi->header();
     $template->process("admin/groups/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -256,7 +256,7 @@
     $template->process("admin/groups/delete.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
     
-    exit;
+    exit(1);
 }
 
 #
@@ -282,7 +282,7 @@
     print $cgi->header();
     $template->process("admin/groups/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -304,7 +304,7 @@
     print $cgi->header();
     $template->process("admin/groups/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 if ($action eq 'confirm_remove') {
@@ -314,7 +314,7 @@
     $vars->{'token'} = issue_session_token('remove_group_members');
     $template->process('admin/groups/confirm-remove.html.tmpl', $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 if ($action eq 'remove_regexp') {
@@ -354,7 +354,7 @@
     $template->process("admin/groups/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 
diff -Naur a/editkeywords.cgi b/editkeywords.cgi
--- a/editkeywords.cgi	2010-07-05 03:34:38.000000000 +0200
+++ b/editkeywords.cgi	2010-08-08 15:36:58.207008899 +0200
@@ -62,7 +62,7 @@
     $template->process("admin/keywords/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
     
 
@@ -74,7 +74,7 @@
     $template->process("admin/keywords/create.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -98,7 +98,7 @@
 
     $template->process("admin/keywords/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 
@@ -118,7 +118,7 @@
     print $cgi->header();
     $template->process("admin/keywords/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 
@@ -148,7 +148,7 @@
 
     $template->process("admin/keywords/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 if ($action eq 'del') {
@@ -161,7 +161,7 @@
     print $cgi->header();
     $template->process("admin/keywords/confirm-delete.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 if ($action eq 'delete') {
@@ -181,7 +181,7 @@
 
     $template->process("admin/keywords/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 ThrowCodeError("action_unrecognized", $vars);
diff -Naur a/editmilestones.cgi b/editmilestones.cgi
--- a/editmilestones.cgi	2008-01-28 00:14:14.000000000 +0100
+++ b/editmilestones.cgi	2010-08-08 15:36:58.207008899 +0200
@@ -77,7 +77,7 @@
 
     $template->process("admin/milestones/select-product.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 my $product = $user->check_can_admin_product($product_name);
@@ -92,7 +92,7 @@
     $vars->{'product'} = $product;
     $template->process("admin/milestones/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -106,7 +106,7 @@
     $vars->{'product'} = $product;
     $template->process("admin/milestones/create.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -125,7 +125,7 @@
     $vars->{'product'} = $product;
     $template->process("admin/milestones/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -149,7 +149,7 @@
 
     $template->process("admin/milestones/confirm-delete.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -170,7 +170,7 @@
 
     $template->process("admin/milestones/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -190,7 +190,7 @@
 
     $template->process("admin/milestones/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -215,7 +215,7 @@
     $vars->{'changes'} = $changes;
     $template->process("admin/milestones/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
diff -Naur a/editproducts.cgi b/editproducts.cgi
--- a/editproducts.cgi	2009-12-18 00:31:52.000000000 +0100
+++ b/editproducts.cgi	2010-08-08 15:36:58.211002100 +0200
@@ -95,7 +95,7 @@
 
     $template->process("admin/products/list-classifications.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 
@@ -129,7 +129,7 @@
 
     $template->process("admin/products/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 
@@ -158,7 +158,7 @@
     $template->process("admin/products/create.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 
@@ -204,7 +204,7 @@
 
     $template->process("admin/products/edit.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -226,7 +226,7 @@
     
     $template->process("admin/products/confirm-delete.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -263,7 +263,7 @@
         $template->process("admin/products/list.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
     }
-    exit;
+    exit(1);
 }
 
 #
@@ -284,7 +284,7 @@
 
     $template->process("admin/products/edit.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -318,7 +318,7 @@
 
     $template->process("admin/products/updated.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -333,7 +333,7 @@
 
     $template->process("admin/products/groupcontrol/edit.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -402,7 +402,7 @@
             $vars->{'mandatory_groups'} = $mandatory_groups;
             $template->process("admin/products/groupcontrol/confirm-edit.html.tmpl", $vars)
                 || ThrowTemplateError($template->error());
-            exit;
+            exit(1);
         }
     }
 
@@ -427,7 +427,7 @@
 
     $template->process("admin/products/groupcontrol/updated.html.tmpl", $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
diff -Naur a/editusers.cgi b/editusers.cgi
--- a/editusers.cgi	2009-12-30 15:28:38.000000000 +0100
+++ b/editusers.cgi	2010-08-08 15:36:58.211002100 +0200
@@ -683,7 +683,7 @@
     ThrowCodeError('action_unrecognized', $vars);
 }
 
-exit;
+exit(0);
 
 ###########################################################################
 # Helpers
diff -Naur a/editvalues.cgi b/editvalues.cgi
--- a/editvalues.cgi	2010-05-14 16:35:51.000000000 +0200
+++ b/editvalues.cgi	2010-08-08 15:36:58.211002100 +0200
@@ -39,7 +39,7 @@
     $vars->{'values'} = $vars->{'field'}->legal_values;
     $template->process("admin/fieldvalues/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 ######################################################################
@@ -85,7 +85,7 @@
     $vars->{'fields'} = \@field_list;
     $template->process("admin/fieldvalues/select-field.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 # At this point, the field must be defined.
@@ -108,7 +108,7 @@
     $vars->{'token'} = issue_session_token('add_field_value');
     $template->process("admin/fieldvalues/create.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #
@@ -149,7 +149,7 @@
     $template->process("admin/fieldvalues/confirm-delete.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 
@@ -175,7 +175,7 @@
     $template->process("admin/fieldvalues/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 
diff -Naur a/editversions.cgi b/editversions.cgi
--- a/editversions.cgi	2009-04-10 11:36:43.000000000 +0200
+++ b/editversions.cgi	2010-08-08 15:36:58.211002100 +0200
@@ -80,7 +80,7 @@
 
     $template->process("admin/versions/select-product.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 my $product = $user->check_can_admin_product($product_name);
@@ -95,7 +95,7 @@
     $template->process("admin/versions/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -110,7 +110,7 @@
     $template->process("admin/versions/create.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -129,7 +129,7 @@
     $template->process("admin/versions/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -147,7 +147,7 @@
     $template->process("admin/versions/confirm-delete.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -169,7 +169,7 @@
     $template->process("admin/versions/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -188,7 +188,7 @@
     $template->process("admin/versions/edit.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
@@ -216,7 +216,7 @@
     $template->process("admin/versions/list.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
 
-    exit;
+    exit(1);
 }
 
 #
diff -Naur a/editworkflow.cgi b/editworkflow.cgi
--- a/editworkflow.cgi	2008-07-02 21:10:17.000000000 +0200
+++ b/editworkflow.cgi	2010-08-08 15:36:58.211002100 +0200
@@ -67,7 +67,7 @@
 
     $template->process("admin/workflow/$filename.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 if ($action eq 'edit') {
diff -Naur a/email_in.pl b/email_in.pl
--- a/email_in.pl	2010-08-04 02:19:38.000000000 +0200
+++ b/email_in.pl	2010-08-08 15:36:58.211002100 +0200
@@ -393,7 +393,7 @@
     print STDERR "$msg\n";
     # We exit with a successful value, because we don't want the MTA
     # to *also* send a failure notice.
-    exit;
+    exit(1);
 }
 
 ###############
diff -Naur a/enter_bug.cgi b/enter_bug.cgi
--- a/enter_bug.cgi	2010-03-14 23:45:58.000000000 +0100
+++ b/enter_bug.cgi	2010-08-08 15:36:58.211002100 +0200
@@ -115,7 +115,7 @@
             print $cgi->header();
             $template->process("global/choose-classification.html.tmpl", $vars)
                || ThrowTemplateError($template->error());
-            exit;
+            exit(1);
         }
         # If we come here, then there is only one classification available.
         $classification = $classifications[0]->{'object'}->name;
@@ -147,7 +147,7 @@
         print $cgi->header();
         $template->process("global/choose-product.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     } else {
         # Only one product exists.
         $product = $enterable_products[0];
diff -Naur a/importxml.pl b/importxml.pl
--- a/importxml.pl	2009-12-18 00:31:53.000000000 +0100
+++ b/importxml.pl	2010-08-08 15:36:58.215002942 +0200
@@ -157,7 +157,7 @@
     my @to = ( $params->{"maintainer"}, $exporter);
     Debug( $message, ERR_LEVEL );
     MailMessage( $subject, $message, @to );
-    exit;
+    exit(1);
 }
 
 # This subroutine handles flags for process_bug. It is generic in that
diff -Naur a/index.cgi b/index.cgi
--- a/index.cgi	2009-10-09 06:31:09.000000000 +0200
+++ b/index.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -64,7 +64,7 @@
     unless (Bugzilla->params->{'urlbase'}) {
         $template->process('welcome-admin.html.tmpl')
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
     # Inform the administrator about new releases, if any.
     $vars->{'release'} = Bugzilla::Update::get_notifications();
diff -Naur a/install-module.pl b/install-module.pl
--- a/install-module.pl	2010-04-21 00:17:50.000000000 +0200
+++ b/install-module.pl	2010-08-08 15:36:58.215002942 +0200
@@ -54,7 +54,7 @@
 if (ON_WINDOWS) {
     print "\nYou cannot run this script on Windows. Please follow instructions\n";
     print "given by checksetup.pl to install missing Perl modules.\n\n";
-    exit;
+    exit(1);
 }
 
 pod2usage({ -verbose => 0 }) if (!%switch && !@ARGV);
@@ -63,14 +63,14 @@
 
 if ($switch{'show-config'}) {
     print Dumper($CPAN::Config);
-    exit;
+    exit(0);
 }
 
 check_cpan_requirements($original_dir, \@original_args);
 
 if ($switch{'shell'}) {
     CPAN::shell();
-    exit;
+    exit(0);
 }
 
 if ($switch{'all'} || $switch{'upgrade-all'}) {
diff -Naur a/post_bug.cgi b/post_bug.cgi
--- a/post_bug.cgi	2010-04-07 05:31:29.000000000 +0200
+++ b/post_bug.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -80,7 +80,7 @@
         print $cgi->header();
         $template->process("bug/create/confirm-create-dupe.html.tmpl", $vars)
            || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 }    
 
@@ -98,7 +98,7 @@
     print $cgi->header();
     $template->process("bug/create/make-template.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 umask 0;
diff -Naur a/process_bug.cgi b/process_bug.cgi
--- a/process_bug.cgi	2010-04-07 05:31:29.000000000 +0200
+++ b/process_bug.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -177,7 +177,7 @@
         # Warn the user about the mid-air collision and ask them what to do.
         $template->process("bug/process/midair.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 }
 
@@ -505,7 +505,7 @@
         $template->process("global/footer.html.tmpl", $vars)
             || ThrowTemplateError($template->error());
     }
-    exit;
+    exit(1);
 }
 
 
@@ -660,7 +660,7 @@
         }
         $template->process("bug/show.html.tmpl", $vars)
           || ThrowTemplateError($template->error());
-        exit;
+        exit(1);
     }
 } elsif ($action ne 'nothing') {
     ThrowCodeError("invalid_post_bug_submit_action");
diff -Naur a/report.cgi b/report.cgi
--- a/report.cgi	2010-02-18 20:33:13.000000000 +0100
+++ b/report.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -42,7 +42,7 @@
       ($params ? "&$params" : "");
 
     print $cgi->redirect($location);
-    exit;
+    exit(0);
 }
 
 use Bugzilla::Search;
@@ -58,7 +58,7 @@
     print $cgi->header();
     $template->process("reports/menu.html.tmpl", $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 my $col_field = $cgi->param('x_axis_field') || '';
@@ -326,7 +326,7 @@
 $template->process("$format->{'template'}", $vars)
   || ThrowTemplateError($template->error());
 
-exit;
+exit(0);
 
 
 sub get_names {
diff -Naur a/reports.cgi b/reports.cgi
--- a/reports.cgi	2009-10-24 07:21:06.000000000 +0200
+++ b/reports.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -94,7 +94,7 @@
 
     $template->process('reports/old-charts.html.tmpl', $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 else {
     my $product = $cgi->param('product');
@@ -129,7 +129,7 @@
 
     $template->process('reports/old-charts.html.tmpl', $vars)
       || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 #####################
diff -Naur a/request.cgi b/request.cgi
--- a/request.cgi	2010-08-05 00:01:37.000000000 +0200
+++ b/request.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -87,7 +87,7 @@
     $template->process('request/queue.html.tmpl', $vars)
       || ThrowTemplateError($template->error());
 }
-exit;
+exit(0);
 
 ################################################################################
 # Functions
diff -Naur a/sanitycheck.cgi b/sanitycheck.cgi
--- a/sanitycheck.cgi	2009-12-18 00:31:53.000000000 +0100
+++ b/sanitycheck.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -107,7 +107,7 @@
 
     $template->process('global/footer.html.tmpl', $vars)
         || ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 ###########################################################################
@@ -294,7 +294,7 @@
         $template->process('global/footer.html.tmpl', $vars)
           || ThrowTemplateError($template->error());
     }
-    exit;
+    exit(0);
 }
 
 ###########################################################################
diff -Naur a/showattachment.cgi b/showattachment.cgi
--- a/showattachment.cgi	2007-10-19 08:46:11.000000000 +0200
+++ b/showattachment.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -37,4 +37,4 @@
 print $cgi->redirect(-location=>"attachment.cgi?id=$id",
                      -status=>'301 Permanent Redirect');
 
-exit;
+exit(0);
diff -Naur a/show_bug.cgi b/show_bug.cgi
--- a/show_bug.cgi	2009-11-10 17:31:48.000000000 +0100
+++ b/show_bug.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -46,7 +46,7 @@
     print Bugzilla->cgi->header();
     $template->process("bug/choose.html.tmpl", $vars) ||
       ThrowTemplateError($template->error());
-    exit;
+    exit(1);
 }
 
 my $format = $template->get_format("bug/show", scalar $cgi->param('format'), 
diff -Naur a/testagent.cgi b/testagent.cgi
--- a/testagent.cgi	2007-02-11 01:12:24.000000000 +0100
+++ b/testagent.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -20,5 +20,5 @@
 use strict;
 print "content-type:text/plain\n\n";
 print "OK " . ($::ENV{MOD_PERL} || "mod_cgi") . "\n";
-exit;
+exit(0);
 
diff -Naur a/token.cgi b/token.cgi
--- a/token.cgi	2009-10-09 06:31:09.000000000 +0200
+++ b/token.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -169,7 +169,7 @@
     ThrowCodeError("unknown_action", { action => $action });
 }
 
-exit;
+exit(0);
 
 ################################################################################
 # Functions
diff -Naur a/votes.cgi b/votes.cgi
--- a/votes.cgi	2010-04-07 05:31:30.000000000 +0200
+++ b/votes.cgi	2010-08-08 15:36:58.215002942 +0200
@@ -91,7 +91,7 @@
     ThrowCodeError("unknown_action", {action => $action});
 }
 
-exit;
+exit(0);
 
 # Display the names of all the people voting for this one bug.
 sub show_bug {
@@ -242,11 +242,11 @@
             print $cgi->header();
             $template->process("bug/votes/delete-all.html.tmpl", $vars)
               || ThrowTemplateError($template->error());
-            exit();
+            exit(1);
         }
         elsif ($cgi->param('delete_all_votes') == 0) {
             print $cgi->redirect("votes.cgi");
-            exit();
+            exit(0);
         }
     }
 
