# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk

from btsutils import BugTags

from bug_store import bug_store
from msg_exception import errorhandler

class bug_view:
    """Bug TreeView related callbacks, methods, etc"""

    @errorhandler
    def __init__(self, xml):
        self.xml = xml
        
        self.tv = xml.get_widget("tv_bugs")
        model = bug_store()
        self.tv.set_model(model)

        self.renderer = gtk.CellRendererText()

        # Bug Number TreeViewColumn
        self.tvc_number = gtk.TreeViewColumn("Bug Number", 
            self.renderer, text=model.COLUMN_BUG)
        self.tvc_number.set_sort_column_id(model.COLUMN_BUG)
        self.tv.append_column(self.tvc_number)

        # Package TreeViewColumn
        self.tvc_package = gtk.TreeViewColumn("Package",
            self.renderer, text=model.COLUMN_PACKAGE)
        self.tvc_package.set_sort_column_id(model.COLUMN_PACKAGE)
        self.tv.append_column(self.tvc_package)

        # Status TreeViewColumn
        self.tvc_status = gtk.TreeViewColumn("Status",
            self.renderer, text=model.COLUMN_STATUS)
        self.tvc_status.set_sort_column_id(model.COLUMN_STATUS)
        self.tv.append_column(self.tvc_status)

        # Severity TreeViewColumn
        self.tvc_severity = gtk.TreeViewColumn("Severity",
            self.renderer, text=model.COLUMN_SEVERITY)
        self.tvc_severity.set_sort_column_id(model.COLUMN_SEVERITY)
        self.tv.append_column(self.tvc_severity)

        # Tags
        self.tvc_tags = gtk.TreeViewColumn("Tags",
            self.renderer, text=model.COLUMN_TAGS)
        self.tvc_tags.set_visible(False)
        self.tv.append_column(self.tvc_tags)

        # Usertags
        self.tvc_usertags = gtk.TreeViewColumn("Usertags",
            self.renderer, text=model.COLUMN_USERTAGS)
        self.tvc_usertags.set_visible(False)
        self.tv.append_column(self.tvc_usertags)

        # Submitter
        self.tvc_submitter = gtk.TreeViewColumn("Submitter",
            self.renderer, text=model.COLUMN_SUBMITTER)
        self.tvc_submitter.set_visible(False)
        self.tv.append_column(self.tvc_submitter)

        # Summary TreeViewColumn
        self.tvc_summary = gtk.TreeViewColumn("Summary",
            self.renderer, text=model.COLUMN_SUMMARY)
        self.tvc_summary.set_sort_column_id(model.COLUMN_SUMMARY)
        self.tv.append_column(self.tvc_summary)

    @errorhandler
    def get_model(self):
        """Returns the treeview data model."""
        return self.tv.get_model()

    @errorhandler
    def set_model(self,model):
        """Set the treeview data model."""
        self.tv.set_model(model)
    
    @errorhandler
    def get_selection(self):
        """Returns a list with the selected bugs."""
        
        selection = self.tv.get_selection()
        model, rows = selection.get_selected_rows()

        bugs = []
        for row in rows:
            bugs.append(model.get(model.get_iter(row)))

        return bugs

    @errorhandler
    def on_cursor_changed(self, object, data=None):
        """Activated whenever the cursor is changed"""

        selection = self.tv.get_selection()
        tb_show = self.xml.get_widget("tb_show")
        mi_show = self.xml.get_widget("menuitem_show")
        tb_followup = self.xml.get_widget("tb_followup")
        mi_followup = self.xml.get_widget("mi_followup")
        mi_upstream = self.xml.get_widget("menuitem_upstream")
        tb_upstream = self.xml.get_widget("tb_upstream") 

        if selection.count_selected_rows() == 0:
            tb_show.set_sensitive(False)
            mi_show.set_sensitive(False)
            tb_followup.set_sensitive(False)
            mi_followup.set_sensitive(False)
            mi_upstream.set_sensitive(False)
            tb_upstream.set_sensitive(False)
        else:
            tb_show.set_sensitive(True)
            mi_show.set_sensitive(True)
            tb_followup.set_sensitive(True)
            mi_followup.set_sensitive(True)
            mi_upstream.set_sensitive(True)
            tb_upstream.set_sensitive(True)

    @errorhandler
    def bug_id_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_number.set_visible(True)
        else:
            self.tvc_number.set_visible(False)

    @errorhandler
    def package_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_package.set_visible(True)
        else:
            self.tvc_package.set_visible(False)

    @errorhandler
    def status_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_status.set_visible(True)
        else:
            self.tvc_status.set_visible(False)

    @errorhandler
    def severity_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_severity.set_visible(True)
        else:
            self.tvc_severity.set_visible(False)
    
    @errorhandler
    def tags_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_tags.set_visible(True)
        else:
            self.tvc_tags.set_visible(False)

    @errorhandler
    def usertags_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_usertags.set_visible(True)
        else:
            self.tvc_usertags.set_visible(False)
    
    @errorhandler
    def submitter_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_submitter.set_visible(True)
        else:
            self.tvc_submitter.set_visible(False)

    @errorhandler
    def summary_toggle(self, widget, data=None):
        if widget.get_active():
            self.tvc_summary.set_visible(True)
        else:
            self.tvc_summary.set_visible(False)

    @errorhandler
    def popup(self, widget, event, data=None):
        """Show the context sensitive menu"""

        if event.button == 3:

            model = self.get_model()
            path = self.tv.get_path_at_pos(int(event.x), int(event.y))

            if path:
                bug = model.get(model.get_iter(path[0]))

                menu = self.xml.get_widget("PopupMenu")

                # Check the current bug tags
                tags = bug.getTags()

                if BugTags.PATCH in tags:
                    self.xml.get_widget("pmi_patch").set_active(True)
                else:
                    self.xml.get_widget("pmi_patch").set_active(False)

                if BugTags.WONTFIX in tags:
                    self.xml.get_widget("pmi_wontfix").set_active(True)
                else:
                    self.xml.get_widget("pmi_wontfix").set_active(False)

                if BugTags.MOREINFO in tags:
                    self.xml.get_widget("pmi_moreinfo").set_active(True)
                else:
                    self.xml.get_widget("pmi_moreinfo").set_active(False)

                if BugTags.UNREPRODUCIBLE in tags:
                    self.xml.get_widget("pmi_unreproducible").set_active(True)
                else:
                    self.xml.get_widget("pmi_unreproducible").set_active(False)

                if BugTags.HELP in tags:
                    self.xml.get_widget("pmi_help").set_active(True)
                else:
                    self.xml.get_widget("pmi_help").set_active(False)

                if BugTags.PENDING in tags:
                    self.xml.get_widget("pmi_pending").set_active(True)
                else:
                    self.xml.get_widget("pmi_pending").set_active(False)

                if BugTags.FIXED in tags:
                    self.xml.get_widget("pmi_fixed").set_active(True)
                else:
                    self.xml.get_widget("pmi_fixed").set_active(False)

                if BugTags.SECURITY in tags:
                    self.xml.get_widget("pmi_security").set_active(True)
                else:
                    self.xml.get_widget("pmi_security").set_active(False)

                if BugTags.UPSTREAM in tags:
                    self.xml.get_widget("pmi_tag_upstream").set_active(True)
                else:
                    self.xml.get_widget("pmi_tag_upstream").set_active(False)

                if BugTags.CONFIRMED in tags:
                    self.xml.get_widget("pmi_confirmed").set_active(True)
                else:
                    self.xml.get_widget("pmi_confirmed").set_active(False)

                if BugTags.FIXED_UPSTREAM in tags:
                    self.xml.get_widget("pmi_fixedupstream").set_active(True)
                else:
                    self.xml.get_widget("pmi_fixedupstream").set_active(False)

                if BugTags.FIXED_IN_EXPERIMENTAL in tags:
                    self.xml.get_widget("pmi_fixedexperimental").set_active(True)
                else:
                    self.xml.get_widget("pmi_fixedexperimental").set_active(False)

                if BugTags.D_I in tags:
                    self.xml.get_widget("pmi_di").set_active(True)
                else:
                    self.xml.get_widget("pmi_di").set_active(False)

                if BugTags.IPV6 in tags:
                    self.xml.get_widget("pmi_ipv6").set_active(True)
                else:
                    self.xml.get_widget("pmi_ipv6").set_active(False)

                if BugTags.LFS in tags:
                    self.xml.get_widget("pmi_lfs").set_active(True)
                else:
                    self.xml.get_widget("pmi_lfs").set_active(False)

                if BugTags.L10N in tags:
                    self.xml.get_widget("pmi_l10n").set_active(True)
                else:
                    self.xml.get_widget("pmi_l10n").set_active(False)

                if BugTags.POTATO in tags:
                    self.xml.get_widget("pmi_potato").set_active(True)
                else:
                    self.xml.get_widget("pmi_potato").set_active(False)

                if BugTags.WOODY in tags:
                    self.xml.get_widget("pmi_woody").set_active(True)
                else:
                    self.xml.get_widget("pmi_woody").set_active(False)
                
                if BugTags.SARGE in tags:
                    self.xml.get_widget("pmi_sarge").set_active(True)
                else:
                    self.xml.get_widget("pmi_sarge").set_active(False)

                if BugTags.SARGE_IGNORE in tags:
                    self.xml.get_widget("pmi_sargeignore").set_active(True)
                else:
                    self.xml.get_widget("pmi_sargeignore").set_active(False)

                if BugTags.ETCH in tags:
                    self.xml.get_widget("pmi_etch").set_active(True)
                else:
                    self.xml.get_widget("pmi_etch").set_active(False)

                if BugTags.ETCH_IGNORE in tags:
                    self.xml.get_widget("pmi_etchignore").set_active(True)
                else:
                    self.xml.get_widget("pmi_etchignore").set_active(False)

                if BugTags.LENNY in tags:
                    self.xml.get_widget("pmi_lenny").set_active(True)
                else:
                    self.xml.get_widget("pmi_lenny").set_active(False)

                if BugTags.LENNY_IGNORE in tags:
                    self.xml.get_widget("pmi_lennyignore").set_active(True)
                else:
                    self.xml.get_widget("pmi_lennyignore").set_active(False)

                if BugTags.SID in tags:
                    self.xml.get_widget("pmi_sid").set_active(True)
                else:
                    self.xml.get_widget("pmi_sid").set_active(False)

                if BugTags.EXPERIMENTAL in tags:
                    self.xml.get_widget("pmi_experimental").set_active(True)
                else:
                    self.xml.get_widget("pmi_experimental").set_active(False)

                menu.popup(None, None, None, event.button, event.time)

# vim: tabstop=4 expandtab shiftwidth=4
