#ifdef CPU_CPP

void CPU::initialize_opcode_table() {
  opcode_table[0x00] = &CPU::op_nop;
  opcode_table[0x01] = &CPU::op_ld_rr_nn<BC>;
  opcode_table[0x02] = &CPU::op_ld_rr_a<BC>;
  opcode_table[0x03] = &CPU::op_inc_rr<BC>;
  opcode_table[0x04] = &CPU::op_inc_r<B>;
  opcode_table[0x05] = &CPU::op_dec_r<B>;
  opcode_table[0x06] = &CPU::op_ld_r_n<B>;
  opcode_table[0x07] = &CPU::op_rlca;
  opcode_table[0x08] = &CPU::op_ld_nn_sp;
  opcode_table[0x09] = &CPU::op_add_hl_rr<BC>;
  opcode_table[0x0a] = &CPU::op_ld_a_rr<BC>;
  opcode_table[0x0b] = &CPU::op_dec_rr<BC>;
  opcode_table[0x0c] = &CPU::op_inc_r<C>;
  opcode_table[0x0d] = &CPU::op_dec_r<C>;
  opcode_table[0x0e] = &CPU::op_ld_r_n<C>;
  opcode_table[0x0f] = &CPU::op_rrca;
  opcode_table[0x10] = &CPU::op_stop;
  opcode_table[0x11] = &CPU::op_ld_rr_nn<DE>;
  opcode_table[0x12] = &CPU::op_ld_rr_a<DE>;
  opcode_table[0x13] = &CPU::op_inc_rr<DE>;
  opcode_table[0x14] = &CPU::op_inc_r<D>;
  opcode_table[0x15] = &CPU::op_dec_r<D>;
  opcode_table[0x16] = &CPU::op_ld_r_n<D>;
  opcode_table[0x17] = &CPU::op_rla;
  opcode_table[0x18] = &CPU::op_jr_n;
  opcode_table[0x19] = &CPU::op_add_hl_rr<DE>;
  opcode_table[0x1a] = &CPU::op_ld_a_rr<DE>;
  opcode_table[0x1b] = &CPU::op_dec_rr<DE>;
  opcode_table[0x1c] = &CPU::op_inc_r<E>;
  opcode_table[0x1d] = &CPU::op_dec_r<E>;
  opcode_table[0x1e] = &CPU::op_ld_r_n<E>;
  opcode_table[0x1f] = &CPU::op_rra;
  opcode_table[0x20] = &CPU::op_jr_f_n<ZF, 0>;
  opcode_table[0x21] = &CPU::op_ld_rr_nn<HL>;
  opcode_table[0x22] = &CPU::op_ldi_hl_a;
  opcode_table[0x23] = &CPU::op_inc_rr<HL>;
  opcode_table[0x24] = &CPU::op_inc_r<H>;
  opcode_table[0x25] = &CPU::op_dec_r<H>;
  opcode_table[0x26] = &CPU::op_ld_r_n<H>;
  opcode_table[0x27] = &CPU::op_daa;
  opcode_table[0x28] = &CPU::op_jr_f_n<ZF, 1>;
  opcode_table[0x29] = &CPU::op_add_hl_rr<HL>;
  opcode_table[0x2a] = &CPU::op_ldi_a_hl;
  opcode_table[0x2b] = &CPU::op_dec_rr<HL>;
  opcode_table[0x2c] = &CPU::op_inc_r<L>;
  opcode_table[0x2d] = &CPU::op_dec_r<L>;
  opcode_table[0x2e] = &CPU::op_ld_r_n<L>;
  opcode_table[0x2f] = &CPU::op_cpl;
  opcode_table[0x30] = &CPU::op_jr_f_n<CF, 0>;
  opcode_table[0x31] = &CPU::op_ld_rr_nn<SP>;
  opcode_table[0x32] = &CPU::op_ldd_hl_a;
  opcode_table[0x33] = &CPU::op_inc_rr<SP>;
  opcode_table[0x34] = &CPU::op_inc_hl;
  opcode_table[0x35] = &CPU::op_dec_hl;
  opcode_table[0x36] = &CPU::op_ld_hl_n;
  opcode_table[0x37] = &CPU::op_scf;
  opcode_table[0x38] = &CPU::op_jr_f_n<CF, 1>;
  opcode_table[0x39] = &CPU::op_add_hl_rr<SP>;
  opcode_table[0x3a] = &CPU::op_ldd_a_hl;
  opcode_table[0x3b] = &CPU::op_dec_rr<SP>;
  opcode_table[0x3c] = &CPU::op_inc_r<A>;
  opcode_table[0x3d] = &CPU::op_dec_r<A>;
  opcode_table[0x3e] = &CPU::op_ld_r_n<A>;
  opcode_table[0x3f] = &CPU::op_ccf;
  opcode_table[0x40] = &CPU::op_ld_r_r<B, B>;
  opcode_table[0x41] = &CPU::op_ld_r_r<B, C>;
  opcode_table[0x42] = &CPU::op_ld_r_r<B, D>;
  opcode_table[0x43] = &CPU::op_ld_r_r<B, E>;
  opcode_table[0x44] = &CPU::op_ld_r_r<B, H>;
  opcode_table[0x45] = &CPU::op_ld_r_r<B, L>;
  opcode_table[0x46] = &CPU::op_ld_r_hl<B>;
  opcode_table[0x47] = &CPU::op_ld_r_r<B, A>;
  opcode_table[0x48] = &CPU::op_ld_r_r<C, B>;
  opcode_table[0x49] = &CPU::op_ld_r_r<C, C>;
  opcode_table[0x4a] = &CPU::op_ld_r_r<C, D>;
  opcode_table[0x4b] = &CPU::op_ld_r_r<C, E>;
  opcode_table[0x4c] = &CPU::op_ld_r_r<C, H>;
  opcode_table[0x4d] = &CPU::op_ld_r_r<C, L>;
  opcode_table[0x4e] = &CPU::op_ld_r_hl<C>;
  opcode_table[0x4f] = &CPU::op_ld_r_r<C, A>;
  opcode_table[0x50] = &CPU::op_ld_r_r<D, B>;
  opcode_table[0x51] = &CPU::op_ld_r_r<D, C>;
  opcode_table[0x52] = &CPU::op_ld_r_r<D, D>;
  opcode_table[0x53] = &CPU::op_ld_r_r<D, E>;
  opcode_table[0x54] = &CPU::op_ld_r_r<D, H>;
  opcode_table[0x55] = &CPU::op_ld_r_r<D, L>;
  opcode_table[0x56] = &CPU::op_ld_r_hl<D>;
  opcode_table[0x57] = &CPU::op_ld_r_r<D, A>;
  opcode_table[0x58] = &CPU::op_ld_r_r<E, B>;
  opcode_table[0x59] = &CPU::op_ld_r_r<E, C>;
  opcode_table[0x5a] = &CPU::op_ld_r_r<E, D>;
  opcode_table[0x5b] = &CPU::op_ld_r_r<E, E>;
  opcode_table[0x5c] = &CPU::op_ld_r_r<E, H>;
  opcode_table[0x5d] = &CPU::op_ld_r_r<E, L>;
  opcode_table[0x5e] = &CPU::op_ld_r_hl<E>;
  opcode_table[0x5f] = &CPU::op_ld_r_r<E, A>;
  opcode_table[0x60] = &CPU::op_ld_r_r<H, B>;
  opcode_table[0x61] = &CPU::op_ld_r_r<H, C>;
  opcode_table[0x62] = &CPU::op_ld_r_r<H, D>;
  opcode_table[0x63] = &CPU::op_ld_r_r<H, E>;
  opcode_table[0x64] = &CPU::op_ld_r_r<H, H>;
  opcode_table[0x65] = &CPU::op_ld_r_r<H, L>;
  opcode_table[0x66] = &CPU::op_ld_r_hl<H>;
  opcode_table[0x67] = &CPU::op_ld_r_r<H, A>;
  opcode_table[0x68] = &CPU::op_ld_r_r<L, B>;
  opcode_table[0x69] = &CPU::op_ld_r_r<L, C>;
  opcode_table[0x6a] = &CPU::op_ld_r_r<L, D>;
  opcode_table[0x6b] = &CPU::op_ld_r_r<L, E>;
  opcode_table[0x6c] = &CPU::op_ld_r_r<L, H>;
  opcode_table[0x6d] = &CPU::op_ld_r_r<L, L>;
  opcode_table[0x6e] = &CPU::op_ld_r_hl<L>;
  opcode_table[0x6f] = &CPU::op_ld_r_r<L, A>;
  opcode_table[0x70] = &CPU::op_ld_hl_r<B>;
  opcode_table[0x71] = &CPU::op_ld_hl_r<C>;
  opcode_table[0x72] = &CPU::op_ld_hl_r<D>;
  opcode_table[0x73] = &CPU::op_ld_hl_r<E>;
  opcode_table[0x74] = &CPU::op_ld_hl_r<H>;
  opcode_table[0x75] = &CPU::op_ld_hl_r<L>;
  opcode_table[0x76] = &CPU::op_halt;
  opcode_table[0x77] = &CPU::op_ld_hl_r<A>;
  opcode_table[0x78] = &CPU::op_ld_r_r<A, B>;
  opcode_table[0x79] = &CPU::op_ld_r_r<A, C>;
  opcode_table[0x7a] = &CPU::op_ld_r_r<A, D>;
  opcode_table[0x7b] = &CPU::op_ld_r_r<A, E>;
  opcode_table[0x7c] = &CPU::op_ld_r_r<A, H>;
  opcode_table[0x7d] = &CPU::op_ld_r_r<A, L>;
  opcode_table[0x7e] = &CPU::op_ld_r_hl<A>;
  opcode_table[0x7f] = &CPU::op_ld_r_r<A, A>;
  opcode_table[0x80] = &CPU::op_add_a_r<B>;
  opcode_table[0x81] = &CPU::op_add_a_r<C>;
  opcode_table[0x82] = &CPU::op_add_a_r<D>;
  opcode_table[0x83] = &CPU::op_add_a_r<E>;
  opcode_table[0x84] = &CPU::op_add_a_r<H>;
  opcode_table[0x85] = &CPU::op_add_a_r<L>;
  opcode_table[0x86] = &CPU::op_add_a_hl;
  opcode_table[0x87] = &CPU::op_add_a_r<A>;
  opcode_table[0x88] = &CPU::op_adc_a_r<B>;
  opcode_table[0x89] = &CPU::op_adc_a_r<C>;
  opcode_table[0x8a] = &CPU::op_adc_a_r<D>;
  opcode_table[0x8b] = &CPU::op_adc_a_r<E>;
  opcode_table[0x8c] = &CPU::op_adc_a_r<H>;
  opcode_table[0x8d] = &CPU::op_adc_a_r<L>;
  opcode_table[0x8e] = &CPU::op_adc_a_hl;
  opcode_table[0x8f] = &CPU::op_adc_a_r<A>;
  opcode_table[0x90] = &CPU::op_sub_a_r<B>;
  opcode_table[0x91] = &CPU::op_sub_a_r<C>;
  opcode_table[0x92] = &CPU::op_sub_a_r<D>;
  opcode_table[0x93] = &CPU::op_sub_a_r<E>;
  opcode_table[0x94] = &CPU::op_sub_a_r<H>;
  opcode_table[0x95] = &CPU::op_sub_a_r<L>;
  opcode_table[0x96] = &CPU::op_sub_a_hl;
  opcode_table[0x97] = &CPU::op_sub_a_r<A>;
  opcode_table[0x98] = &CPU::op_sbc_a_r<B>;
  opcode_table[0x99] = &CPU::op_sbc_a_r<C>;
  opcode_table[0x9a] = &CPU::op_sbc_a_r<D>;
  opcode_table[0x9b] = &CPU::op_sbc_a_r<E>;
  opcode_table[0x9c] = &CPU::op_sbc_a_r<H>;
  opcode_table[0x9d] = &CPU::op_sbc_a_r<L>;
  opcode_table[0x9e] = &CPU::op_sbc_a_hl;
  opcode_table[0x9f] = &CPU::op_sbc_a_r<A>;
  opcode_table[0xa0] = &CPU::op_and_a_r<B>;
  opcode_table[0xa1] = &CPU::op_and_a_r<C>;
  opcode_table[0xa2] = &CPU::op_and_a_r<D>;
  opcode_table[0xa3] = &CPU::op_and_a_r<E>;
  opcode_table[0xa4] = &CPU::op_and_a_r<H>;
  opcode_table[0xa5] = &CPU::op_and_a_r<L>;
  opcode_table[0xa6] = &CPU::op_and_a_hl;
  opcode_table[0xa7] = &CPU::op_and_a_r<A>;
  opcode_table[0xa8] = &CPU::op_xor_a_r<B>;
  opcode_table[0xa9] = &CPU::op_xor_a_r<C>;
  opcode_table[0xaa] = &CPU::op_xor_a_r<D>;
  opcode_table[0xab] = &CPU::op_xor_a_r<E>;
  opcode_table[0xac] = &CPU::op_xor_a_r<H>;
  opcode_table[0xad] = &CPU::op_xor_a_r<L>;
  opcode_table[0xae] = &CPU::op_xor_a_hl;
  opcode_table[0xaf] = &CPU::op_xor_a_r<A>;
  opcode_table[0xb0] = &CPU::op_or_a_r<B>;
  opcode_table[0xb1] = &CPU::op_or_a_r<C>;
  opcode_table[0xb2] = &CPU::op_or_a_r<D>;
  opcode_table[0xb3] = &CPU::op_or_a_r<E>;
  opcode_table[0xb4] = &CPU::op_or_a_r<H>;
  opcode_table[0xb5] = &CPU::op_or_a_r<L>;
  opcode_table[0xb6] = &CPU::op_or_a_hl;
  opcode_table[0xb7] = &CPU::op_or_a_r<A>;
  opcode_table[0xb8] = &CPU::op_cp_a_r<B>;
  opcode_table[0xb9] = &CPU::op_cp_a_r<C>;
  opcode_table[0xba] = &CPU::op_cp_a_r<D>;
  opcode_table[0xbb] = &CPU::op_cp_a_r<E>;
  opcode_table[0xbc] = &CPU::op_cp_a_r<H>;
  opcode_table[0xbd] = &CPU::op_cp_a_r<L>;
  opcode_table[0xbe] = &CPU::op_cp_a_hl;
  opcode_table[0xbf] = &CPU::op_cp_a_r<A>;
  opcode_table[0xc0] = &CPU::op_ret_f<ZF, 0>;
  opcode_table[0xc1] = &CPU::op_pop_rr<BC>;
  opcode_table[0xc2] = &CPU::op_jp_f_nn<ZF, 0>;
  opcode_table[0xc3] = &CPU::op_jp_nn;
  opcode_table[0xc4] = &CPU::op_call_f_nn<ZF, 0>;
  opcode_table[0xc5] = &CPU::op_push_rr<BC>;
  opcode_table[0xc6] = &CPU::op_add_a_n;
  opcode_table[0xc7] = &CPU::op_rst_n<0x00>;
  opcode_table[0xc8] = &CPU::op_ret_f<ZF, 1>;
  opcode_table[0xc9] = &CPU::op_ret;
  opcode_table[0xca] = &CPU::op_jp_f_nn<ZF, 1>;
  opcode_table[0xcb] = &CPU::op_cb;
  opcode_table[0xcc] = &CPU::op_call_f_nn<ZF, 1>;
  opcode_table[0xcd] = &CPU::op_call_nn;
  opcode_table[0xce] = &CPU::op_adc_a_n;
  opcode_table[0xcf] = &CPU::op_rst_n<0x08>;
  opcode_table[0xd0] = &CPU::op_ret_f<CF, 0>;
  opcode_table[0xd1] = &CPU::op_pop_rr<DE>;
  opcode_table[0xd2] = &CPU::op_jp_f_nn<CF, 0>;
  opcode_table[0xd3] = &CPU::op_xx;
  opcode_table[0xd4] = &CPU::op_call_f_nn<CF, 0>;
  opcode_table[0xd5] = &CPU::op_push_rr<DE>;
  opcode_table[0xd6] = &CPU::op_sub_a_n;
  opcode_table[0xd7] = &CPU::op_rst_n<0x10>;
  opcode_table[0xd8] = &CPU::op_ret_f<CF, 1>;
  opcode_table[0xd9] = &CPU::op_reti;
  opcode_table[0xda] = &CPU::op_jp_f_nn<CF, 1>;
  opcode_table[0xdb] = &CPU::op_xx;
  opcode_table[0xdc] = &CPU::op_call_f_nn<CF, 1>;
  opcode_table[0xdd] = &CPU::op_xx;
  opcode_table[0xde] = &CPU::op_sbc_a_n;
  opcode_table[0xdf] = &CPU::op_rst_n<0x18>;
  opcode_table[0xe0] = &CPU::op_ld_ffn_a;
  opcode_table[0xe1] = &CPU::op_pop_rr<HL>;
  opcode_table[0xe2] = &CPU::op_ld_ffc_a;
  opcode_table[0xe3] = &CPU::op_xx;
  opcode_table[0xe4] = &CPU::op_xx;
  opcode_table[0xe5] = &CPU::op_push_rr<HL>;
  opcode_table[0xe6] = &CPU::op_and_a_n;
  opcode_table[0xe7] = &CPU::op_rst_n<0x20>;
  opcode_table[0xe8] = &CPU::op_add_sp_n;
  opcode_table[0xe9] = &CPU::op_jp_hl;
  opcode_table[0xea] = &CPU::op_ld_nn_a;
  opcode_table[0xeb] = &CPU::op_xx;
  opcode_table[0xec] = &CPU::op_xx;
  opcode_table[0xed] = &CPU::op_xx;
  opcode_table[0xee] = &CPU::op_xor_a_n;
  opcode_table[0xef] = &CPU::op_rst_n<0x28>;
  opcode_table[0xf0] = &CPU::op_ld_a_ffn;
  opcode_table[0xf1] = &CPU::op_pop_rr<AF>;
  opcode_table[0xf2] = &CPU::op_ld_a_ffc;
  opcode_table[0xf3] = &CPU::op_di;
  opcode_table[0xf4] = &CPU::op_xx;
  opcode_table[0xf5] = &CPU::op_push_rr<AF>;
  opcode_table[0xf6] = &CPU::op_or_a_n;
  opcode_table[0xf7] = &CPU::op_rst_n<0x30>;
  opcode_table[0xf8] = &CPU::op_ld_hl_sp_n;
  opcode_table[0xf9] = &CPU::op_ld_sp_hl;
  opcode_table[0xfa] = &CPU::op_ld_a_nn;
  opcode_table[0xfb] = &CPU::op_ei;
  opcode_table[0xfc] = &CPU::op_xx;
  opcode_table[0xfd] = &CPU::op_xx;
  opcode_table[0xfe] = &CPU::op_cp_a_n;
  opcode_table[0xff] = &CPU::op_rst_n<0x38>;

  opcode_table_cb[0x00] = &CPU::op_rlc_r<B>;
  opcode_table_cb[0x01] = &CPU::op_rlc_r<C>;
  opcode_table_cb[0x02] = &CPU::op_rlc_r<D>;
  opcode_table_cb[0x03] = &CPU::op_rlc_r<E>;
  opcode_table_cb[0x04] = &CPU::op_rlc_r<H>;
  opcode_table_cb[0x05] = &CPU::op_rlc_r<L>;
  opcode_table_cb[0x06] = &CPU::op_rlc_hl;
  opcode_table_cb[0x07] = &CPU::op_rlc_r<A>;
  opcode_table_cb[0x08] = &CPU::op_rrc_r<B>;
  opcode_table_cb[0x09] = &CPU::op_rrc_r<C>;
  opcode_table_cb[0x0a] = &CPU::op_rrc_r<D>;
  opcode_table_cb[0x0b] = &CPU::op_rrc_r<E>;
  opcode_table_cb[0x0c] = &CPU::op_rrc_r<H>;
  opcode_table_cb[0x0d] = &CPU::op_rrc_r<L>;
  opcode_table_cb[0x0e] = &CPU::op_rrc_hl;
  opcode_table_cb[0x0f] = &CPU::op_rrc_r<A>;
  opcode_table_cb[0x10] = &CPU::op_rl_r<B>;
  opcode_table_cb[0x11] = &CPU::op_rl_r<C>;
  opcode_table_cb[0x12] = &CPU::op_rl_r<D>;
  opcode_table_cb[0x13] = &CPU::op_rl_r<E>;
  opcode_table_cb[0x14] = &CPU::op_rl_r<H>;
  opcode_table_cb[0x15] = &CPU::op_rl_r<L>;
  opcode_table_cb[0x16] = &CPU::op_rl_hl;
  opcode_table_cb[0x17] = &CPU::op_rl_r<A>;
  opcode_table_cb[0x18] = &CPU::op_rr_r<B>;
  opcode_table_cb[0x19] = &CPU::op_rr_r<C>;
  opcode_table_cb[0x1a] = &CPU::op_rr_r<D>;
  opcode_table_cb[0x1b] = &CPU::op_rr_r<E>;
  opcode_table_cb[0x1c] = &CPU::op_rr_r<H>;
  opcode_table_cb[0x1d] = &CPU::op_rr_r<L>;
  opcode_table_cb[0x1e] = &CPU::op_rr_hl;
  opcode_table_cb[0x1f] = &CPU::op_rr_r<A>;
  opcode_table_cb[0x20] = &CPU::op_sla_r<B>;
  opcode_table_cb[0x21] = &CPU::op_sla_r<C>;
  opcode_table_cb[0x22] = &CPU::op_sla_r<D>;
  opcode_table_cb[0x23] = &CPU::op_sla_r<E>;
  opcode_table_cb[0x24] = &CPU::op_sla_r<H>;
  opcode_table_cb[0x25] = &CPU::op_sla_r<L>;
  opcode_table_cb[0x26] = &CPU::op_sla_hl;
  opcode_table_cb[0x27] = &CPU::op_sla_r<A>;
  opcode_table_cb[0x28] = &CPU::op_sra_r<B>;
  opcode_table_cb[0x29] = &CPU::op_sra_r<C>;
  opcode_table_cb[0x2a] = &CPU::op_sra_r<D>;
  opcode_table_cb[0x2b] = &CPU::op_sra_r<E>;
  opcode_table_cb[0x2c] = &CPU::op_sra_r<H>;
  opcode_table_cb[0x2d] = &CPU::op_sra_r<L>;
  opcode_table_cb[0x2e] = &CPU::op_sra_hl;
  opcode_table_cb[0x2f] = &CPU::op_sra_r<A>;
  opcode_table_cb[0x30] = &CPU::op_swap_r<B>;
  opcode_table_cb[0x31] = &CPU::op_swap_r<C>;
  opcode_table_cb[0x32] = &CPU::op_swap_r<D>;
  opcode_table_cb[0x33] = &CPU::op_swap_r<E>;
  opcode_table_cb[0x34] = &CPU::op_swap_r<H>;
  opcode_table_cb[0x35] = &CPU::op_swap_r<L>;
  opcode_table_cb[0x36] = &CPU::op_swap_hl;
  opcode_table_cb[0x37] = &CPU::op_swap_r<A>;
  opcode_table_cb[0x38] = &CPU::op_srl_r<B>;
  opcode_table_cb[0x39] = &CPU::op_srl_r<C>;
  opcode_table_cb[0x3a] = &CPU::op_srl_r<D>;
  opcode_table_cb[0x3b] = &CPU::op_srl_r<E>;
  opcode_table_cb[0x3c] = &CPU::op_srl_r<H>;
  opcode_table_cb[0x3d] = &CPU::op_srl_r<L>;
  opcode_table_cb[0x3e] = &CPU::op_srl_hl;
  opcode_table_cb[0x3f] = &CPU::op_srl_r<A>;
  opcode_table_cb[0x40] = &CPU::op_bit_n_r<0, B>;
  opcode_table_cb[0x41] = &CPU::op_bit_n_r<0, C>;
  opcode_table_cb[0x42] = &CPU::op_bit_n_r<0, D>;
  opcode_table_cb[0x43] = &CPU::op_bit_n_r<0, E>;
  opcode_table_cb[0x44] = &CPU::op_bit_n_r<0, H>;
  opcode_table_cb[0x45] = &CPU::op_bit_n_r<0, L>;
  opcode_table_cb[0x46] = &CPU::op_bit_n_hl<0>;
  opcode_table_cb[0x47] = &CPU::op_bit_n_r<0, A>;
  opcode_table_cb[0x48] = &CPU::op_bit_n_r<1, B>;
  opcode_table_cb[0x49] = &CPU::op_bit_n_r<1, C>;
  opcode_table_cb[0x4a] = &CPU::op_bit_n_r<1, D>;
  opcode_table_cb[0x4b] = &CPU::op_bit_n_r<1, E>;
  opcode_table_cb[0x4c] = &CPU::op_bit_n_r<1, H>;
  opcode_table_cb[0x4d] = &CPU::op_bit_n_r<1, L>;
  opcode_table_cb[0x4e] = &CPU::op_bit_n_hl<1>;
  opcode_table_cb[0x4f] = &CPU::op_bit_n_r<1, A>;
  opcode_table_cb[0x50] = &CPU::op_bit_n_r<2, B>;
  opcode_table_cb[0x51] = &CPU::op_bit_n_r<2, C>;
  opcode_table_cb[0x52] = &CPU::op_bit_n_r<2, D>;
  opcode_table_cb[0x53] = &CPU::op_bit_n_r<2, E>;
  opcode_table_cb[0x54] = &CPU::op_bit_n_r<2, H>;
  opcode_table_cb[0x55] = &CPU::op_bit_n_r<2, L>;
  opcode_table_cb[0x56] = &CPU::op_bit_n_hl<2>;
  opcode_table_cb[0x57] = &CPU::op_bit_n_r<2, A>;
  opcode_table_cb[0x58] = &CPU::op_bit_n_r<3, B>;
  opcode_table_cb[0x59] = &CPU::op_bit_n_r<3, C>;
  opcode_table_cb[0x5a] = &CPU::op_bit_n_r<3, D>;
  opcode_table_cb[0x5b] = &CPU::op_bit_n_r<3, E>;
  opcode_table_cb[0x5c] = &CPU::op_bit_n_r<3, H>;
  opcode_table_cb[0x5d] = &CPU::op_bit_n_r<3, L>;
  opcode_table_cb[0x5e] = &CPU::op_bit_n_hl<3>;
  opcode_table_cb[0x5f] = &CPU::op_bit_n_r<3, A>;
  opcode_table_cb[0x60] = &CPU::op_bit_n_r<4, B>;
  opcode_table_cb[0x61] = &CPU::op_bit_n_r<4, C>;
  opcode_table_cb[0x62] = &CPU::op_bit_n_r<4, D>;
  opcode_table_cb[0x63] = &CPU::op_bit_n_r<4, E>;
  opcode_table_cb[0x64] = &CPU::op_bit_n_r<4, H>;
  opcode_table_cb[0x65] = &CPU::op_bit_n_r<4, L>;
  opcode_table_cb[0x66] = &CPU::op_bit_n_hl<4>;
  opcode_table_cb[0x67] = &CPU::op_bit_n_r<4, A>;
  opcode_table_cb[0x68] = &CPU::op_bit_n_r<5, B>;
  opcode_table_cb[0x69] = &CPU::op_bit_n_r<5, C>;
  opcode_table_cb[0x6a] = &CPU::op_bit_n_r<5, D>;
  opcode_table_cb[0x6b] = &CPU::op_bit_n_r<5, E>;
  opcode_table_cb[0x6c] = &CPU::op_bit_n_r<5, H>;
  opcode_table_cb[0x6d] = &CPU::op_bit_n_r<5, L>;
  opcode_table_cb[0x6e] = &CPU::op_bit_n_hl<5>;
  opcode_table_cb[0x6f] = &CPU::op_bit_n_r<5, A>;
  opcode_table_cb[0x70] = &CPU::op_bit_n_r<6, B>;
  opcode_table_cb[0x71] = &CPU::op_bit_n_r<6, C>;
  opcode_table_cb[0x72] = &CPU::op_bit_n_r<6, D>;
  opcode_table_cb[0x73] = &CPU::op_bit_n_r<6, E>;
  opcode_table_cb[0x74] = &CPU::op_bit_n_r<6, H>;
  opcode_table_cb[0x75] = &CPU::op_bit_n_r<6, L>;
  opcode_table_cb[0x76] = &CPU::op_bit_n_hl<6>;
  opcode_table_cb[0x77] = &CPU::op_bit_n_r<6, A>;
  opcode_table_cb[0x78] = &CPU::op_bit_n_r<7, B>;
  opcode_table_cb[0x79] = &CPU::op_bit_n_r<7, C>;
  opcode_table_cb[0x7a] = &CPU::op_bit_n_r<7, D>;
  opcode_table_cb[0x7b] = &CPU::op_bit_n_r<7, E>;
  opcode_table_cb[0x7c] = &CPU::op_bit_n_r<7, H>;
  opcode_table_cb[0x7d] = &CPU::op_bit_n_r<7, L>;
  opcode_table_cb[0x7e] = &CPU::op_bit_n_hl<7>;
  opcode_table_cb[0x7f] = &CPU::op_bit_n_r<7, A>;
  opcode_table_cb[0x80] = &CPU::op_res_n_r<0, B>;
  opcode_table_cb[0x81] = &CPU::op_res_n_r<0, C>;
  opcode_table_cb[0x82] = &CPU::op_res_n_r<0, D>;
  opcode_table_cb[0x83] = &CPU::op_res_n_r<0, E>;
  opcode_table_cb[0x84] = &CPU::op_res_n_r<0, H>;
  opcode_table_cb[0x85] = &CPU::op_res_n_r<0, L>;
  opcode_table_cb[0x86] = &CPU::op_res_n_hl<0>;
  opcode_table_cb[0x87] = &CPU::op_res_n_r<0, A>;
  opcode_table_cb[0x88] = &CPU::op_res_n_r<1, B>;
  opcode_table_cb[0x89] = &CPU::op_res_n_r<1, C>;
  opcode_table_cb[0x8a] = &CPU::op_res_n_r<1, D>;
  opcode_table_cb[0x8b] = &CPU::op_res_n_r<1, E>;
  opcode_table_cb[0x8c] = &CPU::op_res_n_r<1, H>;
  opcode_table_cb[0x8d] = &CPU::op_res_n_r<1, L>;
  opcode_table_cb[0x8e] = &CPU::op_res_n_hl<1>;
  opcode_table_cb[0x8f] = &CPU::op_res_n_r<1, A>;
  opcode_table_cb[0x90] = &CPU::op_res_n_r<2, B>;
  opcode_table_cb[0x91] = &CPU::op_res_n_r<2, C>;
  opcode_table_cb[0x92] = &CPU::op_res_n_r<2, D>;
  opcode_table_cb[0x93] = &CPU::op_res_n_r<2, E>;
  opcode_table_cb[0x94] = &CPU::op_res_n_r<2, H>;
  opcode_table_cb[0x95] = &CPU::op_res_n_r<2, L>;
  opcode_table_cb[0x96] = &CPU::op_res_n_hl<2>;
  opcode_table_cb[0x97] = &CPU::op_res_n_r<2, A>;
  opcode_table_cb[0x98] = &CPU::op_res_n_r<3, B>;
  opcode_table_cb[0x99] = &CPU::op_res_n_r<3, C>;
  opcode_table_cb[0x9a] = &CPU::op_res_n_r<3, D>;
  opcode_table_cb[0x9b] = &CPU::op_res_n_r<3, E>;
  opcode_table_cb[0x9c] = &CPU::op_res_n_r<3, H>;
  opcode_table_cb[0x9d] = &CPU::op_res_n_r<3, L>;
  opcode_table_cb[0x9e] = &CPU::op_res_n_hl<3>;
  opcode_table_cb[0x9f] = &CPU::op_res_n_r<3, A>;
  opcode_table_cb[0xa0] = &CPU::op_res_n_r<4, B>;
  opcode_table_cb[0xa1] = &CPU::op_res_n_r<4, C>;
  opcode_table_cb[0xa2] = &CPU::op_res_n_r<4, D>;
  opcode_table_cb[0xa3] = &CPU::op_res_n_r<4, E>;
  opcode_table_cb[0xa4] = &CPU::op_res_n_r<4, H>;
  opcode_table_cb[0xa5] = &CPU::op_res_n_r<4, L>;
  opcode_table_cb[0xa6] = &CPU::op_res_n_hl<4>;
  opcode_table_cb[0xa7] = &CPU::op_res_n_r<4, A>;
  opcode_table_cb[0xa8] = &CPU::op_res_n_r<5, B>;
  opcode_table_cb[0xa9] = &CPU::op_res_n_r<5, C>;
  opcode_table_cb[0xaa] = &CPU::op_res_n_r<5, D>;
  opcode_table_cb[0xab] = &CPU::op_res_n_r<5, E>;
  opcode_table_cb[0xac] = &CPU::op_res_n_r<5, H>;
  opcode_table_cb[0xad] = &CPU::op_res_n_r<5, L>;
  opcode_table_cb[0xae] = &CPU::op_res_n_hl<5>;
  opcode_table_cb[0xaf] = &CPU::op_res_n_r<5, A>;
  opcode_table_cb[0xb0] = &CPU::op_res_n_r<6, B>;
  opcode_table_cb[0xb1] = &CPU::op_res_n_r<6, C>;
  opcode_table_cb[0xb2] = &CPU::op_res_n_r<6, D>;
  opcode_table_cb[0xb3] = &CPU::op_res_n_r<6, E>;
  opcode_table_cb[0xb4] = &CPU::op_res_n_r<6, H>;
  opcode_table_cb[0xb5] = &CPU::op_res_n_r<6, L>;
  opcode_table_cb[0xb6] = &CPU::op_res_n_hl<6>;
  opcode_table_cb[0xb7] = &CPU::op_res_n_r<6, A>;
  opcode_table_cb[0xb8] = &CPU::op_res_n_r<7, B>;
  opcode_table_cb[0xb9] = &CPU::op_res_n_r<7, C>;
  opcode_table_cb[0xba] = &CPU::op_res_n_r<7, D>;
  opcode_table_cb[0xbb] = &CPU::op_res_n_r<7, E>;
  opcode_table_cb[0xbc] = &CPU::op_res_n_r<7, H>;
  opcode_table_cb[0xbd] = &CPU::op_res_n_r<7, L>;
  opcode_table_cb[0xbe] = &CPU::op_res_n_hl<7>;
  opcode_table_cb[0xbf] = &CPU::op_res_n_r<7, A>;
  opcode_table_cb[0xc0] = &CPU::op_set_n_r<0, B>;
  opcode_table_cb[0xc1] = &CPU::op_set_n_r<0, C>;
  opcode_table_cb[0xc2] = &CPU::op_set_n_r<0, D>;
  opcode_table_cb[0xc3] = &CPU::op_set_n_r<0, E>;
  opcode_table_cb[0xc4] = &CPU::op_set_n_r<0, H>;
  opcode_table_cb[0xc5] = &CPU::op_set_n_r<0, L>;
  opcode_table_cb[0xc6] = &CPU::op_set_n_hl<0>;
  opcode_table_cb[0xc7] = &CPU::op_set_n_r<0, A>;
  opcode_table_cb[0xc8] = &CPU::op_set_n_r<1, B>;
  opcode_table_cb[0xc9] = &CPU::op_set_n_r<1, C>;
  opcode_table_cb[0xca] = &CPU::op_set_n_r<1, D>;
  opcode_table_cb[0xcb] = &CPU::op_set_n_r<1, E>;
  opcode_table_cb[0xcc] = &CPU::op_set_n_r<1, H>;
  opcode_table_cb[0xcd] = &CPU::op_set_n_r<1, L>;
  opcode_table_cb[0xce] = &CPU::op_set_n_hl<1>;
  opcode_table_cb[0xcf] = &CPU::op_set_n_r<1, A>;
  opcode_table_cb[0xd0] = &CPU::op_set_n_r<2, B>;
  opcode_table_cb[0xd1] = &CPU::op_set_n_r<2, C>;
  opcode_table_cb[0xd2] = &CPU::op_set_n_r<2, D>;
  opcode_table_cb[0xd3] = &CPU::op_set_n_r<2, E>;
  opcode_table_cb[0xd4] = &CPU::op_set_n_r<2, H>;
  opcode_table_cb[0xd5] = &CPU::op_set_n_r<2, L>;
  opcode_table_cb[0xd6] = &CPU::op_set_n_hl<2>;
  opcode_table_cb[0xd7] = &CPU::op_set_n_r<2, A>;
  opcode_table_cb[0xd8] = &CPU::op_set_n_r<3, B>;
  opcode_table_cb[0xd9] = &CPU::op_set_n_r<3, C>;
  opcode_table_cb[0xda] = &CPU::op_set_n_r<3, D>;
  opcode_table_cb[0xdb] = &CPU::op_set_n_r<3, E>;
  opcode_table_cb[0xdc] = &CPU::op_set_n_r<3, H>;
  opcode_table_cb[0xdd] = &CPU::op_set_n_r<3, L>;
  opcode_table_cb[0xde] = &CPU::op_set_n_hl<3>;
  opcode_table_cb[0xdf] = &CPU::op_set_n_r<3, A>;
  opcode_table_cb[0xe0] = &CPU::op_set_n_r<4, B>;
  opcode_table_cb[0xe1] = &CPU::op_set_n_r<4, C>;
  opcode_table_cb[0xe2] = &CPU::op_set_n_r<4, D>;
  opcode_table_cb[0xe3] = &CPU::op_set_n_r<4, E>;
  opcode_table_cb[0xe4] = &CPU::op_set_n_r<4, H>;
  opcode_table_cb[0xe5] = &CPU::op_set_n_r<4, L>;
  opcode_table_cb[0xe6] = &CPU::op_set_n_hl<4>;
  opcode_table_cb[0xe7] = &CPU::op_set_n_r<4, A>;
  opcode_table_cb[0xe8] = &CPU::op_set_n_r<5, B>;
  opcode_table_cb[0xe9] = &CPU::op_set_n_r<5, C>;
  opcode_table_cb[0xea] = &CPU::op_set_n_r<5, D>;
  opcode_table_cb[0xeb] = &CPU::op_set_n_r<5, E>;
  opcode_table_cb[0xec] = &CPU::op_set_n_r<5, H>;
  opcode_table_cb[0xed] = &CPU::op_set_n_r<5, L>;
  opcode_table_cb[0xee] = &CPU::op_set_n_hl<5>;
  opcode_table_cb[0xef] = &CPU::op_set_n_r<5, A>;
  opcode_table_cb[0xf0] = &CPU::op_set_n_r<6, B>;
  opcode_table_cb[0xf1] = &CPU::op_set_n_r<6, C>;
  opcode_table_cb[0xf2] = &CPU::op_set_n_r<6, D>;
  opcode_table_cb[0xf3] = &CPU::op_set_n_r<6, E>;
  opcode_table_cb[0xf4] = &CPU::op_set_n_r<6, H>;
  opcode_table_cb[0xf5] = &CPU::op_set_n_r<6, L>;
  opcode_table_cb[0xf6] = &CPU::op_set_n_hl<6>;
  opcode_table_cb[0xf7] = &CPU::op_set_n_r<6, A>;
  opcode_table_cb[0xf8] = &CPU::op_set_n_r<7, B>;
  opcode_table_cb[0xf9] = &CPU::op_set_n_r<7, C>;
  opcode_table_cb[0xfa] = &CPU::op_set_n_r<7, D>;
  opcode_table_cb[0xfb] = &CPU::op_set_n_r<7, E>;
  opcode_table_cb[0xfc] = &CPU::op_set_n_r<7, H>;
  opcode_table_cb[0xfd] = &CPU::op_set_n_r<7, L>;
  opcode_table_cb[0xfe] = &CPU::op_set_n_hl<7>;
  opcode_table_cb[0xff] = &CPU::op_set_n_r<7, A>;
}

#endif
