/* $Id: bsl.c 2051 2008-11-03 21:15:33Z ensonic $
 *
 * Buzztard
 * Copyright (C) 2006 Buzztard team <buzztard-devel@lists.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define BT_BSL_C

#include "bsl.h"

GST_DEBUG_CATEGORY(GST_CAT_DEFAULT);

/*
 * bt_song_io_detect:
 * @filename: the full filename of the song
 * 
 * checks if this modules can handle the supplied file.
 *
 * Returns: the type of this #SongIO sub-class or 0 if the file cannot be handled
 */
static GType bt_song_io_detect(const gchar *file_name) {
  GType type=0;
  gchar *lc_file_name;

  static gboolean first_run=TRUE;
  if(first_run) {
#ifdef ENABLE_NLS
    setlocale (LC_ALL, "");
    bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif /* ENABLE_NLS */

    GST_DEBUG_CATEGORY_INIT(GST_CAT_DEFAULT, "bt-bsl", 0, "music production environment / buzz song io plugin");
    first_run=FALSE;
  }

  GST_INFO("file_name=\"%s\"",file_name);
  if(!file_name) return(type);
  
  lc_file_name=g_ascii_strdown(file_name,-1);
  
  if(g_str_has_suffix(lc_file_name,".bmx") ||
    g_str_has_suffix(lc_file_name,".bmw")) {
    type=BT_TYPE_SONG_IO_BUZZ;
  }
  g_free(lc_file_name);
  return(type);
}

/**
 * bt_song_io_module_info:
 *
 * Buzz song loader metadata.
 */
BtSongIOModuleInfo bt_song_io_module_info = {
  bt_song_io_detect,
  {
    { "buzz song with waves", "audio/x-bmx", "bmx" },
    { "buzz song without waves", "audio/x-bmw", "bmw" },
    { NULL, }
  }
};

