/***************************************************************************
                          bkexcept.h  -  description
                             -------------------
    begin                : Thu Feb 06 2003
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef BKEXCEPT_H
#define BKEXCEPT_H

#include <QString>

#define BKEXCEPT(em) throw(BkException(em, __FILE__, __LINE__))

/***************************************************************************
 *                                                                         *
 *   The BkException class is used throughout BookmarkBridge to            *
 *   communicate exceptions containing error messages and other pertinant  *
 *   information concerning an exception.                                  *
 *                                                                         *
 ***************************************************************************/

class BkException
{
public:
	BkException(const QString msg, const char *file, int line)
		: m_msg(msg), m_file(file), m_line(line) { };

	BkException & operator=(const BkException &bk)
	{
		if(&bk != this)
		{
			m_msg = bk.m_msg;
			m_file = bk.m_file;
			m_line = bk.m_line;
		}
		return *this;
	}

	const QString& msg(void) const		{ return m_msg; }
	const QString& file(void) const	{ return m_file; }
	int line(void) const			{ return m_line; }

private:
	QString m_msg;
	QString m_file;
	int     m_line;
};

#endif	// end of BKEXCEPT_H
