/*
 * $Id: pywab.h 449 2003-10-25 09:32:44Z rogerb $
 *
 * This file is parsed by both Swig and C++
 *
 */

#ifdef SWIG
%immutable;  // nothing is modifiable
%include "cstring.i"
#endif


class entryid
{
  void *data;
  size_t len;
  entryid(entryid &); // copying and assignment not allowed
  void operator=(entryid &);
 public:
  entryid(): data(0), len(0) { }
#ifndef SWIG
  entryid(void *, size_t);
#endif
  ~entryid();
#ifndef SWIG
  LPENTRYID getdata() const { return (LPENTRYID)data; }
  size_t getlen() const { return len; }
#endif

};



#ifndef SWIG
class refcounter
{
  int count;
 public:
  refcounter() : count(0) {}
  void AddRef() { count++; }
  bool Release() { count--; return count==0; }
};
#endif

/* One of these is created by the Initialize function */
class wabmodule
{
  HMODULE hModule;
  LPWABOPEN openfn;
  LPADRBOOK addrbook;
  LPWABOBJECT wabobject;
  refcounter *refcount;
  // private constructor
  wabmodule(HMODULE &hm, LPWABOPEN &op, LPADRBOOK &bk, LPWABOBJECT &wo) : hModule(hm), 
    openfn(op), addrbook(bk), wabobject(wo), refcount(new refcounter())
    {
      refcount->AddRef();
    }
  friend wabmodule* Initialize(bool, const char *);

 public:
#ifndef SWIG
  wabmodule(const wabmodule&);
  void FreeObject(LPSRowSet rows);
  void FreeObject(LPSPropTagArray ta);
#endif
  ~wabmodule();
#ifdef SWIG
%newobject getpab;
%newobject openobject;
#endif
  entryid *getpab(void);
  class wabobject *openobject(const entryid&);
};

class wabobject
{
  LPUNKNOWN iface;
  ULONG type;
  class wabmodule module;

  wabobject(wabobject&); //copying and assignment not allowed
  void operator=(wabobject&);
  // private contstructor
  wabobject(const wabmodule& mod, ULONG t, LPUNKNOWN iface);
  friend class wabmodule;
 public:
  ~wabobject();
   unsigned long gettype() const { return type; }

#ifdef SWIG
%newobject getcontentstable;
#endif
  class wabtable* getcontentstable(unsigned long flags); 
};

class wabtable
{
  LPMAPITABLE table;
  class wabmodule module;
  wabtable(wabtable&);       //copying and assignment not allowed
  void operator=(wabtable&);
  // private constructor
  wabtable(const wabmodule &mod, LPMAPITABLE t) : table(t), module(mod) {}
  friend class wabobject;
 public:
#ifdef SWIG
%newobject makeentryid;
%cstring_output_allocate_size(char **TheData, size_t *TheLength,);
#endif
  entryid* makeentryid(unsigned long pointer, unsigned long len);
  void makebinarystring(char **TheData, size_t *TheLength, unsigned long pointer, unsigned long len);

  ~wabtable();
  int getrowcount();
  bool enableallcolumns();
  bool enablecolumns(class proptagarray &);
#ifdef SWIG
%newobject getnextrow;
#endif
  class wabrow* getnextrow();
};

class proptagarray
{
  ULONG *array;
  friend class wabtable;
 public:
  inline proptagarray(unsigned length) : array(new ULONG[length+1]) {array[0]=length;}
  inline ~proptagarray() { delete [] array; }
  inline void setitem(unsigned which, unsigned long value) { array[which+1]=value; }
};

class wabrow
{
  LPSRowSet rowset;     
  class wabmodule module;
  wabrow(wabrow&);        //copying and assignment not allowed
  void operator=(wabrow&);
  // private constructor
  wabrow(const wabmodule &mod, LPSRowSet r) : rowset(r), module(mod) {}
  friend class wabtable;
 public:
  ~wabrow();
  unsigned numproperties();
  const char *getpropertyname(unsigned which);
  const char *getpropertyvalue(unsigned which);
  bool IsEmpty();
};

#ifdef SWIG
// this is here to convince swig to make a class named constants with the various
// members.  we do some sed magic on the swig generated code to get the correct
// values
class constants
{
  constants();
  ~constants();
 public:
  
  // PR_CONTAINER_FLAGS
  static enum {AB_FIND_ON_OPEN, AB_MODIFIABLE, AB_RECIPIENTS, AB_SUBCONTAINERS, AB_UNMODIFIABLE} ;
  // IABContainer::GetContentsTable 
  static enum {WAB_LOCAL_CONTAINERS, WAB_PROFILE_CONTENTS} ;
  // PR_OBJECT_TYPE
  static enum {MAPI_STORE, MAPI_ADDRBOOK, MAPI_FOLDER, MAPI_ABCONT, MAPI_MESSAGE, 
	       MAPI_MAILUSER, MAPI_ATTACH, MAPI_DISTLIST, MAPI_PROFSECT, MAPI_STATUS, 
	       MAPI_SESSION, MAPI_FORMINFO };
  // PR_DISPLAY_TYPE
  static enum {DT_AGENT, DT_DISTLIST, DT_FOLDER, DT_FOLDER_LINK, DT_FORUM,
	       DT_GLOBAL, DT_LOCAL, DT_MAILUSER, DT_MODIFIABLE, DT_NOT_SPECIFIC, DT_ORGANIZATION,
	       DT_PRIVATE_DISTLIST, DT_REMOTE_MAILUSER, DT_WAN};

  // All the pr names - generated with 'genprops spew'
  static enum {
  PR_7BIT_DISPLAY_NAME, PR_AB_PROVIDER_ID, PR_ACCESS, PR_ACCESS_LEVEL,
  PR_ACCOUNT, PR_ACCOUNT_A, PR_ACCOUNT_W, PR_ADDRTYPE, PR_ADDRTYPE_A,
  PR_ADDRTYPE_W, PR_ALTERNATE_RECIPIENT, PR_ANR, PR_ANR_A, PR_ANR_W,
  PR_ASSISTANT, PR_ASSISTANT_A, PR_ASSISTANT_TELEPHONE_NUMBER,
  PR_ASSISTANT_TELEPHONE_NUMBER_A, PR_ASSISTANT_TELEPHONE_NUMBER_W,
  PR_ASSISTANT_W, PR_ASSOC_CONTENT_COUNT, PR_BEEPER_TELEPHONE_NUMBER,
  PR_BEEPER_TELEPHONE_NUMBER_A, PR_BEEPER_TELEPHONE_NUMBER_W,
  PR_BIRTHDAY, PR_BUSINESS2_TELEPHONE_NUMBER,
  PR_BUSINESS2_TELEPHONE_NUMBER_A, PR_BUSINESS2_TELEPHONE_NUMBER_W,
  PR_BUSINESS_ADDRESS_CITY, PR_BUSINESS_ADDRESS_COUNTRY,
  PR_BUSINESS_ADDRESS_POSTAL_CODE, PR_BUSINESS_ADDRESS_POST_OFFICE_BOX,
  PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_A,
  PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_W,
  PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE, PR_BUSINESS_ADDRESS_STREET,
  PR_BUSINESS_FAX_NUMBER, PR_BUSINESS_FAX_NUMBER_A,
  PR_BUSINESS_FAX_NUMBER_W, PR_BUSINESS_HOME_PAGE,
  PR_BUSINESS_HOME_PAGE_A, PR_BUSINESS_HOME_PAGE_W,
  PR_BUSINESS_TELEPHONE_NUMBER, PR_BUSINESS_TELEPHONE_NUMBER_A,
  PR_BUSINESS_TELEPHONE_NUMBER_W, PR_CALLBACK_TELEPHONE_NUMBER,
  PR_CALLBACK_TELEPHONE_NUMBER_A, PR_CALLBACK_TELEPHONE_NUMBER_W,
  PR_CAR_TELEPHONE_NUMBER, PR_CAR_TELEPHONE_NUMBER_A,
  PR_CAR_TELEPHONE_NUMBER_W, PR_CELLULAR_TELEPHONE_NUMBER,
  PR_CELLULAR_TELEPHONE_NUMBER_A, PR_CELLULAR_TELEPHONE_NUMBER_W,
  PR_CHILDRENS_NAMES, PR_CHILDRENS_NAMES_A, PR_CHILDRENS_NAMES_W,
  PR_COMMENT, PR_COMMENT_A, PR_COMMENT_W, PR_COMPANY_MAIN_PHONE_NUMBER,
  PR_COMPANY_MAIN_PHONE_NUMBER_A, PR_COMPANY_MAIN_PHONE_NUMBER_W,
  PR_COMPANY_NAME, PR_COMPANY_NAME_A, PR_COMPANY_NAME_W,
  PR_COMPUTER_NETWORK_NAME, PR_COMPUTER_NETWORK_NAME_A,
  PR_COMPUTER_NETWORK_NAME_W, PR_CONTACT_ADDRTYPES,
  PR_CONTACT_ADDRTYPES_A, PR_CONTACT_ADDRTYPES_W,
  PR_CONTACT_DEFAULT_ADDRESS_INDEX, PR_CONTACT_EMAIL_ADDRESSES,
  PR_CONTACT_EMAIL_ADDRESSES_A, PR_CONTACT_EMAIL_ADDRESSES_W,
  PR_CONTACT_ENTRYIDS, PR_CONTACT_VERSION, PR_CONTAINER_CLASS,
  PR_CONTAINER_CLASS_A, PR_CONTAINER_CLASS_W, PR_CONTAINER_CONTENTS,
  PR_CONTAINER_FLAGS, PR_CONTAINER_HIERARCHY,
  PR_CONTAINER_MODIFY_VERSION, PR_CONTENTS_SORT_ORDER, PR_CONTENT_COUNT,
  PR_CONTENT_UNREAD, PR_CONVERSION_PROHIBITED, PR_COUNTRY, PR_COUNTRY_A,
  PR_COUNTRY_W, PR_CREATE_TEMPLATES, PR_CREATION_TIME, PR_CUSTOMER_ID,
  PR_CUSTOMER_ID_A, PR_CUSTOMER_ID_W, PR_DEFAULT_VIEW_ENTRYID,
  PR_DEF_CREATE_DL, PR_DEF_CREATE_MAILUSER, PR_DEPARTMENT_NAME,
  PR_DEPARTMENT_NAME_A, PR_DEPARTMENT_NAME_W, PR_DEPTH, PR_DETAILS_TABLE,
  PR_DISCLOSE_RECIPIENTS, PR_DISPLAY_NAME, PR_DISPLAY_NAME_A,
  PR_DISPLAY_NAME_PREFIX, PR_DISPLAY_NAME_PREFIX_A,
  PR_DISPLAY_NAME_PREFIX_W, PR_DISPLAY_NAME_W, PR_DISPLAY_TYPE,
  PR_EMAIL_ADDRESS, PR_EMAIL_ADDRESS_A, PR_EMAIL_ADDRESS_W, PR_ENTRYID,
  PR_FOLDER_ASSOCIATED_CONTENTS, PR_FOLDER_TYPE, PR_FTP_SITE,
  PR_FTP_SITE_A, PR_FTP_SITE_W, PR_GENDER, PR_GENERATION,
  PR_GENERATION_A, PR_GENERATION_W, PR_GIVEN_NAME, PR_GIVEN_NAME_A,
  PR_GIVEN_NAME_W, PR_GOVERNMENT_ID_NUMBER, PR_GOVERNMENT_ID_NUMBER_A,
  PR_GOVERNMENT_ID_NUMBER_W, PR_HOBBIES, PR_HOBBIES_A, PR_HOBBIES_W,
  PR_HOME2_TELEPHONE_NUMBER, PR_HOME2_TELEPHONE_NUMBER_A,
  PR_HOME2_TELEPHONE_NUMBER_W, PR_HOME_ADDRESS_CITY,
  PR_HOME_ADDRESS_CITY_A, PR_HOME_ADDRESS_CITY_W,
  PR_HOME_ADDRESS_COUNTRY, PR_HOME_ADDRESS_COUNTRY_A,
  PR_HOME_ADDRESS_COUNTRY_W, PR_HOME_ADDRESS_POSTAL_CODE,
  PR_HOME_ADDRESS_POSTAL_CODE_A, PR_HOME_ADDRESS_POSTAL_CODE_W,
  PR_HOME_ADDRESS_POST_OFFICE_BOX, PR_HOME_ADDRESS_POST_OFFICE_BOX_A,
  PR_HOME_ADDRESS_POST_OFFICE_BOX_W, PR_HOME_ADDRESS_STATE_OR_PROVINCE,
  PR_HOME_ADDRESS_STATE_OR_PROVINCE_A,
  PR_HOME_ADDRESS_STATE_OR_PROVINCE_W, PR_HOME_ADDRESS_STREET,
  PR_HOME_ADDRESS_STREET_A, PR_HOME_ADDRESS_STREET_W, PR_HOME_FAX_NUMBER,
  PR_HOME_FAX_NUMBER_A, PR_HOME_FAX_NUMBER_W, PR_HOME_TELEPHONE_NUMBER,
  PR_HOME_TELEPHONE_NUMBER_A, PR_HOME_TELEPHONE_NUMBER_W, PR_ICON,
  PR_INITIALS, PR_INITIALS_A, PR_INITIALS_W, PR_INSTANCE_KEY,
  PR_ISDN_NUMBER, PR_ISDN_NUMBER_A, PR_ISDN_NUMBER_W, PR_KEYWORD,
  PR_KEYWORD_A, PR_KEYWORD_W, PR_LANGUAGE, PR_LANGUAGE_A, PR_LANGUAGE_W,
  PR_LAST_MODIFICATION_TIME, PR_LOCALITY, PR_LOCALITY_A, PR_LOCALITY_W,
  PR_LOCATION, PR_LOCATION_A, PR_LOCATION_W, PR_MAIL_PERMISSION,
  PR_MANAGER_NAME, PR_MANAGER_NAME_A, PR_MANAGER_NAME_W,
  PR_MAPPING_SIGNATURE, PR_MHS_COMMON_NAME, PR_MHS_COMMON_NAME_A,
  PR_MHS_COMMON_NAME_W, PR_MIDDLE_NAME, PR_MIDDLE_NAME_A,
  PR_MIDDLE_NAME_W, PR_MINI_ICON, PR_MOBILE_TELEPHONE_NUMBER,
  PR_MOBILE_TELEPHONE_NUMBER_A, PR_MOBILE_TELEPHONE_NUMBER_W,
  PR_NICKNAME, PR_NICKNAME_A, PR_NICKNAME_W, PR_OBJECT_TYPE,
  PR_OFFICE2_TELEPHONE_NUMBER, PR_OFFICE2_TELEPHONE_NUMBER_A,
  PR_OFFICE2_TELEPHONE_NUMBER_W, PR_OFFICE_LOCATION,
  PR_OFFICE_LOCATION_A, PR_OFFICE_LOCATION_W, PR_OFFICE_TELEPHONE_NUMBER,
  PR_OFFICE_TELEPHONE_NUMBER_A, PR_OFFICE_TELEPHONE_NUMBER_W,
  PR_ORGANIZATIONAL_ID_NUMBER, PR_ORGANIZATIONAL_ID_NUMBER_A,
  PR_ORGANIZATIONAL_ID_NUMBER_W, PR_ORIGINAL_DISPLAY_NAME,
  PR_ORIGINAL_DISPLAY_NAME_A, PR_ORIGINAL_DISPLAY_NAME_W,
  PR_ORIGINAL_ENTRYID, PR_ORIGINAL_SEARCH_KEY, PR_OTHER_ADDRESS_CITY,
  PR_OTHER_ADDRESS_CITY_A, PR_OTHER_ADDRESS_CITY_W,
  PR_OTHER_ADDRESS_COUNTRY, PR_OTHER_ADDRESS_COUNTRY_A,
  PR_OTHER_ADDRESS_COUNTRY_W, PR_OTHER_ADDRESS_POSTAL_CODE,
  PR_OTHER_ADDRESS_POSTAL_CODE_A, PR_OTHER_ADDRESS_POSTAL_CODE_W,
  PR_OTHER_ADDRESS_POST_OFFICE_BOX, PR_OTHER_ADDRESS_POST_OFFICE_BOX_A,
  PR_OTHER_ADDRESS_POST_OFFICE_BOX_W, PR_OTHER_ADDRESS_STATE_OR_PROVINCE,
  PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A,
  PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W, PR_OTHER_ADDRESS_STREET,
  PR_OTHER_ADDRESS_STREET_A, PR_OTHER_ADDRESS_STREET_W,
  PR_OTHER_TELEPHONE_NUMBER, PR_OTHER_TELEPHONE_NUMBER_A,
  PR_OTHER_TELEPHONE_NUMBER_W, PR_PAGER_TELEPHONE_NUMBER,
  PR_PAGER_TELEPHONE_NUMBER_A, PR_PAGER_TELEPHONE_NUMBER_W,
  PR_PERSONAL_HOME_PAGE, PR_PERSONAL_HOME_PAGE_A,
  PR_PERSONAL_HOME_PAGE_W, PR_POSTAL_ADDRESS, PR_POSTAL_ADDRESS_A,
  PR_POSTAL_ADDRESS_W, PR_POSTAL_CODE, PR_POSTAL_CODE_A,
  PR_POSTAL_CODE_W, PR_POST_OFFICE_BOX, PR_POST_OFFICE_BOX_A,
  PR_POST_OFFICE_BOX_W, PR_PREFERRED_BY_NAME, PR_PREFERRED_BY_NAME_A,
  PR_PREFERRED_BY_NAME_W, PR_PRIMARY_CAPABILITY, PR_PRIMARY_FAX_NUMBER,
  PR_PRIMARY_FAX_NUMBER_A, PR_PRIMARY_FAX_NUMBER_W,
  PR_PRIMARY_TELEPHONE_NUMBER, PR_PRIMARY_TELEPHONE_NUMBER_A,
  PR_PRIMARY_TELEPHONE_NUMBER_W, PR_PROFESSION, PR_PROFESSION_A,
  PR_PROFESSION_W, PR_PROVIDER_DISPLAY, PR_PROVIDER_DISPLAY_A,
  PR_PROVIDER_DISPLAY_W, PR_PROVIDER_DLL_NAME, PR_PROVIDER_DLL_NAME_A,
  PR_PROVIDER_DLL_NAME_W, PR_PROVIDER_ORDINAL, PR_PROVIDER_UID,
  PR_RADIO_TELEPHONE_NUMBER, PR_RADIO_TELEPHONE_NUMBER_A,
  PR_RADIO_TELEPHONE_NUMBER_W, PR_RECIPIENT_TYPE, PR_RECORD_KEY,
  PR_RESOURCE_FLAGS, PR_ROWID, PR_ROW_TYPE, PR_SEARCH, PR_SEARCH_KEY,
  PR_SELECTABLE, PR_SEND_INTERNET_ENCODING, PR_SEND_RICH_INFO,
  PR_SPOUSE_NAME, PR_SPOUSE_NAME_A, PR_SPOUSE_NAME_W,
  PR_STATE_OR_PROVINCE, PR_STATE_OR_PROVINCE_A, PR_STATE_OR_PROVINCE_W,
  PR_STATUS, PR_STORE_ENTRYID, PR_STORE_RECORD_KEY, PR_STREET_ADDRESS,
  PR_STREET_ADDRESS_A, PR_STREET_ADDRESS_W, PR_SUBFOLDERS, PR_SURNAME,
  PR_SURNAME_A, PR_SURNAME_W, PR_TELEX_NUMBER, PR_TELEX_NUMBER_A,
  PR_TELEX_NUMBER_W, PR_TEMPLATEID, PR_TITLE, PR_TITLE_A, PR_TITLE_W,
  PR_TRANSMITABLE_DISPLAY_NAME, PR_TRANSMITABLE_DISPLAY_NAME_A,
  PR_TRANSMITABLE_DISPLAY_NAME_W, PR_TTYTDD_PHONE_NUMBER,
  PR_TTYTDD_PHONE_NUMBER_A, PR_TTYTDD_PHONE_NUMBER_W,
  PR_USER_CERTIFICATE, PR_USER_X509_CERTIFICATE, PR_WEDDING_ANNIVERSARY,
  };

  // generated with genprops spew
  static enum {
      MAPI_E_AMBIGUOUS_RECIP, MAPI_E_BAD_CHARWIDTH, MAPI_E_BAD_COLUMN,
  MAPI_E_BAD_VALUE, MAPI_E_BUSY, MAPI_E_CALL_FAILED, MAPI_E_COLLISION,
  MAPI_E_COMPUTED, MAPI_E_CORRUPT_DATA, MAPI_E_DECLINE_COPY,
  MAPI_E_DISK_ERROR, MAPI_E_END_OF_SESSION, MAPI_E_EXTENDED_ERROR,
  MAPI_E_FAILONEPROVIDER, MAPI_E_FOLDER_CYCLE,
  MAPI_E_INTERFACE_NOT_SUPPORTED, MAPI_E_INVALID_BOOKMARK,
  MAPI_E_INVALID_ENTRYID, MAPI_E_INVALID_OBJECT,
  MAPI_E_INVALID_PARAMETER, MAPI_E_INVALID_TYPE, MAPI_E_LOGON_FAILED,
  MAPI_E_MISSING_REQUIRED_COLUMN, MAPI_E_NETWORK_ERROR,
  MAPI_E_NOT_ENOUGH_DISK, MAPI_E_NOT_ENOUGH_MEMORY,
  MAPI_E_NOT_ENOUGH_RESOURCES, MAPI_E_NOT_FOUND, MAPI_E_NOT_INITIALIZED,
  MAPI_E_NO_ACCESS, MAPI_E_NO_SUPPORT, MAPI_E_OBJECT_CHANGED,
  MAPI_E_OBJECT_DELETED, MAPI_E_SESSION_LIMIT, MAPI_E_STRING_TOO_LONG,
  MAPI_E_TABLE_EMPTY, MAPI_E_TABLE_TOO_BIG, MAPI_E_TIMEOUT,
  MAPI_E_TOO_BIG, MAPI_E_TOO_COMPLEX, MAPI_E_TYPE_NO_SUPPORT,
  MAPI_E_UNABLE_TO_ABORT, MAPI_E_UNABLE_TO_COMPLETE, MAPI_E_UNCONFIGURED,
  MAPI_E_UNEXPECTED_ID, MAPI_E_UNEXPECTED_TYPE, MAPI_E_UNKNOWN_ENTRYID,
  MAPI_E_UNKNOWN_FLAGS, MAPI_E_USER_CANCEL, MAPI_E_VERSION,
  MAPI_W_APPROX_COUNT, MAPI_W_ERRORS_RETURNED, MAPI_W_NO_SERVICE,
  MAPI_W_PARTIAL_COMPLETION, MAPI_W_POSITION_CHANGED,
  };

};
#endif

#ifdef SWIG
%newobject Initialize;
#endif
wabmodule* Initialize(bool enableprofiles=true, const char *INPUT=NULL);


extern char *errorstring;
extern unsigned long errorcode;

