/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_INVESTIGATOR_H__
#define __BKL_INVESTIGATOR_H__

#include <glib.h>

G_BEGIN_DECLS

typedef struct _BklInvestigator BklInvestigator;

void bkl_investigator_add_uris (const char  *source,
                                const char **uris,
                                int          n_uris);
void bkl_investigator_shutdown (void);
void _bkl_investigator_cancel_source (const char *source);
void _bkl_investigator_cancel_uris (const char **uris);

G_END_DECLS

#endif
