/*
 * Copyright (c) 2005 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef BMEMCOREVERSE_H
#define BMEMCOREVERSE_H
class QDomElement;
class QDomDocument;
#include <qstring.h>
#include <qstringlist.h>
//class QString;
//class std::list;
#include "versewatcher.h"
#include "ubook.h"
#include <list>

namespace bmemcore
{
class BiblePlugin;


class CorrectionWord
{
public:
    enum WordState
    {
        WORD_STATE_CORRECT,
        WORD_STATE_MISSING,
        WORD_STATE_WRONG
    };
    QString word;
    WordState state;
    CorrectionWord(QString pWord, WordState pState)
    {
        word = pWord;
        state = pState;
    }
};

/**
@author Jeremy Erickson
*/
class Verse
{
public:
    /** Creates an empty verse.
      */
    Verse();
    Verse(const QDomElement&);
    void parseElement(const QDomElement&);
    QDomElement generateElement(QDomDocument* doc = 0) const;
    void setBookInfo(const QString&, BiblePlugin&);
    void setBookInfo(const uBookType, BiblePlugin&);
    void setBookInfo(const QString&, const uBookType);
    void setBook(const QString&);
    QString getBook() const;
    void setUBook(const uBookType);
    uBookType getUBook() const;
    void setChapter(const QString&);
    QString getChapter() const;
    void setVerses(const QString&);
    QString getVerses() const;
    void setTranslation(const QString&);
    QString getTranslation() const;
    void setText(const QString&);
    QString getText() const;
    void setCategories(const QStringList&);
    QStringList getCategories() const;
    void addCategory(const QString& newCategory);
    bool removeCategory(const QString& oldCategory);
    bool replaceCategory(const QString& oldCategory,
            const QString& newCategory);
    bool containsCategory(const QString&) const;
    QString getReference() const;
    void addWatcher(VerseWatcher*);
    void removeWatcher(VerseWatcher*);
    void notifyKilled();
    void setText(BiblePlugin&);
    bool isTextAvailable(BiblePlugin&);
    bool checkText(const QString& text);
    std::list<CorrectionWord> correctText(const QString& text);
    int compareTo(const Verse& other) const;

    ~Verse();
protected:
    QString mBook;
    uBookType mUBook;
    QString mChapter;
    QString mVerses;
    QString mTranslation;
    QString mText;
    QStringList mCategories;
    std::list<VerseWatcher*> mWatchers;
    void notifyWatchers(VerseWatcher::ChangeType);
    QString getNodeText(QDomElement&);
    QStringList tokenize(const QString& text);
private:
    //Intentionally not implemented - Verse objects are noncopyable
    explicit Verse(const Verse&);
    Verse& operator= (const Verse&);
};

}

#endif
