/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogdate.h"
#include "date_time_utils.h"
#include "help.h"


DateDialog::DateDialog (guint32 * julian_day)
{
  // Store variabeles.
  my_julian_day = julian_day;
  
  datedialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (datedialog), "Date");
  gtk_window_set_position (GTK_WINDOW (datedialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_type_hint (GTK_WINDOW (datedialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (datedialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  calendar1 = gtk_calendar_new ();
  gtk_widget_show (calendar1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), calendar1, TRUE, TRUE, 0);
  gtk_calendar_display_options (GTK_CALENDAR (calendar1),
                                GtkCalendarDisplayOptions (GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES | GTK_CALENDAR_SHOW_WEEK_NUMBERS));

  // Set the date.
  guint year, month, day;
  date_time_normal_get_year_month_day (* julian_day, year, month, day);
  gtk_calendar_select_month (GTK_CALENDAR (calendar1), month - 1, year);
  gtk_calendar_select_day (GTK_CALENDAR (calendar1), day);
  
  dialog_action_area1 = GTK_DIALOG (datedialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  help_button (dialog_action_area1, NULL, NULL);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (datedialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (datedialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) okbutton1, "clicked", G_CALLBACK (on_okbutton_clicked), gpointer(this));

  gtk_widget_grab_default (okbutton1);
}


DateDialog::~DateDialog ()
{
  gtk_widget_destroy (datedialog);
}


int DateDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (datedialog));
}


void DateDialog::on_okbutton_clicked (GtkButton * button, gpointer user_data)
{
  ((DateDialog *) user_data)->on_okbutton ();
}


void DateDialog::on_okbutton ()
{
  guint year;
  guint month;
  guint day;
  gtk_calendar_get_date (GTK_CALENDAR (calendar1), &year, &month, &day);
  month++;
  * my_julian_day = date_time_julian_day_get_parse (year, month, day);
}
