/*  beef - Flexible Brainfuck interpreter
 *  Copyright (C) 2005-2007  KiyuKo <eof AT kiyuko DOT org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Homepage: http://www.kiyuko.org/beef
 */

#ifndef BEEF_H
#define BEEF_H

/* Include needed headers */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

/* Program name and version */
#define PROGRAM_NAME "beef"
#define VERSION "0.0.6"

/* Some useful symbols */
#define STORE_ZERO '0'
#define STORE_EOF 'e'
#define DO_NOTHING 'n'

#define TRUE '1'
#define FALSE '0'

#define ON '1'
#define OFF '0'

/* This struct defines an istruction */
struct instruction {
  char type;
  long quantity;
  struct instruction *loop;
  struct instruction *next;
};

/* This struct defines a cell of the tape */
struct tape_cell {
  char content;
  struct tape_cell *previous;
  struct tape_cell *next;
};

/* The tape itself (just a pointer to the current cell) */
struct tape_cell *tape;

/* The code (a pointer to the current instruction) */
struct instruction *code;

/* Various functions */
struct tape_cell *new_cell ();
struct instruction *load (FILE *fp, char debug);
void eval (struct instruction *code, char on_eof);
void tape_dump ();
void code_dump (struct instruction *code, long indent);

#endif
