/* na-prefs.c generated by valac, the Vala compiler
 * generated from na-prefs.vala, do not modify */

/*
 * Copyright (C) 2009 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/config.h>
#include <libawn/libawn.h>
#include <gtk/gtk.h>
#include <libdesktop-agnostic/ui.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <config.h>
#include <float.h>
#include <math.h>


#define TYPE_NOTIFICATION_AREA_PREFS (notification_area_prefs_get_type ())
#define NOTIFICATION_AREA_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefs))
#define NOTIFICATION_AREA_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefsClass))
#define IS_NOTIFICATION_AREA_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_AREA_PREFS))
#define IS_NOTIFICATION_AREA_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_AREA_PREFS))
#define NOTIFICATION_AREA_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefsClass))

typedef struct _NotificationAreaPrefs NotificationAreaPrefs;
typedef struct _NotificationAreaPrefsClass NotificationAreaPrefsClass;
typedef struct _NotificationAreaPrefsPrivate NotificationAreaPrefsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NotificationAreaPrefs {
	GObject parent_instance;
	NotificationAreaPrefsPrivate * priv;
};

struct _NotificationAreaPrefsClass {
	GObjectClass parent_class;
};

struct _NotificationAreaPrefsPrivate {
	DesktopAgnosticConfigClient* client;
	AwnApplet* applet;
	GtkDialog* dialog;
	GtkSpinButton* icons_per_cell_spin;
	GtkRange* icon_size_range;
	GtkSpinButton* extra_offset_spin;
	GtkRadioButton* auto_backround_radio;
	GtkRadioButton* custom_background_radio;
	DesktopAgnosticUIColorButton* background_color_button;
	GtkRadioButton* auto_border_radio;
	GtkRadioButton* custom_border_radio;
	DesktopAgnosticUIColorButton* border_color_button;
	DesktopAgnosticColor* _background_color;
	DesktopAgnosticColor* _border_color;
};


static gpointer notification_area_prefs_parent_class = NULL;

#define APPLET_NAME "notification-area"
GType notification_area_prefs_get_type (void);
#define NOTIFICATION_AREA_PREFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefsPrivate))
enum  {
	NOTIFICATION_AREA_PREFS_DUMMY_PROPERTY,
	NOTIFICATION_AREA_PREFS_ICONS_PER_CELL,
	NOTIFICATION_AREA_PREFS_ICON_SIZE,
	NOTIFICATION_AREA_PREFS_EXTRA_OFFSET,
	NOTIFICATION_AREA_PREFS_BACKGROUND_COLOR,
	NOTIFICATION_AREA_PREFS_BORDER_COLOR
};
static void notification_area_prefs_init_components (NotificationAreaPrefs* self, GtkBuilder* builder);
NotificationAreaPrefs* notification_area_prefs_new (AwnApplet* applet);
NotificationAreaPrefs* notification_area_prefs_construct (GType object_type, AwnApplet* applet);
void notification_area_prefs_set_icons_per_cell (NotificationAreaPrefs* self, gint value);
static void _lambda0_ (GtkSpinButton* obj, NotificationAreaPrefs* self);
static void __lambda0__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
void notification_area_prefs_set_extra_offset (NotificationAreaPrefs* self, gint value);
static void _lambda1_ (GtkSpinButton* obj, NotificationAreaPrefs* self);
static void __lambda1__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
void notification_area_prefs_set_icon_size (NotificationAreaPrefs* self, gint value);
static void _lambda2_ (GtkRange* obj, NotificationAreaPrefs* self);
static void __lambda2__gtk_range_value_changed (GtkRange* _sender, gpointer self);
void notification_area_prefs_set_background_color (NotificationAreaPrefs* self, DesktopAgnosticColor* value);
static void _lambda3_ (GtkToggleButton* obj, NotificationAreaPrefs* self);
static void __lambda3__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda4_ (GtkToggleButton* obj, NotificationAreaPrefs* self);
static void __lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda5_ (GtkColorButton* obj, NotificationAreaPrefs* self);
static void __lambda5__gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
void notification_area_prefs_set_border_color (NotificationAreaPrefs* self, DesktopAgnosticColor* value);
static void _lambda6_ (GtkToggleButton* obj, NotificationAreaPrefs* self);
static void __lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda7_ (GtkToggleButton* obj, NotificationAreaPrefs* self);
static void __lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda8_ (GtkColorButton* obj, NotificationAreaPrefs* self);
static void __lambda8__gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
GtkDialog* notification_area_prefs_get_dialog (NotificationAreaPrefs* self);
gint notification_area_prefs_get_icons_per_cell (NotificationAreaPrefs* self);
gint notification_area_prefs_get_icon_size (NotificationAreaPrefs* self);
gint notification_area_prefs_get_extra_offset (NotificationAreaPrefs* self);
DesktopAgnosticColor* notification_area_prefs_get_background_color (NotificationAreaPrefs* self);
DesktopAgnosticColor* notification_area_prefs_get_border_color (NotificationAreaPrefs* self);
static void notification_area_prefs_finalize (GObject* obj);
static void notification_area_prefs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void notification_area_prefs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NotificationAreaPrefs* notification_area_prefs_construct (GType object_type, AwnApplet* applet) {
	GError * _inner_error_;
	NotificationAreaPrefs * self;
	AwnApplet* _tmp0_;
	char* ui_path;
	GtkBuilder* builder;
	DesktopAgnosticConfigClient* _tmp1_;
	DesktopAgnosticConfigClient* _tmp2_;
	g_return_val_if_fail (applet != NULL, NULL);
	_inner_error_ = NULL;
	self = (NotificationAreaPrefs*) g_object_new (object_type, NULL);
	self->priv->applet = (_tmp0_ = _g_object_ref0 (applet), _g_object_unref0 (self->priv->applet), _tmp0_);
	ui_path = g_build_filename (APPLETSDIR, APPLET_NAME, "na-prefs.ui", NULL);
	builder = gtk_builder_new ();
	gtk_builder_add_from_file (builder, ui_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	notification_area_prefs_init_components (self, builder);
	_tmp1_ = awn_config_get_default_for_applet (applet, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->client = (_tmp2_ = _g_object_ref0 (_tmp1_), _g_object_unref0 (self->priv->client), _tmp2_);
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "icons_per_cell", (GObject*) self, "icons-per-cell", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "icon_size", (GObject*) self, "icon-size", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "extra_offset", (GObject*) self, "extra-offset", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "background_color", (GObject*) self, "background-color", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "border_color", (GObject*) self, "border-color", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (ui_path);
	_g_object_unref0 (builder);
	return self;
}


NotificationAreaPrefs* notification_area_prefs_new (AwnApplet* applet) {
	return notification_area_prefs_construct (TYPE_NOTIFICATION_AREA_PREFS, applet);
}


static void _lambda0_ (GtkSpinButton* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	notification_area_prefs_set_icons_per_cell (self, gtk_spin_button_get_value_as_int (obj));
}


static void __lambda0__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (GtkSpinButton* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	notification_area_prefs_set_extra_offset (self, gtk_spin_button_get_value_as_int (obj));
}


static void __lambda1__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GtkRange* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	notification_area_prefs_set_icon_size (self, (gint) gtk_range_get_value (obj));
}


static void __lambda2__gtk_range_value_changed (GtkRange* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static void _lambda3_ (GtkToggleButton* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	if (gtk_toggle_button_get_active (obj)) {
		notification_area_prefs_set_background_color (self, NULL);
	}
}


static void __lambda3__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (GtkToggleButton* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	if (gtk_toggle_button_get_active (obj)) {
		notification_area_prefs_set_background_color (self, desktop_agnostic_ui_color_button_get_da_color (self->priv->background_color_button));
	}
}


static void __lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _lambda5_ (GtkColorButton* obj, NotificationAreaPrefs* self) {
	GtkColorButton* _tmp0_;
	DesktopAgnosticUIColorButton* button;
	g_return_if_fail (obj != NULL);
	button = _g_object_ref0 ((_tmp0_ = obj, DESKTOP_AGNOSTIC_UI_IS_COLOR_BUTTON (_tmp0_) ? ((DesktopAgnosticUIColorButton*) _tmp0_) : NULL));
	notification_area_prefs_set_background_color (self, desktop_agnostic_ui_color_button_get_da_color (button));
	_g_object_unref0 (button);
}


static void __lambda5__gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (GtkToggleButton* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	if (gtk_toggle_button_get_active (obj)) {
		notification_area_prefs_set_border_color (self, NULL);
	}
}


static void __lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (GtkToggleButton* obj, NotificationAreaPrefs* self) {
	g_return_if_fail (obj != NULL);
	if (gtk_toggle_button_get_active (obj)) {
		notification_area_prefs_set_border_color (self, desktop_agnostic_ui_color_button_get_da_color (self->priv->border_color_button));
	}
}


static void __lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static void _lambda8_ (GtkColorButton* obj, NotificationAreaPrefs* self) {
	GtkColorButton* _tmp0_;
	DesktopAgnosticUIColorButton* button;
	g_return_if_fail (obj != NULL);
	button = _g_object_ref0 ((_tmp0_ = obj, DESKTOP_AGNOSTIC_UI_IS_COLOR_BUTTON (_tmp0_) ? ((DesktopAgnosticUIColorButton*) _tmp0_) : NULL));
	notification_area_prefs_set_border_color (self, desktop_agnostic_ui_color_button_get_da_color (button));
	_g_object_unref0 (button);
}


static void __lambda8__gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


static void notification_area_prefs_init_components (NotificationAreaPrefs* self, GtkBuilder* builder) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	self->priv->dialog = (_tmp0_ = _g_object_ref0 (GTK_DIALOG (gtk_builder_get_object (builder, "dialog1"))), _g_object_unref0 (self->priv->dialog), _tmp0_);
	self->priv->icons_per_cell_spin = GTK_SPIN_BUTTON (gtk_builder_get_object (builder, "iconRowsSpinbutton"));
	g_signal_connect_object (self->priv->icons_per_cell_spin, "value-changed", (GCallback) __lambda0__gtk_spin_button_value_changed, self, 0);
	self->priv->extra_offset_spin = GTK_SPIN_BUTTON (gtk_builder_get_object (builder, "offsetSpinbutton"));
	g_signal_connect_object (self->priv->extra_offset_spin, "value-changed", (GCallback) __lambda1__gtk_spin_button_value_changed, self, 0);
	self->priv->icon_size_range = GTK_RANGE (gtk_builder_get_object (builder, "sizeScale"));
	g_signal_connect_object (self->priv->icon_size_range, "value-changed", (GCallback) __lambda2__gtk_range_value_changed, self, 0);
	self->priv->auto_backround_radio = GTK_RADIO_BUTTON (gtk_builder_get_object (builder, "autoBackgroundRadio"));
	g_signal_connect_object ((GtkToggleButton*) self->priv->auto_backround_radio, "toggled", (GCallback) __lambda3__gtk_toggle_button_toggled, self, 0);
	self->priv->custom_background_radio = GTK_RADIO_BUTTON (gtk_builder_get_object (builder, "customBackgroundRadio"));
	g_signal_connect_object ((GtkToggleButton*) self->priv->custom_background_radio, "toggled", (GCallback) __lambda4__gtk_toggle_button_toggled, self, 0);
	self->priv->background_color_button = DESKTOP_AGNOSTIC_UI_COLOR_BUTTON (gtk_builder_get_object (builder, "backgroundColorbutton"));
	g_signal_connect_object ((GtkColorButton*) self->priv->background_color_button, "color-set", (GCallback) __lambda5__gtk_color_button_color_set, self, 0);
	self->priv->auto_border_radio = GTK_RADIO_BUTTON (gtk_builder_get_object (builder, "autoBorderRadio"));
	g_signal_connect_object ((GtkToggleButton*) self->priv->auto_border_radio, "toggled", (GCallback) __lambda6__gtk_toggle_button_toggled, self, 0);
	self->priv->custom_border_radio = GTK_RADIO_BUTTON (gtk_builder_get_object (builder, "customBorderRadio"));
	g_signal_connect_object ((GtkToggleButton*) self->priv->custom_border_radio, "toggled", (GCallback) __lambda7__gtk_toggle_button_toggled, self, 0);
	self->priv->border_color_button = DESKTOP_AGNOSTIC_UI_COLOR_BUTTON (gtk_builder_get_object (builder, "borderColorbutton"));
	g_signal_connect_object ((GtkColorButton*) self->priv->border_color_button, "color-set", (GCallback) __lambda8__gtk_color_button_color_set, self, 0);
}


GtkDialog* notification_area_prefs_get_dialog (NotificationAreaPrefs* self) {
	GtkDialog* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->dialog;
	return result;
}


gint notification_area_prefs_get_icons_per_cell (NotificationAreaPrefs* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = gtk_spin_button_get_value_as_int (self->priv->icons_per_cell_spin);
	return result;
}


void notification_area_prefs_set_icons_per_cell (NotificationAreaPrefs* self, gint value) {
	g_return_if_fail (self != NULL);
	if (gtk_spin_button_get_value_as_int (self->priv->icons_per_cell_spin) != value) {
		gtk_spin_button_set_value (self->priv->icons_per_cell_spin, (double) value);
	}
	g_object_notify ((GObject *) self, "icons-per-cell");
}


gint notification_area_prefs_get_icon_size (NotificationAreaPrefs* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) gtk_range_get_value (self->priv->icon_size_range);
	return result;
}


void notification_area_prefs_set_icon_size (NotificationAreaPrefs* self, gint value) {
	g_return_if_fail (self != NULL);
	if (((gint) gtk_range_get_value (self->priv->icon_size_range)) != value) {
		gtk_range_set_value (self->priv->icon_size_range, (double) value);
	}
	g_object_notify ((GObject *) self, "icon-size");
}


gint notification_area_prefs_get_extra_offset (NotificationAreaPrefs* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = gtk_spin_button_get_value_as_int (self->priv->extra_offset_spin);
	return result;
}


void notification_area_prefs_set_extra_offset (NotificationAreaPrefs* self, gint value) {
	g_return_if_fail (self != NULL);
	if (gtk_spin_button_get_value_as_int (self->priv->extra_offset_spin) != value) {
		gtk_spin_button_set_value (self->priv->extra_offset_spin, (double) value);
	}
	g_object_notify ((GObject *) self, "extra-offset");
}


DesktopAgnosticColor* notification_area_prefs_get_background_color (NotificationAreaPrefs* self) {
	DesktopAgnosticColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_background_color;
	return result;
}


void notification_area_prefs_set_background_color (NotificationAreaPrefs* self, DesktopAgnosticColor* value) {
	DesktopAgnosticColor* _tmp3_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->auto_backround_radio, TRUE);
	} else {
		gboolean _tmp0_ = FALSE;
		if (self->priv->_background_color == NULL) {
			_tmp0_ = TRUE;
		} else {
			char* _tmp2_;
			char* _tmp1_;
			_tmp0_ = _vala_strcmp0 (_tmp1_ = desktop_agnostic_color_to_string (self->priv->_background_color), _tmp2_ = desktop_agnostic_color_to_string (value)) != 0;
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
		}
		if (_tmp0_) {
			gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->custom_background_radio, TRUE);
			desktop_agnostic_ui_color_button_set_da_color (self->priv->background_color_button, value);
		}
	}
	self->priv->_background_color = (_tmp3_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_background_color), _tmp3_);
	g_object_notify ((GObject *) self, "background-color");
}


DesktopAgnosticColor* notification_area_prefs_get_border_color (NotificationAreaPrefs* self) {
	DesktopAgnosticColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_border_color;
	return result;
}


void notification_area_prefs_set_border_color (NotificationAreaPrefs* self, DesktopAgnosticColor* value) {
	DesktopAgnosticColor* _tmp3_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->auto_border_radio, TRUE);
	} else {
		gboolean _tmp0_ = FALSE;
		if (self->priv->_border_color == NULL) {
			_tmp0_ = TRUE;
		} else {
			char* _tmp2_;
			char* _tmp1_;
			_tmp0_ = _vala_strcmp0 (_tmp1_ = desktop_agnostic_color_to_string (self->priv->_border_color), _tmp2_ = desktop_agnostic_color_to_string (value)) != 0;
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
		}
		if (_tmp0_) {
			gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->custom_border_radio, TRUE);
			desktop_agnostic_ui_color_button_set_da_color (self->priv->border_color_button, value);
		}
	}
	self->priv->_border_color = (_tmp3_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_border_color), _tmp3_);
	g_object_notify ((GObject *) self, "border-color");
}


static void notification_area_prefs_class_init (NotificationAreaPrefsClass * klass) {
	notification_area_prefs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NotificationAreaPrefsPrivate));
	G_OBJECT_CLASS (klass)->get_property = notification_area_prefs_get_property;
	G_OBJECT_CLASS (klass)->set_property = notification_area_prefs_set_property;
	G_OBJECT_CLASS (klass)->finalize = notification_area_prefs_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_PREFS_ICONS_PER_CELL, g_param_spec_int ("icons-per-cell", "icons-per-cell", "icons-per-cell", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_PREFS_ICON_SIZE, g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_PREFS_EXTRA_OFFSET, g_param_spec_int ("extra-offset", "extra-offset", "extra-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_PREFS_BACKGROUND_COLOR, g_param_spec_object ("background-color", "background-color", "background-color", DESKTOP_AGNOSTIC_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_PREFS_BORDER_COLOR, g_param_spec_object ("border-color", "border-color", "border-color", DESKTOP_AGNOSTIC_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void notification_area_prefs_instance_init (NotificationAreaPrefs * self) {
	self->priv = NOTIFICATION_AREA_PREFS_GET_PRIVATE (self);
}


static void notification_area_prefs_finalize (GObject* obj) {
	NotificationAreaPrefs * self;
	GError * _inner_error_;
	self = NOTIFICATION_AREA_PREFS (obj);
	_inner_error_ = NULL;
	{
		desktop_agnostic_config_client_unbind_all_for_object (self->priv->client, (GObject*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->applet);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->_background_color);
	_g_object_unref0 (self->priv->_border_color);
	G_OBJECT_CLASS (notification_area_prefs_parent_class)->finalize (obj);
}


GType notification_area_prefs_get_type (void) {
	static volatile gsize notification_area_prefs_type_id__volatile = 0;
	if (g_once_init_enter (&notification_area_prefs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotificationAreaPrefsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notification_area_prefs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationAreaPrefs), 0, (GInstanceInitFunc) notification_area_prefs_instance_init, NULL };
		GType notification_area_prefs_type_id;
		notification_area_prefs_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationAreaPrefs", &g_define_type_info, 0);
		g_once_init_leave (&notification_area_prefs_type_id__volatile, notification_area_prefs_type_id);
	}
	return notification_area_prefs_type_id__volatile;
}


static void notification_area_prefs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NotificationAreaPrefs * self;
	self = NOTIFICATION_AREA_PREFS (object);
	switch (property_id) {
		case NOTIFICATION_AREA_PREFS_ICONS_PER_CELL:
		g_value_set_int (value, notification_area_prefs_get_icons_per_cell (self));
		break;
		case NOTIFICATION_AREA_PREFS_ICON_SIZE:
		g_value_set_int (value, notification_area_prefs_get_icon_size (self));
		break;
		case NOTIFICATION_AREA_PREFS_EXTRA_OFFSET:
		g_value_set_int (value, notification_area_prefs_get_extra_offset (self));
		break;
		case NOTIFICATION_AREA_PREFS_BACKGROUND_COLOR:
		g_value_set_object (value, notification_area_prefs_get_background_color (self));
		break;
		case NOTIFICATION_AREA_PREFS_BORDER_COLOR:
		g_value_set_object (value, notification_area_prefs_get_border_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void notification_area_prefs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NotificationAreaPrefs * self;
	self = NOTIFICATION_AREA_PREFS (object);
	switch (property_id) {
		case NOTIFICATION_AREA_PREFS_ICONS_PER_CELL:
		notification_area_prefs_set_icons_per_cell (self, g_value_get_int (value));
		break;
		case NOTIFICATION_AREA_PREFS_ICON_SIZE:
		notification_area_prefs_set_icon_size (self, g_value_get_int (value));
		break;
		case NOTIFICATION_AREA_PREFS_EXTRA_OFFSET:
		notification_area_prefs_set_extra_offset (self, g_value_get_int (value));
		break;
		case NOTIFICATION_AREA_PREFS_BACKGROUND_COLOR:
		notification_area_prefs_set_background_color (self, g_value_get_object (value));
		break;
		case NOTIFICATION_AREA_PREFS_BORDER_COLOR:
		notification_area_prefs_set_border_color (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




