import sys
# -*- coding:utf-8 -*-

import atheist


class DocTest(atheist.Task):

    allows = ['cwd', 'delay', 'desc', 'must_fail', 'template', 'tid']

    def __init__(self, module, **kargs):
        self.module = module
        self.check = True

        atheist.Task.__init__(self, **kargs)


    def exec_task(self):
        self.log.debug("runing doctest")
        import doctest

        if self.cwd:
            sys.path.append(self.cwd)

        try:
            module = __import__(self.module, fromlist=self.module.split('.')[-1])
            self.log.debug("%s" % module)
            self.result = (doctest.testmod(module)[0] == 0)
            del module

        except ImportError, e:
            atheist.Log.warning(e)
            self.result = atheist.ERROR

        del doctest
