// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __puma_version_h__
#define __puma_version_h__

/** \file
 *  Library version information. */

/** Library major version number. */
#define PUMA_MAJOR_VERSION        1
/** Library minor version number. */
#define PUMA_MINOR_VERSION        3

#define __PUMA_STR(arg) #arg
#define __PUMA_VERSION(major,minor) __PUMA_STR(major) "." __PUMA_STR(minor)

/** Library version string. */
#define PUMA_VERSION __PUMA_VERSION(PUMA_MAJOR_VERSION,PUMA_MINOR_VERSION)

namespace Puma {

/** Get the library version string. */
static inline const char *puma_version () { return PUMA_VERSION; }

} // namespace Puma

#endif

/** \mainpage notitle
 *
 *  <br><h1>%Puma Library Reference Manual</h1>
 *  
 *  \section About
 *  
 *  This is the class documentation of the %Puma library. %Puma is an extensible 
 *  C/C++ parser and code transformation library written in C++. It provides the 
 *  following key features:
 *  
 *  <ul>
 *    <li>Built-in C preprocessor with separate preprocessor syntax tree (Puma::PreTree)</li>
 *    <li>Lexical analysis of C and C++ source code providing separate token chains (Puma::Unit)</li>
 *    <li>Syntactic analysis of token chains providing separate syntax trees (Puma::CTree)</li>
 *    <li>Semantic analysis of syntax trees providing separate semantic information databases (Puma::CSemDatabase)</li>
 *    <li>Source code transformation on token and syntax tree level (Puma::ManipCommander)</li>
 *    <li>ISO/IEC 9899-1999(E) - C conformance</li>
 *    <li>ISO/IEC 14882:1998(E) - C++ conformance</li>
 *  </ul>
 *
 *  \section License
 * 
 *  %Puma is free software; you can redistribute it and/or modify it under the
 *  terms of the GNU General Public License as published by the Free Software
 *  Foundation; either version 2 of the License, or (at your option) any later
 *  version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 *  \section GettingPuma Getting Puma
 *
 *  The source code of the %Puma library is available together with the AspectC++
 *  source package from the <a href="http://www.aspectc.org/" target="_parent">
 *  AspectC++ Homepage</a>, or via SVN with the following command:
 *
 *  \code svn checkout https://svn.aspectc.org/repos/Puma/trunk Puma \endcode
 */
