// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

/* $Id: JoinPoint.h,v 1.10 2004/04/19 10:13:57 matthias.urban Exp $ */

#ifndef __JoinPoint_h__
#define __JoinPoint_h__

#include <iostream>
using namespace std;

#include "Puma/ListElement.h"
#include "JoinPointLoc.h"
#include "Condition.h"
using namespace Puma;

class JoinPoint : public ListElement {
  JoinPointLoc* _location;
  Condition _cond;
public:
  typedef JoinPointLoc::join_point_type join_point_type;

  JoinPoint (JoinPointLoc *location, Condition &cond) : _location (location) {
    _cond.assign (cond);
  }
  
  join_point_type type() const { return location()->type (); }
  JoinPointLoc* location() const { return _location; }
  const Condition &condition () const { return _cond; }
  const char* signature() { return location ()->signature (); }
  
  virtual ListElement* duplicate();
  
  friend ostream& operator<< (ostream&, JoinPoint&);
};

#endif
