// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __IntroductionInfo_h__
#define __IntroductionInfo_h__

#include <iostream>
using namespace std;

#include "PointCut.h"
#include "JoinPointLoc.h"
#include "BackEndProblems.h"
#include "PointCutEvaluator.h"
#include "PointCutContext.h"
#include "JoinPointModel.h"
#include "TransformInfo.h"
using namespace Puma;

class IntroductionInfo {
 
  JPL_Aspect &_aspect;
  PointCut _pointcut;
  JPL_Introduction &_intro;
  PointCutExpr *_pce;

public:
  IntroductionInfo (JPL_Aspect &a, JPL_Introduction &i) :
    _aspect (a), _intro (i), _pce (0) {}
  ~IntroductionInfo () {
    if (_pce) PointCutEvaluator::destroy (_pce);
  }
  JPL_Aspect &aspect () const { return _aspect; }
  PointCut &pointcut () { return _pointcut; }
  JPL_Introduction &intro () const { return _intro; }
  PointCutExpr *expr () const { return _pce; }
  void analyze_expr (ErrorStream &err, JoinPointModel &jpm) {
    PointCutContext context (jpm);
    PointCutEvaluator eval (err, context);
    context.concrete_aspect (_aspect);
    _pce = eval.create (_intro.expr (), JoinPointLoc::Name);
  }
};

#endif // __IntroductionInfo_h__
