// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_info__
#define __path_info__

// A path information object consists of a source and optionally
// a destination path.

namespace Puma {


class PathInfo {
  const char *_src;        // Source path.
  const char *_dest;        // Destination path.
        
public:
  PathInfo () : _src ((const char*) 0), _dest ((const char*) 0) {}
  PathInfo (const PathInfo &);
  ~PathInfo ();
        
  // Needed for class Array.
  PathInfo &operator =(const PathInfo &);

  // Set or get the source path.
  void src (const char *);
  const char *src () const { return _src; }
        
  // Set or get the destination path.
  void dest (const char *);
  const char *dest () const { return _dest; }
};


} // namespace Puma

#endif /* __path_info__ */
