------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--  A S I S _ U L . E N V I R O N M E N T . S C A N _ P A R A M E T E R S   --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2004-2007, AdaCore                      --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This is a placeholder for the routine that scans tool parameters. It
--  can process only the following options:
--    -v            - Verbose mnode
--    -d            - Debug mnode
--    -dd           - Progress Indicattor mode
--    -q            - Quiet mode
--    -I<path>      - compiler -I option (obsolete)
--    -gnatec<file> - compiler -gnatec option (obsolete)
--    --RTS=<path>  - compiler --RTS option (obsolete)
--    -cargs        - '-cards' section containing the valid compiler options

with GNAT.Command_Line;        use GNAT.Command_Line;

with ASIS_UL.Compiler_Options;
with ASIS_UL.Options;          use ASIS_UL.Options;

--  8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--
--  This is needed for multiple files driver only
with ASIS_UL.Source_Table;     use ASIS_UL.Source_Table;
-- >8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8--

separate (ASIS_UL.Environment)
procedure Scan_Parameters is
   No_More_Args : Boolean := True;
begin

   loop
      case GNAT.Command_Line.Getopt
        ("v d dd q I: gnatec! -RTS=")
      is

         when ASCII.NUL =>
            exit;

         when 'v' =>
            Verbose_Mode := True;

         when 'q' =>
            Quiet_Mode := True;

         when 'd' =>
            if Full_Switch = "d" then
               Debug_Mode := True;
            elsif Full_Switch = "dd" then
               Progress_Indicator_Mode := True;
            end if;

         when 'I' | 'g' | '-' =>

            if Full_Switch = "I" then
               Store_I_Option (Parameter);
            elsif Full_Switch = "gnatec" then
               Store_GNAT_Option_With_Path (Full_Switch, Parameter);
            elsif  Full_Switch = "-RTS" then
               Store_Option ("--RTS=" & Parameter);
            end if;

         when others =>
            raise Parameter_Error;
      end case;
   end loop;

   --  --8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<
   --  Should be used if the tool has exactly one source file as
   --  its argument
   ASIS_UL.Common.Arg_File := new String'(Get_Argument);
   --  -->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8

   --  --8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<
   --  Should be used if the tool may have more then one source file as
   --  its argument
   loop
      Add_Source_To_Process (Get_Argument, No_More_Args);
      exit when No_More_Args;
   end loop;
   --  -->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8

   Process_cargs_Section;

exception
   when GNAT.Command_Line.Invalid_Switch =>
      Error ("invalid switch : " & Full_Switch);
      raise Parameter_Error;

   when GNAT.Command_Line.Invalid_Parameter =>
      Error ("parameter missed for : -" & Full_Switch);
      raise Parameter_Error;

end Scan_Parameters;
