------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--                       A S I S _ U L . O U T P U T                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2004-2007, AdaCore                      --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not,  write  to the  Free Software Foundation,  51 Franklin  --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains various output routines.

with Ada.Exceptions; use Ada.Exceptions;

package ASIS_UL.Output is

   procedure Report_Unhandled_ASIS_Exception (Ex : Exception_Occurrence);
   --  Reports an unhandled ASIS exception into Standard_Error

   procedure Report_Unhandled_Exception (Ex : Exception_Occurrence);
   --  Reports an unhandled non-ASIS exception into Standard_Error

   procedure Error (Message : String);
   --  Sends into Stderr the error message in the form 'Tool_Name: Message'

   procedure Error_No_Tool_Name (Message : String);
   --  Sends into Stderr the error message with no tool name prefix

   procedure Info
     (Message  : String;
      Line_Len : Natural := 0;
      Spacing  : Natural := 0);
   --  Sends Message as a separate line(s) into Stderr (with no tool name
   --  prefix). If Line_Len is set to some positive value, it is treated as a
   --  maximal length of the text to be placed into one output line, and if the
   --  length of Message exceeds Line_Len, this procedure tries to split
   --  Message treating spaces as word separators and prints the rest of the
   --  Message on the next line(s). Each continuation line starts from Spacing
   --  number of space characters. Message can be split only on borders of
   --  words.

   procedure Info_No_EOL
     (Message  : String;
      Line_Len : Natural := 0;
      Spacing  : Natural := 0);
   --  The same as Info, but does not "close" the last line being printed out,
   --  that is, the last line does not contain a (platform-specific) EOL
   --  character(s).

end ASIS_UL.Output;
