#ifndef UI_CUT_TEXT_H
#define UI_CUT_TEXT_H

#include <Client/UIRenderer.h>
#include <Client/UIStyle.h>

namespace Client
{

   class CutTextDraw
   {
      public:
	 bool operator()(UIRenderer *ui,
			 Ark::Font *font,
			 int x, int y, 
		   const Ark::String &text)
	 {
	    ui->DrawString(font, text, x, y);
	    return true;
	 }
   };

   class CutBoxCompute
   {
	 Box m_Box;
      public:
	 CutBoxCompute() {m_Box.MakeEmpty();}

	 bool operator()(UIRenderer *ui,
			 Ark::Font *font,
			 int x, int y, 
			 const Ark::String &text)
	 {
	    m_Box.Add(x,y);
	    m_Box.Add(x+ui->GetStringWidth(font, text),
		      y+ui->GetStringHeight(font, text));
	    return true;
	 }

	 const Box &GetBox() const {return m_Box;}
   };
   
   template <class T>
   bool CutText(UIRenderer *ui,
		Ark::Font *font,
		int beginy,
		int minx, int miny,
		int maxx, int maxy,
		Ark::String msg,
		T &callback)
   {
      
      Ark::String::size_type start = 0;
      Ark::String::size_type stop = 0;
      Ark::String::size_type size = msg.size();
      int xpos = minx, ypos = beginy;
      int yskip = 0;
      bool retval = false;
      bool next_skipline = false;

      while (stop != size)
      {
	 stop = std::min(msg.find(" ", start), msg.find("\n", start));

	 if (stop == Ark::String::npos)
	    stop = size;
	 Ark::String temp = msg.substr(start, stop - start + 1);
	 
	 int xtemp = ui->GetStringWidth (font, temp);
	 if (xpos + xtemp > maxx || next_skipline)
	 {
	    ypos += yskip;
	    xpos = minx;
	    yskip = 0;
	    next_skipline = false;
	 }
	 
	 if(!temp.empty() && temp.at(temp.size()-1) == '\n')
	    next_skipline = true;
	 
	 yskip = std::max(yskip, ui->GetStringHeight (font, temp));
	 if (ypos+yskip > miny && ypos < maxy)
	    retval = callback (ui, font, xpos, ypos, temp);
	 
	 xpos += xtemp;
	 start = stop + 1;
      }

      return retval;
   }
}

#endif

