/* $Id: ScrollWidget.cpp,v 1.6 2003/03/20 19:39:51 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2003 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <Client/ScrollWidget.h>
#include <Client/UICutText.h>

namespace Client
{
   ScrollWidget::ScrollWidget (UIRenderer *rnd,
			       Ark::String config) : 
      m_Style (rnd)
   {
      Ark::Config cfg;
      Ark::Cache *cache = &rnd->Rdr()->GetCache();

      cfg.Load(config);

      ////////////
      Ark::String bg = cfg.GetStr("scroll::BgImage", "");

      if (bg != "")
      {
	 cache->Get(Ark::V_TEXTURE, bg,  m_Bg);
	 if (m_Bg) m_Bg->Configure();
      }

      ///////////
      m_Text = cfg.GetStr("scroll::Text", "");
      m_Font = cfg.GetStr("scroll::Font", "arial1-2-ffffff");

      int expectedW = cfg.GetInt("scroll::ExpectedWidth", 800);
      
      const float scrfactor = scalar(rnd->width) / scalar(expectedW);
      m_MinX = (int) scrfactor*cfg.GetInt("scroll::MinX", 0);
      m_MaxX = (int) scrfactor*cfg.GetInt("scroll::MaxX", 0);
      m_MinY = (int) scrfactor*cfg.GetInt("scroll::MinY", 0);
      m_MaxY = (int) scrfactor*cfg.GetInt("scroll::MaxY", 0);      

      m_ScrollSpeed = (int) scrfactor*cfg.GetInt("scroll::ScrollSpeed", 50);
      
      m_CurPos = (float)m_MaxY;
   }

   ScrollWidget::~ScrollWidget ()
   {
   }
   
   void
   ScrollWidget::Render(UIRenderer *ui)
   {
      Ark::FontPtr font = ui->GetFont (m_Font);

      if (m_Bg)
      {
	 ui->SetTexture (m_Bg);
	 ui->DrawTexturedRectangle (0, 0, ui->width, ui->height);
      }
	 
      m_CurPos -= m_Timer.GetDelta() * scalar(m_ScrollSpeed);

      CutTextDraw cd;
      if (!CutText (ui, font.Get(), (int)m_CurPos, m_MinX, m_MinY,
		    m_MaxX, m_MaxY, m_Text, cd) && m_CurPos < 0)
	 m_CurPos = (float)m_MaxY;
      m_Timer.Update();
   }
}
