/* $Id: zfstream.h,v 1.5 2001/10/27 23:45:51 nekeme Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** This code was originally written by Bernie Bright <bbright@c031.aone.net.au>
** Based on zlib/contrib/iostream/ by Kevin Ruland <kevin@rodin.wustl.edu>
**
*/


#ifndef _zfstream_hxx
#define _zfstream_hxx


#include <zlib.h>

#include <iostream>

//#define ios_openmode std::ios::open_mode
#define ios_openmode int
#define ios_in       std::ios::in
#define ios_out      std::ios::out
#define ios_app      std::ios::app
#define ios_binary   std::ios::binary
#define ios_seekdir  std::ios::seekdir

#define ios_badbit   std::ios::badbit
#define ios_failbit  std::ios::failbit

/**
 * A C++ I/O streams interface to the zlib gz* functions.
 */
class gzfilebuf : public std::streambuf
{
  // Those two typedefs should not be defined (WIN32?)
  // - pos_type is a typedef for streampos
  // - off_type is a typedef for streamoff
#if !defined(__GNUG__) || (__GNUC__ < 3)
    typedef std::streampos pos_type;
    typedef std::streamoff off_type;
    typedef int int_type;
#else
    typedef std::streambuf::pos_type pos_type;
    typedef std::streambuf::off_type off_type;
    typedef std::streambuf::int_type int_type;
#endif

public:

    /** Constructor */
    gzfilebuf();

    /** Destructor */
    virtual ~gzfilebuf();

    /**
     * Open a stream
     * @param name file name
     * @param io_mode mdoe flags
     * @return file stream
     */
    gzfilebuf* open( const char* name, ios_openmode io_mode );

    /** 
     * Attach to an existing file descriptor
     * @param file_descriptor file descriptor
     * @param io_mode mode flags
     * @return file stream
     */
    gzfilebuf* attach( int file_descriptor, ios_openmode io_mode );

    /** Close stream */
    gzfilebuf* close();

    // int setcompressionlevel( int comp_level );
    // int setcompressionstrategy( int comp_strategy );

    /** @return true if open, false otherwise */
    bool is_open() const { return (file != NULL); }

    /** @return stream position */
    virtual pos_type seekoff( off_type off, ios_seekdir way, int which );

    /** sync the stream */
    virtual int sync();

protected:

    virtual int_type underflow();
    virtual int_type overflow( int_type c = EOF );

private:

    int_type flushbuf();
    int fillbuf();

    // Convert io_mode to "rwab" string.
    void cvt_iomode( char* mode_str, ios_openmode io_mode );

private:

    gzFile file;
    ios_openmode mode;
    bool own_file_descriptor;

    // Get (input) buffer.
    int ibuf_size;
    char* ibuffer;

    enum { page_size = 4096 };

private:
    // Not defined
    gzfilebuf( const gzfilebuf& );
    void operator= ( const gzfilebuf& );
};

/**
 * document me
 */
struct gzifstream_base
{
    gzifstream_base() {}

    gzfilebuf gzbuf;
};

/**
 * An envelope class for gzifstream.
 */
class gzifstream : private gzifstream_base, public std::istream
{
public:
    /** Default constructor */
    gzifstream();

    /**
     * Constructor that attempt to open a file with and without
     * ".gz" extension.
     * @param name name of file
     * @param io_mode file open mode(s) "or'd" together
     */
    gzifstream( const std::string& name,
		   ios_openmode io_mode = ios_in | ios_binary );

    /**
     * Constructor that attaches itself to an existing file descriptor.
     * @param fd file descriptor
     * @param io_mode file open mode(s) "or'd" together
     */
    gzifstream( int fd, ios_openmode io_mode = ios_in|ios_binary );

    /**
     * Attempt to open a file with and without ".gz" extension.
     * @param name name of file
     * @param io_mode file open mode(s) "or'd" together
     */
    void open( const std::string& name,
	       ios_openmode io_mode = ios_in|ios_binary );

    /**
     * Attach to an existing file descriptor.
     * @param fd file descriptor
     * @param io_mode file open mode(s) "or'd" together
     */
    void attach( int fd, ios_openmode io_mode = ios_in|ios_binary );

    /**
     * Close the stream.
     */
    void close() { gzbuf.close(); }

    /** @return true if the file is successfully opened, false otherwise. */
    bool is_open() { return gzbuf.is_open(); }

private:
    // Not defined!
    gzifstream( const gzifstream& );    
    void operator= ( const gzifstream& );    
};


#endif // _zfstream_hxx

