/*
 * Argus Software
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: //depot/argus/argus-3.0/clients/include/argus_sort.h#14 $
 * $DateTime: 2005/12/27 13:50:56 $
 * $Change: 504 $
 */

#ifndef ArgusMetric_h
#define ArgusMetric_h

#define ARGUS_MAX_METRIC_ALG		70
#define MAX_METRIC_ALG_TYPES		70

#define ARGUSMETRICSTARTTIME		1
#define ARGUSMETRICLASTTIME		2
#define ARGUSMETRICTRANSACTIONS		3
#define ARGUSMETRICDURATION		4
#define ARGUSMETRICAVGDURATION		5
#define ARGUSMETRICMINDURATION		6
#define ARGUSMETRICMAXDURATION		7
#define ARGUSMETRICSRCMAC		8
#define ARGUSMETRICDSTMAC		9
#define ARGUSMETRICSRCADDR		10
#define ARGUSMETRICDSTADDR		11
#define ARGUSMETRICPROTOCOL		12
#define ARGUSMETRICIPID			13
#define ARGUSMETRICSRCPORT		14
#define ARGUSMETRICDSTPORT		15
#define ARGUSMETRICSRCTOS		16
#define ARGUSMETRICDSTTOS		17
#define ARGUSMETRICSRCTTL		18
#define ARGUSMETRICDSTTTL		19
#define ARGUSMETRICBYTECOUNT		20
#define ARGUSMETRICSRCBYTECOUNT		21
#define ARGUSMETRICDSTBYTECOUNT		22
#define ARGUSMETRICPKTSCOUNT		23
#define ARGUSMETRICSRCPKTSCOUNT		24
#define ARGUSMETRICDSTPKTSCOUNT		25
#define ARGUSMETRICAPPBYTECOUNT		26
#define ARGUSMETRICSRCAPPBYTECOUNT	27
#define ARGUSMETRICDSTAPPBYTECOUNT	28
#define ARGUSMETRICLOAD			29
#define ARGUSMETRICSRCLOAD		30
#define ARGUSMETRICDSTLOAD		31
#define ARGUSMETRICLOSS			32
#define ARGUSMETRICRATE			33
#define ARGUSMETRICSRCRATE		34
#define ARGUSMETRICDSTRATE		35
#define ARGUSMETRICTRANREF		36
#define ARGUSMETRICSEQ			37
#define ARGUSMETRICSRCMPLS		38
#define ARGUSMETRICDSTMPLS		39
#define ARGUSMETRICSRCVLAN		40
#define ARGUSMETRICDSTVLAN		41
#define ARGUSMETRICSRCID		42
#define ARGUSMETRICSRCTCPBASE		43
#define ARGUSMETRICDSTTCPBASE		44
#define ARGUSMETRICTCPRTT		45
#define ARGUSMETRICTCPSYNACK		46
#define ARGUSMETRICTCPACKDAT		47
#define ARGUSMETRICDSRCLOSS		48
#define ARGUSMETRICDDSTLOSS		49
#define ARGUSMETRICSRCINTPKT		50
#define ARGUSMETRICDSTINTPKT		51
#define ARGUSMETRICSRCDURATION		52
#define ARGUSMETRICDSTDURATION		53
#define ARGUSMETRICSRCTCPMAX		54
#define ARGUSMETRICDSTTCPMAX		55
#define ARGUSMETRICSRCINTPKTACT		56
#define ARGUSMETRICSRCINTPKTIDL		57
#define ARGUSMETRICDSTINTPKTACT		58
#define ARGUSMETRICDSTINTPKTIDL		59
#define ARGUSMETRICSRCWINDOW		60
#define ARGUSMETRICDSTWINDOW		61
#define ARGUSMETRICDELTADUR		62
#define ARGUSMETRICDELTASTARTTIME	63
#define ARGUSMETRICDELTALASTTIME	64
#define ARGUSMETRICSRCHOPCOUNT		65
#define ARGUSMETRICDSTHOPCOUNT   	66


#if defined(ArgusMetric)

double ArgusFetchSrcId (struct ArgusRecordStruct *ns);
double ArgusFetchStartTime (struct ArgusRecordStruct *ns);
double ArgusFetchLastTime (struct ArgusRecordStruct *ns);
double ArgusFetchAvgDuration (struct ArgusRecordStruct *ns);
double ArgusFetchMinDuration (struct ArgusRecordStruct *ns);
double ArgusFetchMaxDuration (struct ArgusRecordStruct *ns);
double ArgusFetchSrcDuration (struct ArgusRecordStruct *ns);
double ArgusFetchDstDuration (struct ArgusRecordStruct *ns);
double ArgusFetchDuration (struct ArgusRecordStruct *ns);
double ArgusFetchSrcMac (struct ArgusRecordStruct *ns);
double ArgusFetchDstMac (struct ArgusRecordStruct *ns);
double ArgusFetchSrcAddr (struct ArgusRecordStruct *ns);
double ArgusFetchDstAddr (struct ArgusRecordStruct *ns);
double ArgusFetchProtocol (struct ArgusRecordStruct *ns);
double ArgusFetchIpId (struct ArgusRecordStruct *ns);
double ArgusFetchSrcPort (struct ArgusRecordStruct *ns);
double ArgusFetchDstPort (struct ArgusRecordStruct *ns);
double ArgusFetchSrcMpls (struct ArgusRecordStruct *ns);
double ArgusFetchDstMpls (struct ArgusRecordStruct *ns);
double ArgusFetchSrcVlan (struct ArgusRecordStruct *ns);
double ArgusFetchDstVlan (struct ArgusRecordStruct *ns);
double ArgusFetchSrcIpId (struct ArgusRecordStruct *ns);
double ArgusFetchDstIpId (struct ArgusRecordStruct *ns);
double ArgusFetchSrcTos (struct ArgusRecordStruct *ns);
double ArgusFetchDstTos (struct ArgusRecordStruct *ns);
double ArgusFetchSrcTtl (struct ArgusRecordStruct *ns);
double ArgusFetchDstTtl (struct ArgusRecordStruct *ns);
double ArgusFetchTransactions (struct ArgusRecordStruct *ns);
double ArgusFetchSrcLoad (struct ArgusRecordStruct *ns);
double ArgusFetchDstLoad (struct ArgusRecordStruct *ns);
double ArgusFetchLoad (struct ArgusRecordStruct *ns);
double ArgusFetchLoss (struct ArgusRecordStruct *ns);
double ArgusFetchSrcLoss (struct ArgusRecordStruct *ns);
double ArgusFetchDstLoss (struct ArgusRecordStruct *ns);
double ArgusFetchPercentLoss (struct ArgusRecordStruct *ns);
double ArgusFetchPercentSrcLoss (struct ArgusRecordStruct *ns);
double ArgusFetchPercentDstLoss (struct ArgusRecordStruct *ns);
double ArgusFetchSrcRate (struct ArgusRecordStruct *ns);
double ArgusFetchDstRate (struct ArgusRecordStruct *ns);
double ArgusFetchRate (struct ArgusRecordStruct *ns);
double ArgusFetchTranRef (struct ArgusRecordStruct *ns);
double ArgusFetchSeq (struct ArgusRecordStruct *ns);
double ArgusFetchByteCount (struct ArgusRecordStruct *ns);
double ArgusFetchSrcByteCount (struct ArgusRecordStruct *ns);
double ArgusFetchDstByteCount (struct ArgusRecordStruct *ns);
double ArgusFetchPktsCount (struct ArgusRecordStruct *ns);
double ArgusFetchSrcPktsCount (struct ArgusRecordStruct *ns);
double ArgusFetchDstPktsCount (struct ArgusRecordStruct *ns);
double ArgusFetchAppByteCount (struct ArgusRecordStruct *ns);
double ArgusFetchSrcAppByteCount (struct ArgusRecordStruct *ns);
double ArgusFetchDstAppByteCount (struct ArgusRecordStruct *ns);
double ArgusFetchSrcTcpBase (struct ArgusRecordStruct *ns);
double ArgusFetchDstTcpBase (struct ArgusRecordStruct *ns);
double ArgusFetchTcpRtt (struct ArgusRecordStruct *ns);
double ArgusFetchTcpSynAck (struct ArgusRecordStruct *ns);
double ArgusFetchTcpAckDat (struct ArgusRecordStruct *ns);
double ArgusFetchSrcTcpMax (struct ArgusRecordStruct *ns);
double ArgusFetchDstTcpMax (struct ArgusRecordStruct *ns);
double ArgusFetchSrcIntPkt (struct ArgusRecordStruct *ns);
double ArgusFetchSrcIntPktAct (struct ArgusRecordStruct *ns);
double ArgusFetchSrcIntPktIdl (struct ArgusRecordStruct *ns);
double ArgusFetchDstIntPkt (struct ArgusRecordStruct *ns);
double ArgusFetchDstIntPktAct (struct ArgusRecordStruct *ns);
double ArgusFetchDstIntPktIdl (struct ArgusRecordStruct *ns);
double ArgusFetchSrcWindow (struct ArgusRecordStruct *ns);
double ArgusFetchDstWindow (struct ArgusRecordStruct *ns);
double ArgusFetchDeltaDuration (struct ArgusRecordStruct *ns);
double ArgusFetchDeltaStartTime (struct ArgusRecordStruct *ns);
double ArgusFetchDeltaLastTime (struct ArgusRecordStruct *ns);
double ArgusFetchSrcHopCount (struct ArgusRecordStruct *ns);
double ArgusFetchDstHopCount (struct ArgusRecordStruct *ns);

double (*ArgusFetchAlgorithmTable[MAX_METRIC_ALG_TYPES])(struct ArgusRecordStruct *) = {
   ArgusFetchSrcId,
   ArgusFetchStartTime,
   ArgusFetchLastTime,
   ArgusFetchTransactions,
   ArgusFetchDuration,
   ArgusFetchAvgDuration,
   ArgusFetchMinDuration,
   ArgusFetchMaxDuration,
   ArgusFetchSrcMac,
   ArgusFetchDstMac,
   ArgusFetchSrcAddr,
   ArgusFetchDstAddr,
   ArgusFetchProtocol,
   ArgusFetchIpId,
   ArgusFetchSrcPort,
   ArgusFetchDstPort,
   ArgusFetchSrcTos,
   ArgusFetchDstTos,
   ArgusFetchSrcTtl,
   ArgusFetchDstTtl,
   ArgusFetchByteCount,
   ArgusFetchSrcByteCount,
   ArgusFetchDstByteCount,
   ArgusFetchPktsCount,
   ArgusFetchSrcPktsCount,
   ArgusFetchDstPktsCount,
   ArgusFetchAppByteCount,
   ArgusFetchSrcAppByteCount,
   ArgusFetchDstAppByteCount,
   ArgusFetchLoad,
   ArgusFetchSrcLoad,
   ArgusFetchDstLoad,
   ArgusFetchLoss,
   ArgusFetchPercentLoss,
   ArgusFetchRate,
   ArgusFetchSrcRate,
   ArgusFetchDstRate,
   ArgusFetchTranRef,
   ArgusFetchSeq,
   ArgusFetchSrcMpls,
   ArgusFetchDstMpls,
   ArgusFetchSrcVlan,
   ArgusFetchDstVlan,
   ArgusFetchSrcId,
   ArgusFetchSrcTcpBase,
   ArgusFetchDstTcpBase,
   ArgusFetchTcpRtt,
   ArgusFetchTcpSynAck,
   ArgusFetchTcpAckDat,
   ArgusFetchSrcLoss,
   ArgusFetchDstLoss,
   ArgusFetchPercentSrcLoss,
   ArgusFetchPercentDstLoss,
   ArgusFetchSrcIntPkt,
   ArgusFetchDstIntPkt,
   ArgusFetchSrcDuration,
   ArgusFetchDstDuration,
   ArgusFetchSrcTcpMax,
   ArgusFetchDstTcpMax,
   ArgusFetchSrcIntPktAct,
   ArgusFetchSrcIntPktIdl,
   ArgusFetchDstIntPktAct,
   ArgusFetchDstIntPktIdl,
   ArgusFetchSrcWindow,
   ArgusFetchDstWindow,
   ArgusFetchDeltaDuration,
   ArgusFetchDeltaStartTime,
   ArgusFetchDeltaLastTime,
   ArgusFetchSrcHopCount,
   ArgusFetchDstHopCount,
};

char *ArgusMetricKeyWords[MAX_METRIC_ALG_TYPES] = {
   "srcid",
   "stime",
   "ltime",
   "trans",
   "dur",
   "avgdur",
   "mindur",
   "maxdur",
   "smac",
   "dmac",
   "saddr",
   "daddr",
   "proto",
   "ipid",
   "sport",
   "dport",
   "stos",
   "dtos",
   "sttl",
   "dttl",
   "bytes",
   "sbytes",
   "dbytes",
   "pkts",
   "spkts",
   "dpkts",
   "appbytes",
   "sappbytes",
   "dappbytes",
   "load",
   "sload",
   "dload",
   "loss",
   "ploss",
   "rate",
   "srate",
   "drate",
   "tranref",
   "seq",
   "smpls",
   "dmpls",
   "svlan",
   "dvlan",
   "srcid",
   "stcpb",
   "dtcpb",
   "tcprtt",
   "synack",
   "ackdat",
   "sloss",
   "dloss",
   "sploss",
   "dploss",
   "sintpkt",
   "dintpkt",
   "sdur",
   "ddur",
   "stcpmax",
   "dtcpmax",
   "sintpktact",
   "sintpktidl",
   "dintpktact",
   "dintpktidl",
   "swin",
   "dwin",
   "deldur",
   "delstime",
   "delltime",
   "shops",
   "dhops",
};

#else

extern double ArgusFetchSrcId (struct ArgusRecordStruct *ns);
extern double ArgusFetchStartTime (struct ArgusRecordStruct *ns);
extern double ArgusFetchLastTime (struct ArgusRecordStruct *ns);
extern double ArgusFetchAvgDuration (struct ArgusRecordStruct *ns);
extern double ArgusFetchMinDuration (struct ArgusRecordStruct *ns);
extern double ArgusFetchMaxDuration (struct ArgusRecordStruct *ns);
extern double ArgusFetchDuration (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcMac (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstMac (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcAddr (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstAddr (struct ArgusRecordStruct *ns);
extern double ArgusFetchProtocol (struct ArgusRecordStruct *ns);
extern double ArgusFetchIpId (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcPort (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstPort (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcMpls (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstMpls (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcVlan (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstVlan (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcIpId (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstIpId (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcTos (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstTos (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcTtl (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstTtl (struct ArgusRecordStruct *ns);
extern double ArgusFetchTransactions (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcLoad (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstLoad (struct ArgusRecordStruct *ns);
extern double ArgusFetchLoad (struct ArgusRecordStruct *ns);
extern double ArgusFetchLoss (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcLoss (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstLoss (struct ArgusRecordStruct *ns);
extern double ArgusFetchPercentLoss (struct ArgusRecordStruct *ns);
extern double ArgusFetchPercentSrcLoss (struct ArgusRecordStruct *ns);
extern double ArgusFetchPercentDstLoss (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcRate (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstRate (struct ArgusRecordStruct *ns);
extern double ArgusFetchRate (struct ArgusRecordStruct *ns);
extern double ArgusFetchTranRef (struct ArgusRecordStruct *ns);
extern double ArgusFetchSeq (struct ArgusRecordStruct *ns);
extern double ArgusFetchByteCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcByteCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstByteCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchPktsCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcPktsCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstPktsCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchAppByteCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcAppByteCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstAppByteCount (struct ArgusRecordStruct *ns);
extern double ArgusFetchSrcTcpBase (struct ArgusRecordStruct *ns);
extern double ArgusFetchDstTcpBase (struct ArgusRecordStruct *ns);
extern double ArgusFetchTcpRtt (struct ArgusRecordStruct *ns);
extern double ArgusFetchTcpMax (struct ArgusRecordStruct *ns);
extern double ArgusFetchDeltaDuration (struct ArgusRecordStruct *ns);
extern double ArgusFetchDeltaStartTime (struct ArgusRecordStruct *ns);
extern double ArgusFetchDeltaLastTime (struct ArgusRecordStruct *ns);
 
extern int (*ArgusMetricAlgorithmTable[MAX_METRIC_ALG_TYPES])(struct ArgusRecordStruct *, struct ArgusRecordStruct *);
extern char *ArgusMetricKeyWords[MAX_METRIC_ALG_TYPES];
#endif


#endif

