/*
 * Argus Software
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: //depot/argus/argus-3.0/clients/include/argus_labeler.h#8 $
 * $DateTime: 2007/02/09 14:41:59 $
 * $Change: 1035 $
 */

#ifndef ArgusLabeler_h
#define ArgusLabeler_h


#define ARGUS_TREE              0x01
#define ARGUS_TREE_VISITED      0x02
#define ARGUS_VISITED           0x10
#define ARGUS_MOL               0x20
#define ARGUS_GRAPH             0x30
 
struct ArgusLabelerStruct {
   int status, mask, inserts;
   struct RaPolicyStruct *drap, *rap;
   struct RaFlowModelStruct *fmodel;
   struct ArgusQueueStruct *queue;
   struct ArgusHashTable htable;
   struct ArgusHashStruct hstruct;
   struct RaAddressStruct **ArgusAddrTree;
};

#define ARGUS_EXACT_MATCH       0
#define ARGUS_LONGEST_MATCH     1
#define ARGUS_ANY_MATCH         2

struct RaAddressStruct {
   struct ArgusQueueHeader qhdr;
   struct RaAddressStruct *l, *r;
   struct ArgusCIDRAddr addr;
   int offset, count, status;
   char *str, *label, *dns;
   float x, y;
};


#endif

