; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{A4411884-989D-413D-9587-9966A6C559A5}
AppName=Ardesia
AppVersion=0.9
AppPublisher=The Ardesia Team
AppPublisherURL=http://ardesia.googlecode.com
AppSupportURL=http://ardesia.googlecode.com
AppUpdatesURL=http://ardesia.googlecode.com
ChangesAssociations=yes
ChangesEnvironment=yes
DefaultDirName={pf}\Ardesia
DefaultGroupName=Ardesia
LicenseFile=ardesia_0.9-windows-1_i386\COPYING
InfoBeforeFile=ardesia_0.9-windows-1_i386\NEWS
InfoAfterFile=ardesia_0.9-windows-1_i386\RUN
OutputDir=.
OutputBaseFilename=ardesia_0.9-setup-1
SetupIconFile=ardesia_0.9-windows-1_i386\share\ardesia\ui\icons\ardesia.ico
Compression=lzma
SolidCompression=yes
UninstallDisplayIcon={app}\share\ardesia\ui\icons\ardesia.ico

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "german"; MessagesFile: "compiler:Languages\German.isl"


[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1

[Files]
Source: "ardesia_0.9-windows-1_i386\AUTHORS"; DestDir: "{app}"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\COPYING"; DestDir: "{app}"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\NEWS"; DestDir: "{app}"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\README"; DestDir: "{app}"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\RUN"; DestDir: "{app}"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\bin\*"; DestDir: "{app}\bin\"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\etc\gtk-2.0\*"; DestDir: "{app}\etc\gtk-2.0"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\lib\gtk-2.0\2.10.0\engines\*"; DestDir: "{app}\lib\gtk-2.0\2.10.0\engines"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\ardesia\scripts\screencast.bat"; DestDir: "{app}\share\ardesia\scripts"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\ardesia\ui\*"; DestDir: "{app}\share\ardesia\ui"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\ardesia\ui\backgrounds\*"; DestDir: "{app}\share\ardesia\ui\backgrounds"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\ardesia\ui\icons\*"; DestDir: "{app}\share\ardesia\ui\icons"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\curtain\ui\curtain.png"; DestDir: "{app}\share\curtain\ui"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\curtain\ui\curtain.ui"; DestDir: "{app}\share\curtain\ui"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\locale\es\LC_MESSAGES\ardesia.mo"; DestDir: "{app}\share\locale\es\LC_MESSAGES"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\locale\fr\LC_MESSAGES\ardesia.mo"; DestDir: "{app}\share\locale\fr\LC_MESSAGES"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\locale\it\LC_MESSAGES\ardesia.mo"; DestDir: "{app}\share\locale\it\LC_MESSAGES"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\spotlighter\ui\pixmaps\*"; DestDir: "{app}\share\spotlighter\ui\pixmaps"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\curtain\ui\pixmaps\*"; DestDir: "{app}\share\curtain\ui\pixmaps"; Flags: ignoreversion
Source: "ardesia_0.9-windows-1_i386\share\spotlighter\ui\spotlighter.ui"; DestDir: "{app}\share\spotlighter\ui"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\Ardesia"; Filename: "{app}\bin\ardesia.exe"; IconFilename: "{app}\share\ardesia\ui\icons\ardesia.ico"
Name: "{group}\Curtain"; Filename: "{app}\bin\curtain.exe"; IconFilename: "{app}\share\curtain\ui\pixmaps\curtain.ico"
Name: "{group}\Spotlighter"; Filename: "{app}\bin\spotlighter.exe"; IconFilename: "{app}\share\spotlighter\ui\pixmaps\spotlighter.ico"
Name: "{group}\{cm:UninstallProgram,Ardesia}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\Ardesia"; Filename: "{app}\bin\ardesia.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Ardesia"; Filename: "{app}\bin\ardesia.exe"; Tasks: quicklaunchicon

[Run]
Filename: "{app}\bin\ardesia.exe"; Description: "{cm:LaunchProgram,Ardesia}"; Flags: nowait postinstall skipifsilent

[Code]
function NotOnPathAlready(): Boolean;
var
  BinDir, Path: String;
begin
  if RegQueryStringValue(HKEY_CURRENT_USER, 'Environment', 'Path', Path) then
  begin // Successfully read the value
    BinDir := ExpandConstant('{app}\bin');
    if Pos(LowerCase(BinDir), Lowercase(Path)) = 0 then
    begin
      Result := True;
    end
    else
    begin
      Result := False;
    end
  end
  else // The key probably doesn't exist
  begin
    Log('Could not access HKCU\Environment\PATH so assume it is ok to add it');
    Result := True;
  end;
end;


[Registry]
Root: HKCR; Subkey: ".iwb"; ValueType: string; ValueName: ""; ValueData: "ardesia"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "ardesia"; ValueType: string; ValueName: ""; ValueData: "Ardesia Project File"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "ardesia\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\share\ardesia\ui\icons\iwb.ico"; Flags: uninsdeletevalue
Root: HKCR; SubKey: ardesia\shell\open\command; ValueType: string; ValueName: ""; ValueData: """{app}\bin\ardesia_open.bat"" ""%1"""; Flags: uninsdeletevalue
Root: HKCU; Subkey: "Environment"; ValueType: expandsz; ValueName: "Path"; ValueData: "{olddata};{app}\bin"; Check: NotOnPathAlready()
