#include "simple.h"

// variables

struct simple_data_structure simple = {
    size: 0,
    capacity: 0,
    stats: NULL,
};

// prototypes

int simple_increase_capacity();

// public:

void simple_set_root(){
	
#ifdef DIAGNOSTICS
	printf("[Function: simple_set_root] Adding root directory to the data structure;\n");
#endif
	simple.capacity = 1;
	simple.size = 1;
	simple.stats = calloc(1, sizeof(struct stats));
	
	gstrcpy(&simple.stats[0].path, "/");
	simple.stats[0].name = simple.stats[0].path;
	simple.stats[0].internal = NULL;
	simple.stats[0].repo = -1;
	simple.stats[0].rev = -1;
	set_directory_stats(&simple.stats[0]);	
		
};

char** simple_get_children(const char *path){
    
    char **results = NULL;
    int results_size = 0;
    int i = 0;
    
    for (i = 0; i < simple.size; i++){
	if (gpthent(path, simple.stats[i].path) == 0)
	    results_size++;
    };

    if (results_size == 0)
	return NULL;
    results = calloc(results_size + 1, sizeof(char *));
    
    results_size = 0;
    for (i = 0; i < simple.size; i++)
		if (gpthent(path, simple.stats[i].path) == 0){
		    results[results_size] = simple.stats[i].name;
		    results_size++;
		}

    return results;
    
};

int simple_get_file(const char *path, struct stats **stats){
    
    int i = 0;
    
    for (i = 0; i < simple.size; i++)
		if (strcmp(path, simple.stats[i].path) == 0){
		    (*stats) = &simple.stats[i];
		    return 0;
		};
    return -1;
    
};

int simple_add_file(struct stats *stats){
    
    struct stats *old = NULL;

    if (simple_get_file(stats->path, &old) == 0)
    	memcpy(old, stats, sizeof(struct stats));
    else{
    	if (simple.size == simple.capacity)
			simple_increase_capacity();
    	memcpy(&simple.stats[simple.size], stats, sizeof(struct stats));
    	simple.size++;
    };
    stats->path = NULL;
    stats->name = NULL;
    stats->internal = NULL;
    return 0;
    
};

int simple_delete(const char *path){

	int index = -1;
	int i = 0;

    for (i = 0; (i < simple.size) && (index == -1); i++)
		if (strcmp(path, simple.stats[i].path) == 0)
			index = i;
	if (i == simple.size)
		return -1;
	for (i = index; i < simple.size - 1; i++)
		memcpy(&simple.stats[i], &simple.stats[i + 1], sizeof(struct stats));
	simple.size--;
	return 0;
	
};

// private:

int simple_increase_capacity(){

    struct stats *temp = NULL;
    int i = 0;
    
    if (simple.capacity == 0){
		simple.capacity = 1;
		simple.stats = calloc(sizeof(struct stats), 1);
		return 0;
    };
    
    if ((temp = calloc(sizeof(struct stats), simple.capacity)) == 0)
		return -1;
    for (i = 0; i < simple.capacity; i++)
		temp[i] = simple.stats[i];
    free(simple.stats);
    simple.stats = calloc(sizeof(struct stats), simple.capacity * 2);
    for (i = 0; i < simple.capacity; i++)
		simple.stats[i] = temp[i];
    simple.capacity *= 2;
    free(temp);
    return 0;

};
