/* apt-spy (c) Steven Holmes, 2003. This software is licensed as detailed in the LICENSE file. */

#include <string.h>
#include <curl/curl.h>

#include "include/parse.h"
#include "include/protocols.h"

int get_file(server_t *current, CURL *curl, char *file, int protocol)
{
	char errorbuff[CURL_ERROR_SIZE + 1];
	char url[250];
	double download_speed;
	double download_time;
	double bytes;
	int error;
	
	/* Give us human readable error messages in errorbuff */
	if (curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, errorbuff) != 0)
		return 1;
	
	/* Create the URL... */
	if (protocol == HTTP)
		strcpy(url, "http://");	
	else 
		strcpy(url, "ftp://");

	strncat(url, current->hostname, 80);
	
	/* Complete the URL. Also save it for later use when writing sources.list */
	if (protocol == HTTP) {
		strncat(url, current->path[HTTP], 80);
		strncpy(current->url[HTTP], url, 80);
	}
	else {
		strncat(url, current->path[FTP], 80);
		strncpy(current->url[FTP], url, 80);
	}

	strncat(url, file, 80);
	
	/* And register it */
	if (curl_easy_setopt(curl, CURLOPT_URL, url) != 0)
		return 1;
	
	/* Now do the actual transfer */
	
	if (((error = curl_easy_perform(curl)) != 0) && (error != CURLE_OPERATION_TIMEOUTED)) {
		fprintf(stderr, "\t\tError: %s\n", errorbuff);
		return 1;
	}
	
	/* And get the statistics and store them */
	curl_easy_getinfo(curl, CURLINFO_TOTAL_TIME, &download_time);
	curl_easy_getinfo(curl, CURLINFO_SIZE_DOWNLOAD, &bytes);

	if (bytes == 0) {
		fprintf(stderr, "\t\tNo data was transfered\n");
		return 1;
	}
	                                                
	printf("\t\tDownloaded %.0f bytes in %2.2f seconds\n", bytes, download_time);

	/* Calculate download speed... */
	download_speed = (double) bytes / download_time;

	printf("\t\tDownload speed: %.2f kB/sec\n", download_speed / (double) 1024);

	if (download_speed > current->stats.speed) {
		current->stats.speed = download_speed;
		current->stats.protocol = protocol;
	}	
	return 0;
}
