/* apt-spy (c) Steven Holmes, 2003. This software is licensed as detailed in the LICENSE file. */

#include <stdio.h>
#include <string.h>
#include <curl/curl.h>

#include "include/parse.h"
#include "include/benchmark.h"
#include "include/protocols.h"

int benchmark(server_t *current, char *proxy,  int timeout, char *file)
{
	CURL *curl;

	printf("\nSERVER:\t%s\n", current->hostname);

	/* We use libcurl - here we setup some global options */
	curl = curl_easy_init();
	
	if (curl == NULL)
		return 1;

	/* Set proxy server to use */
	if (proxy != NULL)
		if (curl_easy_setopt(curl, CURLOPT_PROXY, proxy) != 0)
			return 1;

	/* Connection timeout */
	if (curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, (long) timeout) != 0)
		return 1;
	
	/* Total timeout */
	if (curl_easy_setopt(curl, CURLOPT_TIMEOUT, (long) timeout) != 0)
		return 1;

	/* Select callback function to deal with data. */
	if (curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, null_write_function) != 0)
		return 1;
	
	/* Turn off libcurl's progress indicator */
	if (curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 1) != 0)
		return 1;

	/* Fail on error */
	if (curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1) != 0)
		return 1;

	
	/* Test for an FTP entry */
	if (strlen(current->path[FTP]) != 0) {
		printf("Benchmarking FTP...\n");
		get_file(current, curl, file, FTP);
	}
	
	/* Test for an HTTP entry */
	if (strlen(current->path[HTTP]) != 0) {
		printf("Benchmarking HTTP...\n");
		get_file(current, curl, file, HTTP);
	}

	curl_easy_cleanup(curl);

	return 0;	
}

/* It is in TODO to re-write this to use qsort(). */
void decide_best(server_t *current, server_t *best)
{
	int i, j;

	/* A probably very inefficient algorithm that seems to work :P */

	/* move 'i' to the correct place in the array to place the new entry */
	for (i = 0; i < BESTNUMBER; ++i)
		if (current->stats.speed > best[i].stats.speed)
			break;
	
	/* shove everything along one */
	for (j = BESTNUMBER - 2; j >= i; --j)
		memcpy(&best[j + 1], &best[j], sizeof(server_t));
	
	/* copy the new entry into the correct place */
	memcpy(&best[i], current, sizeof(server_t));	

}

/* This is purely for libcurl's benefit */
size_t null_write_function(double *bytes, size_t size, size_t nmemb, void *stream)
{
	return (size * nmemb);		/* Just signal everything was ok and discard data */
}
