
#include "debug.h"
#include "showinfo.h"
#include "meta.h"
#include "acfg.h"
#include "filereader.h"

using namespace MYSTD;

const char szReportButton[] =
"<tr><td class=\"colcont\"><form action=\"#top\">"
					"<input type=\"submit\" name=\"doCount\" value=\"Count Data\"></form>"
					"</td><td class=\"colcont\" colspan=8 valign=top><font size=-2>"
					"<i>Not calculated, click \"Count data\"</i></font></td></tr>";

// some NOOPs
tStaticFileSend::tStaticFileSend(int fd, const char *s,
		const char *m, const char *c) :
	maintenance(fd), m_sFileName(s), m_sMimeType(m), m_sHttpCode(c)
{
}

tStaticFileSend::~tStaticFileSend()
{
}

/// Not used, Run is overriden instead
void tStaticFileSend::Action(const MYSTD::string & src)
{
}

void tStaticFileSend::Run(const string &cmd)
{
	LOGSTART2("tStaticFileSend::Run", cmd);
#define BUFSIZE 1023
	vector<char> buf(BUFSIZE);
	string contents;
	filereader fr;
	if(!fr.OpenFile(acfg::confdir+sPathSep+m_sFileName))
		contents="Information about APT configuration not available, "
				"please contact the system administrator.";
	else
	{
		contents.assign(fr.GetBuffer(), fr.GetSize());
		StrSubst(contents, "$SERVERIP", GetHostname());
		StrSubst(contents, "$SERVERPORT", acfg::port.c_str());
		StrSubst(contents, "$REPAGE", sPathSepUnix + acfg::reportpage);
		if(contents.find("@") != stmiss)
		{
			// ok, needs a set of advanced variables
			gethostname(&buf[0], BUFSIZE);
			StrSubst(contents, "@H",&buf[0]);
			if(acfg::exfailabort)
				StrSubst(contents, "@A", "checked");
			if(contents.find("@T") != stmiss)
			{
				StrSubst(contents, "@T",
						cmd.find("doCount")!=stmiss ? aclog::GetStatReport() : szReportButton);
			}
		}
	}
	snprintf(&buf[0], BUFSIZE, "%lu", contents.length());
	string head=string("HTTP/1.1 ")+(m_sHttpCode ? m_sHttpCode : "200")+
			" OK\r\nConnection: close\r\nContent-Type: "+
			(m_sMimeType?m_sMimeType:"text/html")+"\r\nContent-Length: "
			+&buf[0]+"\r\n\r\n";
	SendRawData(head.data(), head.length(), MSG_MORE);
	SendRawData(contents.data(), contents.length(), 0);
}
