

#include "meta.h"
#include "lockable.h"

#include "maintenance.h"
#include "expiration.h"
#include "pkgimport.h"
#include "showinfo.h"
#include "reportgen.h"
#include "aclogger.h"
#include "filereader.h"
#include "acfg.h"
#include "acbuf.h"
#include "sockio.h"
#include "caddrinfo.h"

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <unistd.h>
#include <signal.h>

using namespace MYSTD;

#define MAINT_HTML_DECO "maint.html" 

maintenance::maintenance(int fd) :
	m_reportFD(fd),
	m_szDecoFile(NULL)
{
}

maintenance::~maintenance()
{
}

/// @brief Sends a HTTP chunk with string contents
/// To terminate the transfer, add an empty string with force flag

void maintenance::SendChunk(const string & x) 
{
    SendChunk(x.data(), x.length());
}

bool maintenance::SendRawData(const char *data, size_t len, int flags)
{
	while(len>0)
	{
		int r=send(m_reportFD, data, len, flags);
		if(r<0)
		{
			if(errno==EINTR || errno==EAGAIN)
				r=0;
			else
				return false;
		}
		
		data+=r;
		len-=r;
	}
	return true;
}

void maintenance::SendChunk(const char *data, size_t len)
{
	if(!data || !len || m_reportFD<0)
		return;
	
	char buf[23];
	int l=sprintf(buf, "%x\r\n", (UINT) len);
	SendRawData(buf, l, MSG_MORE|MSG_NOSIGNAL);
	SendRawData(data, len, MSG_MORE|MSG_NOSIGNAL);
	SendRawData("\r\n", 2, MSG_NOSIGNAL);
}

void maintenance::EndTransfer() 
{
	const char msg[] = "0\r\n\r\n"; 
	SendRawData(msg, sizeof(msg)-1, MSG_NOSIGNAL);
}

void maintenance::SendChunkedPageHeader(const char *httpcode, const char *mimetype)
{
	MYSTD::string buf("HTTP/1.1 ");
	buf+=(httpcode ? httpcode : "200");
	buf+=" OK\r\nConnection: close\r\n"
		"Transfer-Encoding: chunked\r\nContent-Type: ";
	buf+=(mimetype?mimetype:"text/html");
	buf+="\r\n\r\n";
	SendRawData(buf.data(), buf.length(), MSG_MORE);
}
/*
void maintenance::SendDecoration(bool bBegin, const char *szDecoFile)
{

	acbuf m_deco;
	char *mark(NULL);
	
	if(szDecoFile && m_deco.initFromFile((acfg::confdir+sPathSep+szDecoFile).c_str()))
		mark=strchr(m_deco.c_str(), '~');
	
	// deco file specified and loaded?
	if(mark)
	{
		if(bBegin)
			m_deco.erase(mark-m_deco.rptr());
		else
			m_deco.drop(mark-m_deco.rptr()+1);
		string sDeco(m_deco.rptr(), m_deco.size());
		SetStyle(sDeco);
		SendMsg(sDeco);
	}	
	else
		SendMsg(bBegin?"<html><body>":"</html></body>");
	
	if(!bBegin)
		EndTransfer();
}
*/
class authbounce : public maintenance
{
public:
	// some NOOPs
	authbounce(int fd) : maintenance(fd)
	{
	}
	~authbounce()
	{
	}
	void Action(const MYSTD::string & src)
	{
	}
	void Run(const string &)
	{
		const char authmsg[] = "HTTP/1.1 401 Not Authorized\r\nWWW-Authenticate: "
        "Basic realm=\"Apt-Cacher NG administration area\"\r\n"
        "Connection: Close\r\n"
        "Content-Type: text/html\r\nContent-Length:81\r\n\r\n"
        "Not Authorized. Please contact Apt-Cacher NG administrator for further questions.";
		SendRawData(authmsg, sizeof(authmsg)-1, 0);
	}
	
};

void DispatchAndRunMaintTask(const MYSTD::string &cmd, int conFD, const char * szAuthLine)
{	
	maintenance *pWorker(NULL);
	if(!szAuthLine)
		szAuthLine="";

	// not effective, why? signal(SIGPIPE, SIG_IGN);
	
	MYTRY
	{
		//std::cout << "vgl: " << authLine << " und " << acfg::adminauth << "\n";
		
		// admin actions are passed with GET parameters, appended after ?
		if(cmd.find('?')!=stmiss)
		{
			if( ! acfg::adminauth.empty() && acfg::adminauth!=szAuthLine )
				pWorker = new authbounce(conFD);
			else if(cmd.find("doExpire=")!=stmiss || 
					cmd.find("justShow=")!=stmiss ||
					cmd.find("justRemove=")!=stmiss)
				pWorker = new expiration(conFD);
			else if(cmd.find("doImport=")!=stmiss)
				pWorker=new pkgimport(conFD);
			else if(cmd.find("doCount=")!=stmiss)
				pWorker = new tStaticFileSend(conFD, "report.html", "text/html", "200");
		}
		else if (cmd==acfg::reportpage)
			pWorker = new tStaticFileSend(conFD, "report.html", "text/html", "200");
		else if (cmd == "/style.css")
			pWorker = new tStaticFileSend(conFD, "style.css", "text/css", "200");
		else
			pWorker = new tStaticFileSend(conFD, "userinfo.html", "text/html", "404");

		if(pWorker)
			pWorker->Run(cmd);
	}
	MYCATCH(...)
	{ /* whatever */ };
	if(pWorker)
		delete pWorker;
}

void maintenance::SetStyle(string &s)
{
	tStrPos pos=0;

	acbuf buf;
	if( ! buf.initFromFile( (acfg::confdir+sPathSep+"style.css").c_str()) )
		return;
	
	while(stmiss != (pos = s.find("$STYLE", pos)))
	{
		//cerr << "replacing " << s.substr(pos, 6) << " with " << buf.c_str()<<endl;
		s.replace(pos, 6, buf.c_str());
		pos+=buf.size();
	}
}

string & maintenance::GetHostname()
{
	if (m_sHostname.empty())
	{
		struct sockaddr_storage ss;
		socklen_t slen = sizeof(ss);
		char hbuf[NI_MAXHOST];

		if (0==getsockname(m_reportFD, (struct sockaddr *)&ss, &slen) && 0
				==getnameinfo((struct sockaddr*) &ss, sizeof(ss), hbuf,
						sizeof(hbuf), 
						NULL, 0, NI_NUMERICHOST))
		{
			const char *p=hbuf;
			bool bAddBrs(false);
			if(0==strncmp(hbuf, "::ffff:", 7) && strpbrk(p, "0123456789."))
				p+=7; // no more colons there, looks like v4 IP in v6 space -> crop it
			else if(strchr(p, (int) ':'))
				bAddBrs=true; // full v6 address for sure, add brackets
			
			if(bAddBrs)
				m_sHostname="[";
			m_sHostname+=p;
			if(bAddBrs)
				m_sHostname+="]";
		}
		else
			m_sHostname="IP-of-this-cache-server";
	}
	return m_sHostname;

}

