/*
 * parameters.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>

#include "config.h"
#include "variables.h"

static int option_style (char *buffer)
{
	int c;
	if ((buffer[0]=='F')||(buffer[0]=='f')) c=0;
	if ((buffer[0]=='N')||(buffer[0]=='n')) c=1;
	if ((buffer[0]=='T')||(buffer[0]=='t')) c=2;
	if ((buffer[0]=='A')||(buffer[0]=='a')) c=3;
	if ((buffer[0]=='S')||(buffer[0]=='s')) c=4;
	if ((buffer[0]=='C')||(buffer[0]=='c')) c=5;
	return c;
}

static int option_interpolation (char *buffer)
{
	int c;
	if ((buffer[11]=='N')||(buffer[11]=='n')) c=0;
	if ((buffer[11]=='T')||(buffer[11]=='t')) c=1;
	if ((buffer[11]=='B')||(buffer[11]=='b')) c=2;
	if ((buffer[11]=='H')||(buffer[11]=='h')) c=3;
	return c;
}

static void style (int e, int px, int py, double cx, double cy, int par_counter, gchar *filename)
{
	gtk_combo_box_set_active (GTK_COMBO_BOX (combo), e);
	read_color();
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin5), cx);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin6), cy);
	make_image(e, filename, preview);
	if ((option_command() == 6) && (height == -65536) && (width == -65536) && (par_counter == 9))
	{
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin1), px);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin2), py);
	}
	show_spin(gtk_combo_box_get_active (GTK_COMBO_BOX (combo)));
	if (e != 2) move_image(filename, preview);
}

void parameters (gchar *filename, GtkWidget *image, GtkWidget *background, gboolean anypaperrc)
{
	gchar *other, **field, **subfield;
	GdkPixbuf *tempbuf;
	GdkColor color;
	int e=6, px, py, bg, interpolation;
	int i,j=0,k,t=0;
	int par_counter=0;
	gdouble cx, cy;
	gboolean def=FALSE;

	if (anypaperrc == FALSE)
	{
		gtk_entry_set_text (GTK_ENTRY (file_entry), ANYPAPER_DATA "noimage.png");
		px=0;
		py=0;
		cx=1;
		cy=1;
		gdk_color_parse ("#000000", &color);
		gtk_color_button_set_color (GTK_COLOR_BUTTON(cbutton), &color);
	}
	else
	{
		gtk_entry_set_text (GTK_ENTRY (com_entry), "Set_Command");
		gtk_entry_set_text (GTK_ENTRY (def_entry), g_strdup_printf("%s/.anypaper/output.png", g_get_home_dir ()));
		interpolation=2;
	}
	
	if (g_file_get_contents (filename, &other, NULL, NULL))
	{
		for (i=0;other[i]!=0;i++) if (other[i]=='\n') j++;
		field = g_strsplit (other, "\n", j);
		e=option_command();
	
		for (i=0;i!=j;i++)
		{
			for(k=0;(field[i][k]!=0);k++) if (field[i][k]==':')
			{
				t=1;
				break;
			}
			if((field[i][0]!='#')&&(t!=0))
			{
				subfield = g_strsplit (field[i], ":", 2);
				g_strstrip(subfield[0]);
				g_strstrip(subfield[1]);
				if (!g_ascii_strcasecmp(subfield[0],"File"))
				{
					if  (remaining_args != 0) gtk_entry_set_text (GTK_ENTRY (file_entry), remaining_args[0]);
					else gtk_entry_set_text (GTK_ENTRY (file_entry), subfield[1]);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"Style"))
				{
					if (e == 6) e=option_style(subfield[1]);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"PositionX"))
				{
					if (x_position != -65536) px=x_position;
					else px=spi(subfield[1], 10);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"PositionY"))
				{
					if (y_position != -65536) py=y_position;
					else py=spi(subfield[1], 10);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"ScaleX"))
				{
					if (x_scale != -1) cx=x_scale;
					else cx=g_strtod (subfield[1],NULL);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"ScaleY"))
				{
					if (y_scale != -1) cy=y_scale;
					else cy=g_strtod (subfield[1],NULL);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"Width"))
				{
					if (width != -65536) screenw=width;
					else screenw=spi(subfield[1], 10);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"Height"))
				{
					if (height != -65536) screenh=height;
					else screenh=spi(subfield[1], 10);
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"BackgroundColor"))
				{
					if (background_color != 0)
					{					
						gdk_color_parse (background_color, &color);
						gtk_color_button_set_color (GTK_COLOR_BUTTON(cbutton), &color);
					}
					else
					{
						gdk_color_parse (subfield[1], &color);
						gtk_color_button_set_color (GTK_COLOR_BUTTON(cbutton), &color);
					}
					par_counter++;
				}
				if (!g_ascii_strcasecmp(subfield[0],"Command")) gtk_entry_set_text (GTK_ENTRY (com_entry), subfield[1]);
				if (!g_ascii_strcasecmp(subfield[0],"DefaultFile")) gtk_entry_set_text (GTK_ENTRY (def_entry), subfield[1]);
				if (!g_ascii_strcasecmp(subfield[0],"Interpolation")) interpolation = option_interpolation(subfield[1]);
				g_strfreev (subfield);
			
			}
			t=0;
		}
		g_free (other);
		g_strfreev (field);
	}
	if (anypaperrc == FALSE)
	{
		if (e==6) e=0;
		style(e, px, py, cx, cy, par_counter, gtk_entry_get_text (GTK_ENTRY (file_entry)));
	}
	else
	{
		interpolation_set (interpolation);
		gtk_combo_box_set_active (GTK_COMBO_BOX (combo_interpolation), interpolation);
	}
}

void write_parameters()
{
	gchar *buffer, *style, *interpolation, *background, *filename;
	gdouble cx, cy;
	int buf;

	cx = gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin5));
	cy = gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin6));
	background = g_strndup (string_background,6);
	buf = gtk_combo_box_get_active (GTK_COMBO_BOX (combo));
	if (buf == 0) style=g_strdup_printf("Fullscreen");
	if (buf == 1) style=g_strdup_printf("Normal");
	if (buf == 2) style=g_strdup_printf("Tile");
	if (buf == 3) style=g_strdup_printf("Adjust");
	if (buf == 4) style=g_strdup_printf("Scale");
	if (buf == 5) style=g_strdup_printf("Custom_Scale");
	if (buf == 5)
	{
		cx = gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin5));
		cy = gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin6));
	}
	else
	{
		cx = 1;
		cy = 1;
	}
	buffer=g_strdup_printf("\
File:                   %s\n\
Style:                  %s\n\
PositionX:              %d\n\
PositionY:              %d\n\
ScaleX:			%f\n\
ScaleY:			%f\n\
Width:                  %d\n\
Height:                 %d\n\
BackgroundColor:        #%s\n", gtk_entry_get_text (GTK_ENTRY (file_entry)), style, ox, oy, cx, cy, screenw, screenh, background);
	if (lastwallpaperfile != 0) filename = g_strdup_printf("%s",lastwallpaperfile);
	else filename = g_strdup_printf("%s/.anypaper/lastwallpaper", g_get_home_dir ());
	g_file_set_contents (filename, buffer, -1, NULL);
	g_free (buffer);
	g_free (filename);
	buf = gtk_combo_box_get_active (GTK_COMBO_BOX (combo_interpolation));
	if (buf == 0) interpolation=g_strdup_printf("GDK_INTERP_NEAREST");
	if (buf == 1) interpolation=g_strdup_printf("GDK_INTERP_TILES");
	if (buf == 2) interpolation=g_strdup_printf("GDK_INTERP_BILINEAR");
	if (buf == 3) interpolation=g_strdup_printf("GDK_INTERP_HYPER");
	buffer=g_strdup_printf("\
Command:                   %s\n\
DefaultFile:               %s\n\
Interpolation:             %s\n", gtk_entry_get_text (GTK_ENTRY (com_entry)), gtk_entry_get_text (GTK_ENTRY (def_entry)), interpolation);
	if (rcfile != 0) filename = g_strdup_printf("%s", rcfile);
	else filename = g_strdup_printf("%s/.anypaper/anypaperrc", g_get_home_dir ());
	g_file_set_contents (filename, buffer, -1, NULL);
	g_free (buffer);
	g_free (filename);
}

void first_use()
{
	gchar *buffer, *filename;

	filename = g_strdup_printf("%s/.anypaper", g_get_home_dir ());
	g_mkdir(filename, 0777);
	g_free (filename);
	buffer=g_strdup_printf("\
File:                   " ANYPAPER_DATA "noimage.png\n\
Style:                  Fullscreen\n\
PositionX:              0\n\
PositionY:              0\n\
ScaleX:			1\n\
ScaleY:			1\n\
Width:                  %d\n\
Height:                 %d\n\
BackgroundColor:        #000000\n", screenw, screenh);
	filename = g_strdup_printf("%s/.anypaper/lastwallpaper", g_get_home_dir ());
	g_file_set_contents (filename, buffer, -1, NULL);
	g_free (buffer);
	g_free (filename);
	buffer=g_strdup_printf("\
Command:                   Set_Command\n\
DefaultFile:               %s\n\
Interpolation:             GDK_INTERP_BILINEAR\n", g_strdup_printf("%s/.anypaper/output.png", g_get_home_dir ()));
	filename = g_strdup_printf("%s/.anypaper/anypaperrc", g_get_home_dir ());
	g_file_set_contents (filename, buffer, -1, NULL);
	g_free (buffer);
	g_free (filename);
}
