 /* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __SERVER_HPP
#define __SERVER_HPP

#include "include.hpp"
#include "error.hpp"
#include "object.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Connection to a database server.
    @date Sun Feb 19 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class Server: public Object
{
public:
  /** Constructor for server object.
      @param _userName Name of database user. */
  Server( const std::string &_userName ) throw (Error):
    userName( _userName ) {}
  ///
  const std::string &getUserName(void) const { return userName; }
protected:
  ///
  std::string userName;
};

/// Smart-Pointer referencing a MySQL-server.
typedef boost::shared_ptr< Server > ServerPtr;

///@}

#endif
