/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <sqlext.h>
#include "odbcResultRow.hpp"

ODBCResultRow::ODBCResultRow( SQLHSTMT aStatement ):
  statement( aStatement )
{
  assert( statement );
}

std::string ODBCResultRow::operator[]( int i ) throw (Error)
{
  ERRORMACRO( statement != NULL, Error, ,
              "Handle of SQL-query was invalidated. Probably "
              "ODBCStatement::~ODBCStatement called before finishing "
              "reading out the results." );
  SQLCHAR result[ 65536 ];
#ifdef SQLLEN
  SQLLEN length;
#else
  long length;
#endif

  SQLGetData( statement, i + 1, SQL_C_CHAR, (SQLPOINTER)result,
              sizeof(result), &length );
  assert( length < (signed)sizeof(result) );

  assert( sizeof(SQLCHAR) == sizeof(char) );
  if ( length != SQL_NULL_DATA )
    return std::string( (char *)result );
  else
    return std::string();
}
